program ChkLinks;

uses
  SysUtils,
  ShellLnk,
  Dialogs;

{$R *.RES}

var
  SearchRec: TSearchRec;
  PBShellLink: TPBShellLink;

begin
  if (ParamCount = 0) or (ParamStr(1) = '/?') then begin
    writeln('CHKLINKS: Checks a folder for links pointing to invalid programs');
    writeln('          and deletes them. - v1.1, 26 February 1997');
    writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
    writeln;
    writeln('SYNTAX: CHKLINKS "<folder name>"');
  end else
    writeln('Checking in ' + ParamStr(1) + ' for invalid links...');

  PBShellLink := TPBShellLink.Create(Nil);

  if FindFirst(ParamStr(1)+'\*.lnk',0,SearchRec)=0 then repeat
    PBShellLink.FileName := ParamStr(1)+'\'+SearchRec.Name;
    PBShellLink.Read;
    if not FileExists(PBShellLink.Target) then
      DeleteFile(ParamStr(1)+'\'+SearchRec.Name);
  until FindNext(SearchRec) <> 0;
  FindClose(SearchRec);

  if FindFirst(ParamStr(1)+'\*.pif',0,SearchRec)=0 then repeat
    PBShellLink.FileName := ParamStr(1)+'\'+SearchRec.Name;
    PBShellLink.Read;
    if not FileExists(PBShellLink.Target) then
      DeleteFile(ParamStr(1)+'\'+SearchRec.Name);
  until FindNext(SearchRec) <> 0;
  FindClose(SearchRec);

  PBShellLink.Free;
end.
