
{***************************************************************}
{ ADOvsql Visual Query Parser v1.0 for Delphi(r) Programmers    }
{ ADO Compatible version                                        }
{ packaged as TADOVSQL Visual Component.                         }
{ Copyright (c) 1998/2000 Business Software                     }
{                    bsoft@totalise.co.uk                       }
{ Source Code Supplied as Registered User Package.              }
{ Form Component 'wrapper' for TADOvsql component in vsqla1.pas   }
{***************************************************************}
unit adoVSQL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  DBTables,DB, Controls, Forms, Dialogs,adoDB,vsqla1;

type
  TADOvsql = class(TComponent)
  private
  FADOQuery:TADOquery;
  FCaption:string;
  procedure setquery(value:TADOQuery);
  function getquery:TADOQuery;
  procedure setproperties;

  protected
  procedure OpenDB;

  public
  function showmodal:boolean;
  procedure show;
  constructor Create(AOwner: TComponent); override;
  destructor destroy; override;

  published
  property ADOQuery:TADOQuery read getquery write setquery;
  property Caption:string read FCaption write FCaption;
  end;

var vsqla:tvsqla;


procedure Register;

implementation

procedure Register;
begin
RegisterComponents('ADO', [TADOvsql]);
end;


constructor TADOvsql.create(aOwner:Tcomponent);
begin
inherited create(aowner);
FCaption:='VSQL: Visual SQL Parser v1.0 (ADO)';
end;


{open as modal style dialog}
function TADOvsql.showmodal:boolean;
begin
result:=false;
if (FADOQuery=nil) then showmessage('ADOQuery Property'+#13+'not assigned!') else
   begin
   vsqla:=TVSQLa.create(application);
       try
       setproperties;
       result:=(vsqla.showmodal=mrOK);
       finally
       vsqla.free;
       vsqla:=nil;
       end;
   end;
end;

{open as non-modal dialog}
procedure TADOvsql.show;
begin
if (FADOQuery=nil) then showmessage('ADOQuery Property'+#13+'not assigned!') else
  begin
  if (vsqla=nil) then  {check if one prepared earlier, if not then create one}
     begin
     vsqla:=tvsqla.create(application); {freed when application closes}
     setproperties;
     end;
       try
        vsqla.show;
        except
        vsqla.free;
        vsqla:=nil;
        end;
  end;
end;

procedure TADOvsql.openDB;
begin
vsqla.OpenDB;
end;

procedure TADOvsql.setproperties;
begin
vsqla.ADOquery:=fADOquery;
vsqla.caption:=FCaption;
vsqla.opendb;
end;

procedure TADOvsql.setquery(value:TADOQuery);
begin
fADOquery:=value;
end;

function TADOvsql.getquery:TADOQuery;
begin
result:=fADOquery;
end;

destructor TADOvsql.destroy;
begin
{}
inherited destroy;
end;


end.
