unit RegExp;

interface

type
TRegExpRec = record
  rstart  : integer;
  rlength : integer;
  end;

type
  PRegExpRec  = ^TRegExpRec;
  PPRegExpRec  = ^PRegExpRec;

type
  HRegexp = PRegExpRec; { handle to a regular expression search }

  TRegMatch = record    { search match record }
    Start:  Word;       { 0-based start of match }
    Stop:   Word;       { End of match: points to 1st nonmatch }
    RStart: Word;       { 1-based start}
    RLength: Word;      { Length of match: Stop = Start + Length }
  end;

function RegComp(Pattern: PChar; var Error: integer): HRegexp;        pascal;
function RegExec(Regex: HRegexp; Str: PChar; var Match: TRegMatch): integer; pascal;
procedure RegFree(var Regex: HRegexp); pascal;

implementation

function  RegErrorNo: integer;                                      pascal; external 'REGEXP32.DLL' name 'REGERRORNO';
function  RegComp32(exp: pchar): PRegExpRec;                        pascal; external 'REGEXP32.DLL' name 'REGCOMP';
function  RegExec32(prog: PRegExpRec; matchstring: pchar): integer; pascal; external 'REGEXP32.DLL' name 'REGEXEC';
procedure RegFree  (var RegEx: HRegExp);                            pascal; external 'REGEXP32.DLL' name 'REGFREE';

function RegComp(Pattern: PChar; var Error: integer): HRegexp;

begin
Result := RegComp32(Pattern);
if Result = nil then
  Error := RegErrorNo
else
  Error := 0;
end;

function RegExec(Regex: HRegexp; Str: PChar; var Match: TRegMatch): integer;

begin
Result := 1 - RegExec32(Regex, Str);
if Result = 0 then
  begin
  Match.RStart := RegEx.rlength;
  Match.RLength:= RegEx.rlength;
  Match.Start  := RegEx.rstart - 1;
  Match.Stop   := Match.Start + Match.RLength;
  end;
end;

initialization

end.


