unit RegExp;

interface

type
  HRegexp = word;       { handle to a regular expression search }

  TRegMatch = record    { search match record }
    Start: Word;        { Start of match }
    Stop:  Word;        { End of match }
  end;

function RegComp(Pattern: PChar; var Error: integer): HRegexp;
function RegExec(Regex: HRegexp; Str: PChar; var Match: TRegMatch): integer;
function RegError(Regex: HRegexp; Error: integer; ErrorBuf: array of Char):
    integer;
procedure RegFree(Regex: HRegexp);

implementation

procedure RegFree;              external 'REGEXP';
function RegError;              external 'REGEXP';
function RegExec;               external 'REGEXP';
function RegComp;               external 'REGEXP';

end.
