unit WaveDev;

{  ******
   *
   * Module:    WaveDev
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    The TWaveMixOutput device is a very simple but functional class for
   *    sound output.
   *
   ****** }

interface
uses SoundDev, MPlayer, Forms, WinTypes, MMSystem;

type TWaveMixOutput = class(TSoundDevice)
    public
        { Public constructor and destructor. }
        constructor Create;
        destructor Destroy;

        { Overridden sound device methods. }
        procedure PlaySound(szSound: String; iChannel: Integer); Override;
        function iChannelsSupported: Integer; Override;

    private
        m_hSession: THandle;    { WaveMix session handle. }
end;

implementation

constructor TWaveMixOutput.Create;
begin
    { Perform default processing. }
    inherited Create;
end;

destructor TWaveMixOutput.Destroy;
begin
    { Perform default exit processing. }
    inherited Destroy;
end;

procedure TWaveMixOutput.PlaySound(szSound: String; iChannel: Integer);
begin
    { Play the sound, if sound is enabled. }
    if (bSoundEnabled = True) then
        sndPlaySound(PChar(szSound), SND_ASYNC);
end;

function TWaveMixOutput.iChannelsSupported: Integer;
begin
    Result := 1;
end;

end.
