program Rocks;

{ $N+ }

uses
  Forms,
  Bart in 'BART.PAS',
  Constant in 'CONSTANT.PAS',
  Edge in 'EDGE.PAS',
  MatCtrl in 'MATCTRL.PAS',
  Matrix2D in 'MATRIX2D.PAS',
  Visible in 'VISIBLE.PAS',
  Vertex in 'VERTEX.PAS',
  Asteroid in 'ASTEROID.PAS',
  Missle in 'MISSLE.PAS',
  General in 'GENERAL.PAS',
  Scrap in 'SCRAP.PAS',
  Score in 'SCORE.PAS',
  Text in 'TEXT.PAS',
  High in 'HIGH.PAS',
  About in 'ABOUT.PAS' {AboutBox},
  alien in 'ALIEN.PAS',
  State in 'STATE.PAS',
  MultiCh in 'MULTICH.PAS',
  StateCh in 'STATECH.PAS',
  MainForm in 'MAINFORM.PAS' {RocksForm},
  keys in 'KEYS.PAS' {KeySelection},
  GameCtl in 'GAMECTL.PAS',
  Input in 'INPUT.PAS',
  Keyboard in 'KEYBOARD.PAS',
  RocksKbd in 'ROCKSKBD.PAS',
  Message in 'MESSAGE.PAS',
  InpCodes in 'INPCODES.PAS',
  SoundDev in 'SOUNDDEV.PAS',
  WaveDev in 'WAVEDEV.PAS',
  Global in 'GLOBAL.PAS',
  GameEnv in 'GAMEENV.PAS',
  VideoDev in 'VIDEODEV.PAS',
  CanvsVid in 'CANVSVID.PAS',
  AppEnv in 'APPENV.PAS',
  ShapeLib in 'SHAPELIB.PAS',
  Shape in 'SHAPE.PAS',
  InputDev in 'INPUTDEV.PAS';

{$R *.RES}

var
    frmMainForm: TRocksForm;      { Main form. }

begin
   { Construct the global environment object.  This object controls the INI
     settings, and contains pointers to input and output device objects. }
   g_envEnviron := TGameEnvironment.Create('Rocks.Ini', nil, nil, nil);

   { Create the main form now, since our video output is dependent upon it. }
   Application.CreateForm(TRocksForm, frmMainForm);
  g_envEnviron.SetInputDevice(TRocksKeyboard.Create);
   g_envEnviron.SetSoundDevice(TWaveMixOutput.Create);
   g_envEnviron.SetVideoDevice(TCanvasVideo.Create(frmMainForm,
                                                   INTERNAL_SCREEN_WIDTH,
                                                   INTERNAL_SCREEN_HEIGHT));

   { Show the main application form and start the application message pump.}
   frmMainForm.StartGameEngine;
   Application.Run;

   { Free our main form object. }
   frmMainForm.Free;

   { Destroy the I/O objects that we created during construction. }
   g_envEnviron.devGetSoundDevice.Free;
   g_envEnviron.devGetVideoDevice.Free;
   g_envEnviron.devGetInputDevice.Free;

   { Free the master environment object. }
   g_envEnviron.Free;
end.
