{$APPTYPE CONSOLE}
program DemoDebug;
uses
  Classes,
  passcr;
const
  TraceMode = tmTraceInto;
var
  PasScript: TPasScript;
  K, StartPos, NewPos: Integer;
  R: boolean;

procedure PrintStep;
var
  FileName, Line: String;
begin
  if NewPos > 0 then
  begin
    FileName := PasScript.GetSourceFileName(NewPos);
    Line := PasScript.GetSourceLine(NewPos);
    writeln(K, ' ', FileName, ' ', Line);
  end;
end;

var
  CallStack: TStringList;
  S: String;
begin
  PasScript := TPasScript.Create(nil);
  with PasScript do
  begin
    ScriptFileName := 'fact.pas';
    Parse;
    InitDebug;

    StartPos := 0;

    K := 1;

    R := Trace(tmTraceInto, StartPos, NewPos);
    PrintStep;

    while NewPos <> 0 do
    begin
      Inc(K);
      StartPos := NewPos;

      R := Trace(TraceMode, StartPos, NewPos);

      if not R then Break;

      PrintStep;
    end;

    StartPos := GetPCodeLineNumber('fact.pas', 6); // "result := 1" in "fact.pas"
    AddBreakPoint(StartPos);

    writeln(StartPos);  // Breakpoint at PCode line number = 15

    // run to the breakpoint
    Trace(tmNoTrace, 0, NewPos);

    writeln(NewPos);    // NewPos = 15

    PrintStep;

    EvalExpression('N', NewPos, S); // evaluate expression at the p-code line
    writeln('N = ', S);

    CallStack := GetCallStack;
    if Assigned(CallStack) then
    begin
      writeln('Call stack:');
      for K:=0 to CallStack.Count - 1 do
        writeln(CallStack[K]);
      CallStack.Free;  
    end;

    Free;
  end;

  writeln('Press Enter key...');
  Readln;
end.