unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  combobex, ImgList, StdCtrls, ExtCtrls, Commctrl, ComCtrls, registry;

type
  TForm1 = class(TForm)
    ImageList1: TImageList;
    ImageList2: TImageList;
    AWComboBoxEx2: TAWComboBoxEx;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    AWComboBoxEx1: TAWComboBoxEx;
    btClearAll: TButton;
    btClearList: TButton;
    btPopulate: TButton;
    btCallBack: TButton;
    btInsert: TButton;
    Label1: TLabel;

    procedure btClearAllClick(Sender: TObject);
    procedure btClearListClick(Sender: TObject);
    procedure btCallBackClick(Sender: TObject);
    procedure AWComboBoxEx1RequestIndentEvent(Sender: TObject;
      Index: Integer; var noMoreRequests: Boolean;
      var indentValue: Integer);

    procedure AWComboBoxEx1RequestTextEvent(Sender: TObject;
      Index: Integer; var noMoreRequests: Boolean; var strValue: String);
    procedure AWComboBoxEx1RequestSelectImageEvent(Sender: TObject;
      Index: Integer; var noMoreRequests: Boolean;
      var imageNumber: Integer);
    procedure FormCreate(Sender: TObject);
    procedure AWComboBoxEx1RequestImageEvent(Sender: TObject;
      const Index: Integer; var noMoreRequests: Boolean;
      var imageNumber: Integer);
    procedure btPopulateClick(Sender: TObject);
    procedure btInsertClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btClearAllClick(Sender: TObject);
begin
     AWComboBoxEx1.Clear;
end;

procedure TForm1.btClearListClick(Sender: TObject);
begin
    AWcomboBoxEx1.items.Clear;
end;

procedure TForm1.btCallBackClick(Sender: TObject);
var
  cbItem : TComboBoxExItem;
begin
         cbItem.mask := CBEIF_TEXT or CBEIF_INDENT or CBEIF_IMAGE or CBEIF_SELECTEDIMAGE;
         cbItem.iItem := 0; // Any Value here
         cbItem.pszText := LPSTR_TEXTCALLBACK;
         cbItem.cchTextMax := 0;
         cbItem.iImage := I_IMAGECALLBACK;
         cbItem.iSelectedImage :=I_IMAGECALLBACK;
         cbItem.iOverlay := 0;  // Not used
         cbItem.iIndent := I_INDENTCALLBACK;
         AWComboBoxEx1.items.add (cbItem);
end;

procedure TForm1.AWComboBoxEx1RequestTextEvent(Sender: TObject;
  Index: Integer; var noMoreRequests: Boolean; var strValue: String);
const
  rdArray:array[0..5] of string=('f0','f1','f2','f3','f4','f5');
var
  rdValue : integer;
begin
    rdValue :=trunc(6*random);
    strValue:=rdArray[rdvalue];
//  noMoreRequests:=true; // To stop it
end;

procedure TForm1.AWComboBoxEx1RequestSelectImageEvent(Sender: TObject;
  Index: Integer; var noMoreRequests: Boolean; var imageNumber: Integer);
begin
     imageNumber := trunc (random * 8);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
    awcomboboxex2.itemindex:=0;
end;

procedure TForm1.AWComboBoxEx1RequestIndentEvent(Sender: TObject;
  Index: Integer; var noMoreRequests: Boolean; var indentValue: Integer);
begin
    indentvalue:= trunc (random * 9);
end;

procedure TForm1.AWComboBoxEx1RequestImageEvent(Sender: TObject;
  const Index: Integer; var noMoreRequests: Boolean;
  var imageNumber: Integer);
begin
      imageNumber := trunc (random * 8) +1;
end;

procedure TForm1.btPopulateClick(Sender: TObject);
const
  countries:array[0..8] of string = ('Australia','Denmark','Italy','Japan',
                              'Norway','Portugal','Spain','United Kingdom','United States');
  indent : array[0..8] of integer = (0,2,4,6,8,6,4,2,0);
var
  mask : Uint;
  i : integer;
begin
   mask := CBEIF_TEXT or CBEIF_INDENT or CBEIF_IMAGE or CBEIF_SELECTEDIMAGE;
   for i:=0 to 8 do
   begin
     AWComboBoxEx1.Items.Add(mask, countries[i], 0, i+1, 0, 0, indent[i]);
   end;
   AwComboBoxEx1.Text := 'Repopulated';
end;

procedure TForm1.btInsertClick(Sender: TObject);
var
   mask : Uint;
   cbItem : TComboBoxExItem;
begin
   mask := CBEIF_TEXT or CBEIF_INDENT or CBEIF_IMAGE or CBEIF_SELECTEDIMAGE;
   // Testing both insertion ways
   // First way
   AWComboBoxEx1.Items.Insert(mask, 4, 'New Item @4', 0, 1, 0, 0, 10);
   // Second way
   fillchar(cbItem, sizeof(cbItem),0);
   cbItem.mask := mask;
   cbItem.iItem := 5;
   cbItem.pszText := 'New Item @5';
   cbItem.iImage := 2;
   cbItem.iIndent := 10;
   AWComboBoxEx1.Items.insert(cbItem);
end;

end.
