// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxftp.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/23/2001
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

File Transfer Protocol (FTP) classes used with applications
that require use of embedded FTP client/server functions.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <stdio.h>
#include "gxsftp.h"

gxSocketError gxsFTPClient::ConnectClient(const char *host, int port)
// Function used to connect a FTP client to a server. Returns zero if no
// errors occur.
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_STREAM, port, (char *)host) < 0) return socket_error;
  }
  else {
    return socket_error;
  }

  if(Connect() < 0) return socket_error;

  // Read the server's response
  if(!RecvResponse(reply_buf, gxsBUF_SIZE, "220 ")) return socket_error;

  return socket_error = gxSOCKET_NO_ERROR;
}

gxSocketError gxsFTPClient::SendCommand(const char *command, 
					const char *response, 
					const char *args)
// Function used to send a command to an FTP server and read the server's
// response. Returns zero if no errors occur.
{
  if(args) {
    sprintf(command_buf, "%s %s\r\n", command, args);
  }
  else {
    sprintf(command_buf, "%s\r\n", command);
  }
  int len = strlen(command_buf);
  
  // Send command using a blocking write
  if(Send(command_buf, len) < 0) return socket_error;
  
  // Read the server's response
  if(!RecvResponse(reply_buf, gxsBUF_SIZE, response)) return socket_error;
  return socket_error = gxSOCKET_NO_ERROR;
}


gxSocketError gxsFTPClient::FTPLogin(const char *username, 
				     const char *password) 
// Function used to logon to an FTP server. Returns zero 
// if no errors occur.
{
  if(SendCommand("USER", "331", username) != gxSOCKET_NO_ERROR) 
    return socket_error;
  if(SendCommand("PASS", "230", password) != gxSOCKET_NO_ERROR) 
    return socket_error;
  return socket_error = gxSOCKET_NO_ERROR;
}

gxSocketError gxsFTPClient::FTPLogout()
// Function used to send the FTP "bye" command. Returns zero if
// no errors occur.
{
  return SendCommand("QUIT", "221");
}

gxSocketError gxsFTPClient::FTPImageType(char type)
{
  if(type == 'a' || type == 'A') // ASCII
    return SendCommand("TYPE", "200", "A");
  else // Default to binary
    return SendCommand("TYPE", "200", "I");
}

gxSocketError gxsFTPClient::FTPChDir(const char *dname)
{
  return SendCommand("CWD", "250", dname);
}

gxSocketError gxsFTPClient::FTPPWD()
{
  return SendCommand("PWD", "257");
}

gxSocketError gxsFTPClient::FTPStat()
{
  return SendCommand("STAT", "211 ");
}

gxSocketError gxsFTPClient::FTPMkDir(const char *dname)
{
  return SendCommand("MKD", "257", dname);
}

gxSocketError gxsFTPClient::FTPRmDir(const char *dname)
{
  return SendCommand("RMD", "250", dname);
}

gxSocketError gxsFTPClient::FTPSize(const char *fname)
{
  return SendCommand("SIZE", "213", fname);
}

gxSocketError gxsFTPClient::FTPDelete(const char *fname)
{
 return SendCommand("DELE", "250", fname);
}

gxSocketError gxsFTPClient::FTPMove(const char *from, const char *to)
{
  if(SendCommand("RNFR", "350", from) != gxSOCKET_NO_ERROR) 
    return socket_error;
  return SendCommand("RNTO", "250", to);
}

gxSocketError gxsFTPClient::FTPGet(const char *fname, fstream &stream,
				   unsigned &bytes)
{
  char get_buf[gxsBUF_SIZE];
  bytes = 0;
  sprintf(get_buf, "RETR %s", fname);
  if(OpenDataPort() != gxSOCKET_NO_ERROR) return socket_error; 

  char rx_buf[gxsBUF_SIZE]; // Receive buffer
  int reply_byte_count = 0; // Reply byte counter
  int num_read = 0;         // Actual number of bytes read
  
  if(SendCommand(get_buf, "150") != gxSOCKET_NO_ERROR) {
    CloseDataPort();
    return socket_error; 
  }

  reply_buf[0] = 0; // Reset the reply buffer

  // Block execution until data is received
  if(ftp_data.Accept() < 0) {
    CloseDataPort();
    return SetSocketError(ftp_data.GetSocketError());
  }

  while(1){
    num_read = ReadDataPort(rx_buf, sizeof(rx_buf));
    if(num_read > 0) {
      stream.write(rx_buf, num_read);
      if(!stream.good()) { // An I/O error occurred
	if(stream.eof()) { // End of the file error
	  CloseDataPort();
	  return socket_error = gxSOCKET_FILESYSTEM_ERROR;
	}
	if(stream.bad()) { // The I/O error was fatal
	  CloseDataPort();
	  return socket_error = gxSOCKET_FILESYSTEM_ERROR;
	}
	// Continue processing if the error was not fatal
      }
	bytes += num_read;
    }
    else {
      break;
    }
  }
  if(num_read < 0) {
    CloseDataPort();
    return socket_error = gxSOCKET_RECEIVE_ERROR;
  }

  // Close the data port before the next read
  CloseDataPort();

  // Read the server's reply
  reply_byte_count = RawRead(reply_buf, sizeof(reply_buf));
  if(reply_byte_count < 0) {
    return socket_error = gxSOCKET_RECEIVE_ERROR;
  }
  reply_buf[reply_byte_count] = 0; // Null terminate the reply buffer
  return socket_error = gxSOCKET_NO_ERROR;
}

gxSocketError gxsFTPClient::FTPPut(const char *fname, fstream &stream,
				   unsigned &bytes)
{
  char put_buf[gxsBUF_SIZE];
  char tx_buf[gxsBUF_SIZE];
  bytes = 0;
  sprintf(put_buf, "STOR %s", fname);
  if(OpenDataPort() != gxSOCKET_NO_ERROR) return socket_error; 

  if(SendCommand(put_buf, "150") != gxSOCKET_NO_ERROR) {
    CloseDataPort();
    return socket_error; 
  }

  reply_buf[0] = 0; // Reset the reply buffer

  // Block execution until data is received
  if(ftp_data.Accept() < 0) {
    CloseDataPort();
    return SetSocketError(ftp_data.GetSocketError());
  }

  while(!stream.eof()) {
    stream.read(tx_buf, gxsBUF_SIZE);
    if(!stream.good()) { // An I/O error occurred
      if(stream.bad()) { // The I/O error was fatal
	CloseDataPort();
	return socket_error = gxSOCKET_FILESYSTEM_ERROR;
      }
      // Continue processing if the error was not fatal
    }
    unsigned byte_count = unsigned(stream.gcount());
    if(WriteDataPort(tx_buf, byte_count) < 0) {
      CloseDataPort();
      return socket_error;
    }
    bytes += byte_count;
  }
  CloseDataPort();
  return socket_error = gxSOCKET_NO_ERROR;
}

gxSocketError gxsFTPClient::FTPList(char *sbuf, unsigned bytes, int full,
				    const char *args)
// FTP command used to list the contents of the current working
// directory. Returns zero if no errors occur.
{
  char ls_buf[gxsBUF_SIZE];

  if(full) {
    if(args) {
      sprintf(ls_buf, "LIST %s", args);
    }
    else {
      strcpy(ls_buf, "LIST");
    }
  }
  else {
    if(args) {
      sprintf(ls_buf, "NLST %s", args);
    }
    else {
      strcpy(ls_buf, "NLST");
    }
  }

  if(OpenDataPort() != gxSOCKET_NO_ERROR) return socket_error; 

  int byte_count = 0;       // Data port byte counter
  int reply_byte_count = 0; // Reply byte counter
  int num_read = 0;         // Actual number of bytes read
  int num_req = (int)bytes; // Number of bytes requested 
  char *p = sbuf;           // Pointer to the buffer
  
  if(SendCommand(ls_buf, "150") != gxSOCKET_NO_ERROR) {
    CloseDataPort();
    return socket_error; 
  }

  reply_buf[0] = 0; // Reset the reply buffer

  // Block execution until data is received
  if(ftp_data.Accept() < 0) {
    CloseDataPort();
    return SetSocketError(ftp_data.GetSocketError());
  }
  
  while(byte_count < (int)bytes) { // Loop until the buffer is full
    num_read = ReadDataPort(p, num_req-byte_count);
    if(num_read > 0) {
       byte_count += num_read; // Increment the byte counter
       if(byte_count >= (int)bytes) {
	 // The receieve buffer is full - buffer overflow
	 if(byte_count >= 0) sbuf[byte_count] = 0;
	 CloseDataPort();
	 return socket_error = gxSOCKET_BUFOVER_ERROR;
       } 
       p += num_read; // Move the buffer pointer for the next read
       if(num_read < 0) {
	 if(byte_count >= 0) sbuf[byte_count] = 0;
	 CloseDataPort();
	 return socket_error = gxSOCKET_RECEIVE_ERROR;
      }
    }
    else {
      break;
    }
  }
  
  // Null terminate the string buffer
  if(byte_count >= 0) sbuf[byte_count] = 0;

  if(num_read < 0) {
    CloseDataPort();
    return socket_error = gxSOCKET_RECEIVE_ERROR;
  }

  // Close the data port before the next read
  CloseDataPort();

  // Read the server's reply
  reply_byte_count = RawRead(reply_buf, sizeof(reply_buf));
  if(reply_byte_count < 0) {
    return socket_error = gxSOCKET_RECEIVE_ERROR;
  }
  reply_buf[reply_byte_count] = 0; // Null terminate the reply buffer
  return socket_error = gxSOCKET_NO_ERROR;
}

gxSocketError gxsFTPClient::OpenDataPort()
{
  if(ftp_data.InitSocket(SOCK_STREAM, 0) < 0) {
    return SetSocketError(ftp_data.GetSocketError());
  }
  int reuse_opt = 1;
  if(ftp_data.SetSockOpt(SOL_SOCKET, SO_REUSEADDR, 
			 &reuse_opt, sizeof(reuse_opt)) < 0) {
    return SetSocketError(ftp_data.GetSocketError());
  }
  if(ftp_data.Bind() < 0) { // Bind the socket
    return SetSocketError(ftp_data.GetSocketError());
  }
  if(ftp_data.GetSockName() < 0) {
    return SetSocketError(ftp_data.GetSocketError());
  }	      
  if(ftp_data.Listen(1) < 0) { // Listen for connection
    return SetSocketError(ftp_data.GetSocketError());
  }

  // Get this machine's IP address and send it to the FTP server
  char hostname[gxsMAX_NAME_LEN];
  if(GetHostName(hostname) < 0) return socket_error;
  gxsHostNameInfo *hostinfo = GetHostInformation(hostname);
  if(!hostinfo) {
    return socket_error = gxSOCKET_HOSTNAME_ERROR;
  }
  for(int i = 0; ; i++) {
    gxsInternetAddress *ialist = \
      (gxsInternetAddress *)hostinfo->h_addr_list[i];
    if(ialist == 0) break;
    memmove(&ftp_data.sin.sin_addr.s_addr, ialist, sizeof(gxsInternetAddress));
  }
  delete hostinfo;
  char *a = (char *) &ftp_data.sin.sin_addr;
  char *b = (char *) &ftp_data.sin.sin_port;

  char port_buf[gxsBUF_SIZE];
  sprintf(port_buf, "PORT %d,%d,%d,%d,%d,%d", (a[0]&0xff), (a[1]&0xff), 
	  (a[2]&0xff), (a[3]&0xff), (b[0]&0xff), (b[1]&0xff));

  // Port the client is listening on
  ftp_data_port = (int)ntohs(ftp_data.sin.sin_port); 
  
  // Send the port command
  if(SendCommand(port_buf, "200") != gxSOCKET_NO_ERROR) 
    return socket_error; 

  return socket_error = gxSOCKET_NO_ERROR;
}

void gxsFTPClient::CloseDataPort()
{
  ftp_data.Close();
  ftp_data_port = 0;
}

int gxsFTPClient::ReadDataPort(void *buf, unsigned bytes)
{
  return ftp_data.RawRemoteRead(buf, bytes); // Non-blocking read
}

int gxsFTPClient::WriteDataPort(void *buf, unsigned bytes)
{
  return ftp_data.RemoteSend(buf, bytes); // Blocking write
}

int gxsFTPClient::WaitForReply(gxsSocket_t s)
// Returns false if a reply time is longer then the timeout values. 
{
  return ReadSelect(s, time_out_sec, time_out_usec);
}

int gxsFTPClient::RecvResponse(char *buf, int bytes, const char *response)
{
  return RecvResponse(gxsocket, buf, bytes, response);
}

int gxsFTPClient::RecvResponse(gxsSocket_t s, char *buf, int bytes, 
			       const char *response)
// Blocking receive function used to read a reply from an FTP server
// following a command. If the specified response is not received within
// the timeout period this function will return false to indicate an error.
// Returns true if successful.
{
  int byte_count = 0;       // Byte counter
  int num_read = 0;         // Actual number of bytes read
  int num_req = (int)bytes; // Number of bytes requested 
  char *p = buf;            // Pointer to the buffer

  while(byte_count < bytes) { // Loop until the buffer is full
    if(!WaitForReply(s)) { 
      socket_error = gxSOCKET_REQUEST_TIMEOUT;      
      if(byte_count >= 0) buf[byte_count] = 0;
      return 0;
    }
    if((num_read = recv(s, p, num_req-byte_count, 0)) > 0) {
      byte_count += num_read; // Increment the byte counter
      p += num_read;          // Move the buffer pointer for the next read
      
      // Search for a matching string
      char *pattern = (char *)response;
      char *next = buf;
      int i = 0;
      while(i < byte_count && *pattern) {
	if(*next == *pattern) {
	  pattern++;
	  if(*pattern == 0) {
	    if(byte_count >= 0) buf[byte_count] = 0;
	    return 1; // Found matching string
	  }
	  next++;
	}
	else {
	  i++;
	  next++;
	  pattern = (char *)response;
	}
      } 
    }
    if(num_read < 0) {
      if(byte_count >= 0) buf[byte_count] = 0;
      socket_error = gxSOCKET_RECEIVE_ERROR;
      return 0; // An error occurred during the read
    }
  }

  // The receieve buffer is full - buffer overflow
  socket_error = gxSOCKET_BUFOVER_ERROR;
  if(byte_count >= 0) buf[byte_count] = 0;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
