// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxscomm.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxSerialComm class is a base class used to open a serial 
port for bidirectional communication. It includes several 
low-level functions needed by derived classes to initalize a 
serial port, transmit, and receive data.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_SCOMM_HPP__
#define __GX_SCOMM_HPP__

// Include files
#if defined (__WIN32__)
#include <windows.h>
#elif defined (__UNIX__)
#include <unistd.h>  // UNIX standard function definitions 
#include <termios.h> // POSIX terminal control definitions 
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

// Type definitions
#if defined (__WIN32__)
typedef HANDLE scommDeviceHandle;
#elif defined (__UNIX__)
typedef int scommDeviceHandle;
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

// Serial communications base class
class gxSerialComm
{
public: // Enumerations
  enum {
    // Internal error codes used to report the last error
    scomm_NO_ERROR  = 0,      // No errors reported
    scomm_INVALID_ERROR_CODE, // Invalid error code

    scomm_BAUDRATE_ERROR,    // Invalid baud rate
    scomm_CS_ERROR,          // Invalid character size
    scomm_FLOWCONTROL_ERROR, // Invalid flow control
    scomm_INIT_ERROR,        // Cannot initialize serial device
    scomm_INVALIDPARM,       // Invalid initialization parameter
    scomm_OPEN_ERROR,        // Cannot open serial device
    scomm_PARITY_ERROR,      // Invalid parity
    scomm_RECEIVE_ERROR,     // Serial device receive error
    scomm_STOPBIT_ERROR,     // Invalid stop bit
    scomm_TRANSMIT_ERROR,    // Serial device transmit error

    // Exception codes added to handle database block errors
    scomm_BLOCKACK_ERROR,    // Variable block acknowledgment error
    scomm_BLOCKHEADER_ERROR, // Bad database block header
    scomm_BLOCKSIZE_ERROR,   // Bad database block size
    scomm_BLOCKSYNC_ERROR    // Variable block synchronization error
  };
  
  enum {
    // Flow control constants
    scommHARD_FLOW,
    scommSOFT_FLOW,
    scommXON_XOFF,
    scommNO_FLOW_CONTROL,

    // Device access constants
    scommREAD_ONLY,
    scommWRITE_ONLY,
    scommREAD_WRITE
  };

public:
  gxSerialComm();
  virtual ~gxSerialComm();
  
public:
  int OpenSerialPort(char *device_name);
  int InitSerialPort();
  int InitSerialPort(char *device_name, int sp = 9600, char pr = 'N',
		     int cs = 8, int sb = 1,
		     int flow = gxSerialComm::scommNO_FLOW_CONTROL,
		     int bin_mode = 1);
  void Close();
  int RawRead(void *buf, int bytes);
  int RawWrite(const void *buf, int bytes);
  int Recv(void *buf, int bytes);
  int Send(const void *buf, int bytes);
  void SetBaudRate(int br) { baud_rate = br; }
  void SetCharacterSize(int cs) { character_size = cs; }
  void SetParity(char p) { parity = p; }
  void SetStopBits(int sb) { stop_bits = sb; }
  void SetFlowControl(int f) { flow_control = f; }
  scommDeviceHandle DeviceHandle() { return device_handle; }
  
  // NOTE: The Win32 API does not support non-binary mode transfers
  void BinaryMode() { binary_mode = 1; }
  void CharacterMode() { binary_mode = 0; }

  // Exception handling functions
  int GetSerialCommError() { return scomm_error; }
  int GetSerialCommError() const { return scomm_error; }
  void SetSerialCommError(int err) { scomm_error = err; }
  void ResetSerialCommError() { scomm_error = scomm_NO_ERROR; }
  void ResetError() { scomm_error = scomm_NO_ERROR; }
  const char *SerialCommExceptionMessage();
  
#if defined (__UNIX__)
  termios *GetTermIOS() { return &options; }
  int BytesRead() { return bytes_read; }
  int BytesMoved() { return bytes_moved; }
#endif

#if defined (__WIN32__)
  DCB *GetDeviceCB() { return &dcb; }
  DWORD BytesRead() { return bytes_read; }
  OVERLAPPED *Overlap() { return &ov; }
  DWORD BytesMoved() { return bytes_moved; }
  DWORD gxsGetLastError() { return last_err; }
#endif

protected:
  scommDeviceHandle device_handle; // Device handle for the port
  int baud_rate;      // Baud rate
  int character_size; // Character size
  char parity;        // Parity 
  int stop_bits;      // Stop bits
  int flow_control;   // Flow control
  int binary_mode;    // True to enable raw reads and raw writes
  int scomm_error;    // The last reported serial port error
  
protected: // POSIX terminal (serial) interface extensions
#if defined (__UNIX__)
  termios options; // Terminal control structure
  int bytes_read;  // Number of bytes read following a Read() call
  int bytes_moved; // Number of bytes written following a Write() call
#endif
  
protected: // WIN32 extensions
#if defined (__WIN32__)
  DCB dcb;           // Device-control block structure
  DWORD bytes_read;  // Address of number of bytes read following Read()
  OVERLAPPED ov;     // Pointer to structure needed for overlapped I/O  
  DWORD bytes_moved; // Pointer to number of bytes written following Write()
  DWORD last_err;    // Used to store the last error reported
#endif
};

#endif // __GX_SCOMM_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
