// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 06/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the MemoryBuffer class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "membuf.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  cout << "Testing MemoryBuffer constructors..." << endl;
  char *test_pattern = "The quick brown fox jumps over the lazy dog";
  char *test_message = "This is a test...";

  MemoryBuffer a((char *)test_pattern, strlen(test_pattern)+1);
  a[strlen(test_pattern)] = 0; // Null terminate the buffer
  cout << (char *)a << endl;
  
  MemoryBuffer b;

  MemoryBuffer c((char *)test_message, strlen(test_message)+1);
  c[strlen(test_message)] = 0; // Null terminate the buffer
  cout << (char *)c << endl;
  
  PausePrg();

  cout << "Testing overloaded assignment operators..." << endl;
  b = a;
  cout << (char *)b << endl;
  b = c;
  cout << (char *)b << endl;
  
  PausePrg();

  cout << "Testing copy constructor..." << endl;
  MemoryBuffer aa(a);
  cout << (char *)aa << endl;
  MemoryBuffer bb(b);
  cout << (char *)bb << endl;

  PausePrg();
  
  cout << "Testing overloaded += operator..." << endl;
  char *num_test = " 0123456789";
  MemoryBuffer sbuf((char *)test_pattern, strlen(test_pattern));
  MemoryBuffer buf((char *)num_test, strlen(num_test));
  sbuf += buf;
  sbuf += '\0'; // Null terminate the buffer
  cout << (char *)sbuf << endl;

  PausePrg();
  
  cout << "Testing concatenation..." << endl;
  char *s1 = "DOG "; char *s2 = "CAT "; char *s3 = "MOUSE";
  MemoryBuffer m1;
  m1.Load(s1, strlen(s1));
  m1.Cat(s2, strlen(s2));
  m1.Cat(s3, strlen(s3));
  m1.Cat('\0'); // Null terminate the buffer
  cout << (char *)m1 << endl;

  PausePrg();

  cout << "Testing find functions..." << endl;
  cout << "String = " << (char *)m1 << endl;
  if(m1.Find(s2, strlen(s2), 0) == -1)
    cout << "Pattern not found!" << endl;
  else
    cout << "Found pattern: " << s1 << endl;

  if(m1.Find(s3, strlen(s3), 0) == -1)
    cout << "Pattern not found!" << endl;
  else
    cout << "Found pattern: " << s3 << endl;

  cout << endl;

  cout << "Testing repeated pattern finding..." << endl;
  MemoryBuffer m2(c);
  cout << "String = " << (char *)m2 << endl;
  char *s4 = "is";
  unsigned Offset = 0;
  while(1) {
    Offset = m2.Find((char *)s4, strlen(s4), Offset);
    if (Offset == -1) break;
    cout << "Found pattern \"" << s4 << "\" at index: " << Offset << endl;
    Offset++;
  }

  PausePrg();

  cout << "Testing delete function..." << endl;
  MemoryBuffer x1(a);
  cout << (char *)x1 << endl;
  char *xx = "fox";
  int Index = x1.Find((char *)xx);
  cout << "Deleting fox from string..." << endl;
  x1.DeleteAt(Index, strlen(xx));
  cout << (char *)x1 << endl;

  PausePrg();

  cout << "Testing replace functions..." << endl;
  MemoryBuffer x2(a);
  cout << (char *)x2 << endl;
  char *xy = "cat";
  Index = x2.Find(xx);
  cout << "Replacing fox:" << endl;
  x2.ReplaceAt(Index, xy, strlen(xy));  
  cout << (char *)x2 << endl;
  cout << "Replacing jumps:" << endl;
  Index = x2.Find((void *)"jumps", strlen("jumps"));
  x2.ReplaceAt(Index, "runs ", strlen("runs "));
  cout << (char *)x2 << endl;

  MemoryBuffer x3((char *)"cow", 3);
  cout << "Replacing dog:" << endl;
  Index = x2.Find((void *)"dog");
  x2.ReplaceAt(Index, x3);
  cout << (char *)x2 << endl;
  
  PausePrg();
  
  cout << "Testing the insert functions..." << endl;
  MemoryBuffer x4(a);
  cout << (char *)x4 << endl;
  char *xz = "and yellow ";
  cout << "Inserting text into string:" << endl;
  Index = x4.Find(xx);
  x4.InsertAt(Index, xz, strlen(xz));
  cout << (char *)x4 << endl;
  Index = x4.Find((void *)"over");
  x4.InsertAt(Index, (char *)"around and ", strlen("around and "));
  cout << (char *)x4 << endl;

  MemoryBuffer x5((char *)"cow and ", strlen("cow and "));
  Index = x4.Find((void *)"dog");
  x4.InsertAt(Index, x5);
  cout << (char *)x4 << endl;

  PausePrg();
  
  cout << "Testing dynamic allocation functions..." << endl;
  MemoryBuffer z(c);
  cout << "String = " << (char *)z << endl;
  cout << "Buffer's logical length = " << z.length() << endl;
  cout << "Buffer's allocated length = " << z.dlength() << endl;
  cout << "Changing allocated length..." << endl;
  z.Realloc(z.length()+16);
  cout << "Buffer's allocated length = " << z.dlength() << endl;
  cout << "Destorying the buffer" << endl;
  z.Destroy();
  cout << "Buffer's logical length = " << z.length() << endl;
  cout << "Buffer's allocated length = " << z.dlength() << endl;
  
  PausePrg();

  cout << "Testing resizing function" << endl;
  MemoryBuffer rs(a);
  cout << "String = " << (char *)rs << endl;
  cout << "Buffer's logical length = " << rs.length() << endl;
  cout << "Buffer's allocated length = " << rs.dlength() << endl;
  cout << "Resizing the buffer to 24 bytes" << endl;
  rs.resize(24);
  cout << "Buffer's logical length = " << rs.length() << endl;
  cout << "Buffer's allocated length = " << rs.dlength() << endl;
  cout << "Freeing unused allocated space..." << endl;
  rs.FreeBytes();
  cout << "Buffer's logical length = " << rs.length() << endl;
  cout << "Buffer's allocated length = " << rs.dlength() << endl;

  PausePrg();
  
  cout << "Testing overload subscript operator..." << endl;
  char *Message = "This is a test message";
  MemoryBuffer ss((char *)Message, strlen(Message));
  for(unsigned i = 0; i < strlen(Message); i++)
    cout << ss[i];
  cout << endl;

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
