/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Brain;
import com.rexbot.game.card.Card;
import com.rexbot.game.card.Hand;
import com.rexbot.game.card.HandCalculator;
import com.rexbot.game.card.History;
import com.rexbot.game.card.HumanInput;
import com.rexbot.game.card.HumanInputContinue;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.card.Player;
import com.rexbot.game.card.PlayerManager;
import com.rexbot.game.card.Pot;
import com.rexbot.game.card.Shoe;
import com.rexbot.game.card.commands.RunSimCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class Table
extends JPanel {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Table == null ? (class$com$rexbot$game$card$Table = Table.class$("com.rexbot.game.card.Table")) : class$com$rexbot$game$card$Table);
    private int numberOfHands = 0;
    private Shoe shoe = null;
    private Pot pot = new Pot();
    private HumanInput humanInput = new HumanInput();
    private HumanInputContinue humanInputContinue = new HumanInputContinue();
    private List hands = new ArrayList();
    private Hand widow = new Hand(Hand.PLAYER_HAND, this, null);
    public static Image background = null;
    public static Table instance = null;
    static int x = 1;
    static int y = 1;
    static Dimension backgroundSize = new Dimension(0, 0);
    private int cardsDelt = 0;
    static /* synthetic */ Class class$com$rexbot$game$card$Table;

    public Table(int numberOfHands, Shoe shoe) {
        instance = this;
        this.initComponents();
        this.shoe = shoe;
        this.numberOfHands = numberOfHands;
        this.createHands();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        this.add((Component)this.makeCenterPanel(), gbc);
        this.revalidate();
        this.repaint();
    }

    private JPanel makeCenterPanel() {
        JPanel jp = new JPanel(new GridBagLayout());
        jp.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        jp.add((Component)this.pot, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        jp.add((Component)this.humanInput, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        jp.add((Component)this.humanInputContinue, gbc);
        return jp;
    }

    public void add(Component comp, Object constraints) {
        if (!RunSimCommand.run) {
            super.add(comp, constraints);
        }
    }

    public Component add(Component comp) {
        if (!RunSimCommand.run) {
            return super.add(comp);
        }
        return null;
    }

    public Pot getPot() {
        return this.pot;
    }

    public HumanInput getHumanInput() {
        return this.humanInput;
    }

    public HumanInputContinue getHumanInputContinue() {
        return this.humanInputContinue;
    }

    public void createHands() {
        for (int i = 1; i <= this.numberOfHands; ++i) {
            Hand hand = new Hand(Hand.PLAYER_HAND, this, PlayerManager.getInstance().getPlayer(i));
            this.add((Component)PlayerManager.getInstance().getPlayer(i), Table.getConstraints(i));
            this.hands.add(hand);
        }
        this.add((Component)this.widow, Table.getConstraints(-1));
    }

    public Collection getWinningHands() {
        Hand hand;
        HashSet<Hand> winners = new HashSet<Hand>();
        Hand winner = new Hand(Hand.PLAYER_HAND, this, null);
        Iterator it = this.hands.iterator();
        while (it.hasNext()) {
            hand = (Hand)it.next();
            if (!hand.getPlayer().isFolded()) {
                hand.setFaceUp(true);
                hand.setMessage(HandCalculator.getPokerValueAsString(hand.getCards()), Palette.backgroundColor, Color.black);
            }
            if (hand.getPlayer().isFolded() || !(hand.getPokerValue() >= winner.getPokerValue())) continue;
            winner = hand;
        }
        it = this.hands.iterator();
        while (it.hasNext()) {
            hand = (Hand)it.next();
            if (hand.getPlayer().isFolded() || !(hand.getPokerValue() >= winner.getPokerValue()) || hand == this.widow) continue;
            winners.add(hand);
        }
        return winners;
    }

    public void highLightWinners() {
        int showdown = PlayerManager.getInstance().getActivePlayerCount();
        Collection winners = this.getWinningHands();
        if (Opts.getInstance().isAlwaysShowWinner() || showdown > 1) {
            Iterator it = winners.iterator();
            while (it.hasNext()) {
                Hand hand = (Hand)it.next();
                hand.setFaceUp(true);
                hand.setMessage("WIN with " + HandCalculator.getPokerValueAsString(hand.getCards()), Palette.urgentBackgroundColor, Color.black);
            }
        } else {
            Iterator it = winners.iterator();
            while (it.hasNext()) {
                Hand hand = (Hand)it.next();
                hand.setMessage("WIN by default", Palette.urgentBackgroundColor, Color.black);
            }
        }
        this.repaint();
    }

    public void rewardCorrectPlay(long amount) {
        Hand hand;
        int correctPlayersA = 0;
        int correctPlayersB = 0;
        Hand winner = new Hand(Hand.PLAYER_HAND, this, null);
        Iterator it = this.hands.iterator();
        while (it.hasNext()) {
            hand = (Hand)it.next();
            if (!(hand.getPokerValue() >= winner.getPokerValue())) continue;
            winner = hand;
        }
        it = this.hands.iterator();
        while (it.hasNext()) {
            hand = (Hand)it.next();
            if (hand.getPokerValue() >= winner.getPokerValue()) {
                if (hand == this.widow || hand.getPlayer().isFolded()) continue;
                ++correctPlayersA;
                continue;
            }
            if (!hand.getPlayer().isFolded()) continue;
            ++correctPlayersB;
        }
        it = this.hands.iterator();
        while (it.hasNext()) {
            hand = (Hand)it.next();
            if (hand.getPokerValue() >= winner.getPokerValue()) {
                if (hand == this.widow || hand.getPlayer().isFolded()) continue;
                hand.getPlayer().win(amount / (long)correctPlayersA);
                continue;
            }
            if (!hand.getPlayer().isFolded()) continue;
            hand.getPlayer().win(amount / (long)correctPlayersB);
        }
    }

    public void clearAccounts() {
        Iterator it = this.hands.iterator();
        while (it.hasNext()) {
            Hand hand = (Hand)it.next();
            hand.getPlayer().setBankroll(0L);
            hand.repaint();
        }
    }

    public void highLightButton(int button) {
        for (int i = 1; i <= 10; ++i) {
            Player player = PlayerManager.getInstance().getPlayer(i);
            if (button == i) {
                player.setOnButton();
                continue;
            }
            player.setOffButton();
        }
    }

    public void highLightCurrentPlayer(int currentPlayer) {
        for (int i = 1; i <= 10; ++i) {
            Player player = PlayerManager.getInstance().getPlayer(i);
            if (currentPlayer == i) {
                player.setCurrentPlayer(true);
                continue;
            }
            player.setCurrentPlayer(false);
        }
    }

    public void highLightFolders() {
        Iterator it = this.hands.iterator();
        while (it.hasNext()) {
            Hand hand = (Hand)it.next();
            if (!hand.getPlayer().isFolded()) continue;
            hand.setMessage("Out", Palette.backgroundColor, Color.black);
        }
        this.repaint();
    }

    public void payWinners() {
        long slice = this.pot.getAmount() / (long)this.getWinningHands().size();
        Iterator it = this.getWinningHands().iterator();
        while (it.hasNext()) {
            Hand hand = (Hand)it.next();
            hand.getPlayer().win(slice);
            History.getInstance().add(hand.getPlayer().getName() + " won " + slice);
        }
        this.repaint();
    }

    public void mate(int ignorePlayer) {
        Hand hand;
        Hand hand2;
        Hand highHand = null;
        Hand highHand2 = null;
        long highWinner = Long.MIN_VALUE;
        Collections.shuffle(this.hands);
        Iterator it = this.hands.iterator();
        while (it.hasNext()) {
            hand2 = (Hand)it.next();
            if (hand2.getPlayer().getBankroll() < highWinner || hand2.getPlayer().getNumber() == ignorePlayer) continue;
            highHand = hand2;
            highWinner = hand2.getPlayer().getBankroll();
        }
        highWinner = Long.MIN_VALUE;
        it = this.hands.iterator();
        while (it.hasNext()) {
            hand2 = (Hand)it.next();
            if (hand2.getPlayer().getBankroll() < highWinner || hand2 == highHand || hand2.getPlayer().getNumber() == ignorePlayer) continue;
            highHand2 = hand2;
            highWinner = hand2.getPlayer().getBankroll();
        }
        Hand loser = null;
        Hand loser2 = null;
        long lowWinner = Long.MAX_VALUE;
        Iterator it2 = this.hands.iterator();
        while (it2.hasNext()) {
            hand = (Hand)it2.next();
            if (hand.getPlayer().getBankroll() > lowWinner || hand.getPlayer().getNumber() == ignorePlayer) continue;
            loser = hand;
            lowWinner = hand.getPlayer().getBankroll();
        }
        lowWinner = Long.MAX_VALUE;
        it2 = this.hands.iterator();
        while (it2.hasNext()) {
            hand = (Hand)it2.next();
            if (hand.getPlayer().getBankroll() > lowWinner || hand == loser || hand.getPlayer().getNumber() == ignorePlayer) continue;
            loser2 = hand;
            lowWinner = hand.getPlayer().getBankroll();
        }
        cat.debug(highHand.getPlayer().getBankroll() + "/" + highHand2.getPlayer().getBankroll() + " : " + loser.getPlayer().getBankroll() + "/" + loser2.getPlayer().getBankroll());
        Brain.mate(highHand.getPlayer().getBrain(), highHand2.getPlayer().getBrain(), loser.getPlayer().getBrain(), loser2.getPlayer().getBrain());
        if (RunSimCommand.run) {
            loser.getPlayer().setStake(0L);
            loser2.getPlayer().setStake(0L);
        }
    }

    private static GridBagConstraints getConstraints(int player) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        switch (player) {
            case -1: {
                gbc.gridx = 3;
                gbc.gridy = 1;
                gbc.gridwidth = 2;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.fill = 0;
                break;
            }
            case 10: {
                gbc.gridx = 1;
                gbc.gridy = 1;
                break;
            }
            case 9: {
                gbc.gridx = 1;
                gbc.gridy = 2;
                break;
            }
            case 8: {
                gbc.gridx = 1;
                gbc.gridy = 3;
                break;
            }
            case 7: {
                gbc.gridx = 2;
                gbc.gridy = 3;
                break;
            }
            case 6: {
                gbc.gridx = 3;
                gbc.gridy = 3;
                break;
            }
            case 5: {
                gbc.gridx = 4;
                gbc.gridy = 3;
                break;
            }
            case 4: {
                gbc.gridx = 5;
                gbc.gridy = 3;
                break;
            }
            case 3: {
                gbc.gridx = 6;
                gbc.gridy = 3;
                break;
            }
            case 2: {
                gbc.gridx = 6;
                gbc.gridy = 2;
                break;
            }
            case 1: {
                gbc.gridx = 6;
                gbc.gridy = 1;
                break;
            }
            default: {
                throw new RuntimeException("don't know how to handle hand: " + player);
            }
        }
        return gbc;
    }

    public void dealCards(int numCards) {
        for (int i = 0; i < numCards; ++i) {
            this.dealCard();
        }
    }

    public void dealCard() {
        if (this.cardsDelt < 2) {
            Iterator it = this.hands.iterator();
            while (it.hasNext()) {
                Hand hand = (Hand)it.next();
                if (hand == this.widow) continue;
                hand.addCard(this.shoe.getNextCard(), true);
            }
        } else {
            Card card = this.shoe.getNextCard();
            this.widow.addCard(card, true);
            this.widow.setMessage(HandCalculator.getPokerValueAsString(this.widow.getCards()), Palette.urgentBackgroundColor, Color.black);
            Iterator it = this.hands.iterator();
            while (it.hasNext()) {
                Hand hand = (Hand)it.next();
                hand.addCard(card, false);
            }
        }
        ++this.cardsDelt;
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(0, 204, 0));
        this.setOpaque(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

