/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.util.Stack;
import org.apache.tomcat.context.ResourceCollection;
import org.apache.tomcat.context.SCAction;
import org.apache.tomcat.context.SecurityConstraint;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;

public class WebXmlReader
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");

    void addSecurity(XmlMapper xh) {
        xh.addRule("web-app/security-constraint", new SCAction());
        xh.addRule("web-app/security-constraint/user-data-constraint/transport-guarantee", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                SecurityConstraint rc = (SecurityConstraint)st.peek();
                String body = ctx.getBody().trim();
                rc.setTransport(body);
            }
        });
        xh.addRule("web-app/security-constraint/auth-constraint/role-name", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                SecurityConstraint rc = (SecurityConstraint)st.peek();
                String body = ctx.getBody().trim();
                rc.addRole(body);
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection", new XmlAction(){

            public void cleanup(SaxContext ctx) {
                Stack st = ctx.getObjectStack();
                Object o = st.pop();
            }

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.pop();
                SecurityConstraint sc = (SecurityConstraint)st.peek();
                st.push(rc);
                sc.addResourceCollection(rc);
            }

            public void start(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                st.push(new ResourceCollection());
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection/url-pattern", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.peek();
                String body = ctx.getBody().trim();
                rc.addUrlPattern(body);
            }
        });
        xh.addRule("web-app/security-constraint/web-resource-collection/http-method", new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Stack st = ctx.getObjectStack();
                ResourceCollection rc = (ResourceCollection)st.peek();
                String body = ctx.getBody().trim();
                rc.addHttpMethod(body);
            }
        });
    }

    public void contextInit(Context ctx) throws TomcatException {
        if (ctx.getDebug() > 0) {
            ctx.log("XmlReader - init  " + ctx.getPath() + " " + ctx.getDocBase());
        }
        try {
            String tchome;
            String home = ctx.getContextManager().getHome();
            File default_xml = new File(String.valueOf(home) + "/conf/web.xml");
            if (!default_xml.exists() && (tchome = ctx.getContextManager().getTomcatHome()) != null) {
                default_xml = new File(String.valueOf(tchome) + "/conf/web.xml");
            }
            if (!default_xml.exists()) {
                throw new TomcatException("Can't find default web.xml configuration");
            }
            this.processFile(ctx, default_xml.toString());
            ctx.expectUserWelcomeFiles();
            File inf_xml = new File(String.valueOf(ctx.getDocBase()) + "/WEB-INF/web.xml");
            if (!inf_xml.isAbsolute()) {
                inf_xml = new File(home, inf_xml.toString());
            }
            this.processFile(ctx, inf_xml.toString());
            XmlMapper xh = new XmlMapper();
        }
        catch (Exception exception) {
            String msg = sm.getString("context.getConfig.e", String.valueOf(ctx.getPath()) + " " + ctx.getDocBase());
            System.out.println(msg);
        }
    }

    void processFile(Context ctx, String file) {
        try {
            File f = new File(FileUtil.patch(file));
            if (!f.exists()) {
                ctx.log("File not found " + f + ", using only defaults");
                return;
            }
            if (ctx.getDebug() > 0) {
                ctx.log("Reading " + file);
            }
            XmlMapper xh = new XmlMapper();
            xh.addRule("web-app/context-param", xh.methodSetter("addInitParameter", 2));
            xh.addRule("web-app/context-param/param-name", xh.methodParam(0));
            xh.addRule("web-app/context-param/param-value", xh.methodParam(1));
            xh.addRule("web-app/description", xh.methodSetter("setDescription", 0));
            xh.addRule("web-app/icon/small-icon", xh.methodSetter("setIcon", 0));
            xh.addRule("web-app/distributable", xh.methodSetter("setDistributable", 0));
            xh.addRule("web-app/servlet-mapping", xh.methodSetter("addServletMapping", 2));
            xh.addRule("web-app/servlet-mapping/servlet-name", xh.methodParam(1));
            xh.addRule("web-app/servlet-mapping/url-pattern", xh.methodParam(0));
            xh.addRule("web-app/taglib", xh.methodSetter("addTaglib", 2));
            xh.addRule("web-app/taglib/taglib-uri", xh.methodParam(0));
            xh.addRule("web-app/taglib/taglib-location", xh.methodParam(1));
            xh.addRule("web-app/env-entry", xh.methodSetter("addTaglib", 4));
            xh.addRule("web-app/env-entry/env-entry-name", xh.methodParam(0));
            xh.addRule("web-app/env-entry/env-entry-type", xh.methodParam(1));
            xh.addRule("web-app/env-entry/env-entry-value", xh.methodParam(2));
            xh.addRule("web-app/env-entry/description", xh.methodParam(3));
            xh.addRule("web-app/login-config", xh.methodSetter("setLoginConfig", 4));
            xh.addRule("web-app/login-config/auth-method", xh.methodParam(0));
            xh.addRule("web-app/login-config/realm-name", xh.methodParam(1));
            xh.addRule("web-app/login-config/form-login-config/form-login-page", xh.methodParam(2));
            xh.addRule("web-app/login-config/form-login-config/form-error-page", xh.methodParam(3));
            xh.addRule("web-app/mime-mapping", xh.methodSetter("addContentType", 2));
            xh.addRule("web-app/mime-mapping/extension", xh.methodParam(0));
            xh.addRule("web-app/mime-mapping/mime-type", xh.methodParam(1));
            xh.addRule("web-app/welcome-file-list/welcome-file", xh.methodSetter("addWelcomeFile", 0));
            xh.addRule("web-app/error-page", xh.methodSetter("addErrorPage", 2));
            xh.addRule("web-app/error-page/error-code", xh.methodParam(0));
            xh.addRule("web-app/error-page/exception-type", xh.methodParam(0));
            xh.addRule("web-app/error-page/location", xh.methodParam(1));
            xh.addRule("web-app/session-config", xh.methodSetter("setSessionTimeOut", 1, new String[]{"int"}));
            xh.addRule("web-app/session-config/session-timeout", xh.methodParam(0));
            xh.addRule("web-app/servlet", xh.objectCreate("org.apache.tomcat.core.ServletWrapper"));
            xh.addRule("web-app/servlet", xh.setParent("setContext"));
            xh.addRule("web-app/servlet", xh.addChild("addServlet", null));
            xh.addRule("web-app/servlet/servlet-name", xh.methodSetter("setServletName", 0));
            xh.addRule("web-app/servlet/servlet-class", xh.methodSetter("setServletClass", 0));
            xh.addRule("web-app/servlet/jsp-file", xh.methodSetter("setPath", 0));
            xh.addRule("web-app/servlet/security-role-ref", xh.methodSetter("addSecurityMapping", 3));
            xh.addRule("web-app/servlet/security-role-ref/role-name", xh.methodParam(0));
            xh.addRule("web-app/servlet/security-role-ref/role-link", xh.methodParam(1));
            xh.addRule("web-app/servlet/security-role-ref/description", xh.methodParam(2));
            xh.addRule("web-app/servlet/init-param", xh.methodSetter("addInitParam", 2));
            xh.addRule("web-app/servlet/init-param/param-name", xh.methodParam(0));
            xh.addRule("web-app/servlet/init-param/param-value", xh.methodParam(1));
            xh.addRule("web-app/servlet/icon/small-icon", xh.methodSetter("setIcon", 0));
            xh.addRule("web-app/servlet/description", xh.methodSetter("setDescription", 0));
            xh.addRule("web-app/servlet/load-on-startup", xh.methodSetter("setLoadOnStartUp", 0));
            this.addSecurity(xh);
            Object ctx1 = xh.readXml(f, ctx);
        }
        catch (Exception ex) {
            System.out.println("ERROR reading " + file);
            ex.printStackTrace();
        }
    }
}

