/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;

public abstract class ResultSet {
    protected Vector Rows;
    protected Field[] Fields;
    protected int currentRow = -1;
    protected byte[][] This_Row;
    protected Connection Conn;
    protected SQLWarning Warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean reallyResult = false;
    protected Hashtable columnNameToIndex = null;
    protected Hashtable fullColumnNameToIndex = null;
    protected long updateID = -1L;
    protected long updateCount;
    private SimpleDateFormat _TSDF = null;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public boolean next() throws SQLException {
        if (!this.reallyResult()) {
            throw new SQLException("ResultSet is from UPDATE. No Data", "S1000");
        }
        if (this.currentRow + 1 >= this.Rows.size()) {
            return false;
        }
        this.clearWarnings();
        ++this.currentRow;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public boolean prev() throws SQLException {
        if (this.currentRow - 1 >= 0) {
            --this.currentRow;
            this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.Rows != null) {
            this.Rows.removeAllElements();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        if (this.Conn != null && this.Conn.useUnicode()) {
            try {
                String Encoding = this.Conn.getEncoding();
                if (Encoding == null) {
                    return new String(this.This_Row[columnIndex - 1]);
                }
                return new String(this.This_Row[columnIndex - 1], this.Conn.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'.", "0S100");
            }
        }
        return new String(this.This_Row[columnIndex - 1]);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null && S.length() > 0) {
            char c = S.toLowerCase().charAt(0);
            return c == 't' || c == 'y' || c == '1';
        }
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0;
        }
        Field F = this.Fields[columnIndex - 1];
        switch (F.getMysqlType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                try {
                    String S = this.getString(columnIndex);
                    if (S.indexOf(".") != -1) {
                        S = S.substring(0, S.indexOf("."));
                    }
                    return Byte.parseByte(S);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Value '" + this.getString(columnIndex) + "' is out of range [-127,127]", "S1009");
                }
            }
        }
        return this.This_Row[columnIndex - 1][0];
    }

    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getLong(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return (int)this.getLong(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0L;
        }
        try {
            return this.getLong(this.This_Row[columnIndex - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this.This_Row[columnIndex - 1]) + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        return (float)this.getDouble(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0.0;
        }
        try {
            return ResultSet.getDouble(this.This_Row[columnIndex - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this.This_Row[columnIndex - 1]) + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
        }
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            BigDecimal Val2;
            if (S.length() == 0) {
                BigDecimal Val2 = new BigDecimal(0.0);
                return Val2.setScale(scale);
            }
            try {
                Val2 = new BigDecimal(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
            }
            try {
                return Val2.setScale(scale);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        return this.This_Row[columnIndex - 1];
    }

    public Date getDate(int columnIndex) throws SQLException {
        Integer Y = null;
        Integer M = null;
        Integer D = null;
        String S = "";
        try {
            S = this.getString(columnIndex);
            if (S == null) {
                return null;
            }
            if (this.Fields[columnIndex - 1].getMysqlType() == 7) {
                switch (S.length()) {
                    case 8: 
                    case 14: {
                        Y = new Integer(S.substring(0, 4));
                        M = new Integer(S.substring(4, 6));
                        D = new Integer(S.substring(6, 8));
                        return new Date(Y - 1900, M - 1, D);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        Y = new Integer(S.substring(0, 2));
                        M = new Integer(S.substring(2, 4));
                        D = new Integer(S.substring(4, 6));
                        return new Date(Y, M - 1, D);
                    }
                    case 4: {
                        Y = new Integer(S.substring(0, 2));
                        M = new Integer(S.substring(2, 4));
                        return new Date(Y, M - 1, 1);
                    }
                    case 2: {
                        Y = new Integer(S.substring(0, 2));
                        return new Date(Y, 0, 1);
                    }
                }
                throw new SQLException("Bad format for Date '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
            }
            if (S.length() < 10) {
                throw new SQLException("Bad format for Date '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
            }
            Y = new Integer(S.substring(0, 4));
            M = new Integer(S.substring(5, 7));
            D = new Integer(S.substring(8, 10));
            return new Date(Y - 1900, M - 1, D);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot convert value '" + S + "' from column " + columnIndex + "(" + S + " ) to DATE.", "S1009");
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        int hr = 0;
        int min = 0;
        int sec = 0;
        try {
            String S = this.getString(columnIndex);
            if (S == null) {
                return null;
            }
            Field F = this.Fields[columnIndex - 1];
            if (F.getMysqlType() == 7) {
                int length = S.length();
                switch (length) {
                    case 12: 
                    case 14: {
                        hr = Integer.parseInt(S.substring(length - 6, length - 4));
                        min = Integer.parseInt(S.substring(length - 4, length - 2));
                        sec = Integer.parseInt(S.substring(length - 2, length));
                        break;
                    }
                    case 10: {
                        hr = Integer.parseInt(S.substring(6, 8));
                        min = Integer.parseInt(S.substring(8, 10));
                        sec = 0;
                        break;
                    }
                    default: {
                        throw new SQLException("Timestamp too small to convert to Time value in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
                    }
                }
                SQLWarning W = new SQLWarning("Precision lost converting TIMESTAMP to Time with getTime() on column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").");
                if (this.Warnings == null) {
                    this.Warnings = W;
                } else {
                    this.Warnings.setNextWarning(W);
                }
            } else if (F.getMysqlType() == 12) {
                hr = Integer.parseInt(S.substring(11, 13));
                min = Integer.parseInt(S.substring(14, 16));
                sec = Integer.parseInt(S.substring(17, 19));
                SQLWarning W = new SQLWarning("Precision lost converting DATETIME to Time with getTime() on column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").");
                if (this.Warnings == null) {
                    this.Warnings = W;
                } else {
                    this.Warnings.setNextWarning(W);
                }
            } else {
                if (S.length() != 5 && S.length() != 8) {
                    throw new SQLException("Bad format for Time '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
                }
                hr = Integer.parseInt(S.substring(0, 2));
                min = Integer.parseInt(S.substring(3, 5));
                sec = S.length() != 5 ? Integer.parseInt(S.substring(6)) : 0;
            }
            return new Time(hr, min, sec);
        }
        catch (Exception E) {
            throw new SQLException(E.getClass().getName(), "S1009");
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S == null) {
            return null;
        }
        try {
            switch (S.length()) {
                case 19: {
                    ResultSet resultSet = this;
                    synchronized (resultSet) {
                        if (this._TSDF == null) {
                            this._TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                        try {
                            java.util.Date D = this._TSDF.parse(S);
                            return new Timestamp(D.getTime());
                        }
                        catch (ParseException parseException) {
                            throw new SQLException("Bad format for Timestamp '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
                        }
                    }
                }
                case 14: {
                    int year = Integer.parseInt(S.substring(0, 4));
                    int month = Integer.parseInt(S.substring(4, 6));
                    int day = Integer.parseInt(S.substring(6, 8));
                    int hour = Integer.parseInt(S.substring(8, 10));
                    int minutes = Integer.parseInt(S.substring(10, 12));
                    int seconds = Integer.parseInt(S.substring(12, 14));
                    return new Timestamp(year - 1900, month - 1, day, hour, minutes, seconds, 0);
                }
                case 12: {
                    int year = Integer.parseInt(S.substring(0, 2));
                    int month = Integer.parseInt(S.substring(2, 4));
                    int day = Integer.parseInt(S.substring(4, 6));
                    int hour = Integer.parseInt(S.substring(6, 8));
                    int minutes = Integer.parseInt(S.substring(8, 10));
                    int seconds = Integer.parseInt(S.substring(10, 12));
                    return new Timestamp(year, month - 1, day, hour, minutes, seconds, 0);
                }
                case 10: {
                    int year = Integer.parseInt(S.substring(0, 2));
                    int month = Integer.parseInt(S.substring(2, 4));
                    int day = Integer.parseInt(S.substring(4, 6));
                    int hour = Integer.parseInt(S.substring(6, 8));
                    int minutes = Integer.parseInt(S.substring(8, 10));
                    return new Timestamp(year, month - 1, day, hour, minutes, 0, 0);
                }
                case 8: {
                    int year = Integer.parseInt(S.substring(0, 4));
                    int month = Integer.parseInt(S.substring(4, 6));
                    int day = Integer.parseInt(S.substring(6, 8));
                    return new Timestamp(year - 1900, month - 1, day, 0, 0, 0, 0);
                }
                case 6: {
                    int year = Integer.parseInt(S.substring(0, 2));
                    int month = Integer.parseInt(S.substring(2, 4));
                    int day = Integer.parseInt(S.substring(4, 6));
                    return new Timestamp(year, month - 1, day, 0, 0, 0, 0);
                }
                case 4: {
                    int year = Integer.parseInt(S.substring(0, 2));
                    int month = Integer.parseInt(S.substring(2, 4));
                    return new Timestamp(year, month - 1, 1, 0, 0, 0, 0);
                }
                case 2: {
                    int year = Integer.parseInt(S.substring(0, 2));
                    return new Timestamp(year, 0, 1, 0, 0, 0, 0);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
        }
        catch (Exception e) {
            throw new SQLException(e.getClass().getName(), "S1009");
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public String getString(String ColumnName) throws SQLException {
        return this.getString(this.findColumn(ColumnName));
    }

    public boolean getBoolean(String ColumnName) throws SQLException {
        return this.getBoolean(this.findColumn(ColumnName));
    }

    public byte getByte(String ColumnName) throws SQLException {
        return this.getByte(this.findColumn(ColumnName));
    }

    public short getShort(String ColumnName) throws SQLException {
        return this.getShort(this.findColumn(ColumnName));
    }

    public int getInt(String ColumnName) throws SQLException {
        return this.getInt(this.findColumn(ColumnName));
    }

    public long getLong(String ColumnName) throws SQLException {
        return this.getLong(this.findColumn(ColumnName));
    }

    public float getFloat(String ColumnName) throws SQLException {
        return this.getFloat(this.findColumn(ColumnName));
    }

    public double getDouble(String ColumnName) throws SQLException {
        return this.getDouble(this.findColumn(ColumnName));
    }

    public BigDecimal getBigDecimal(String ColumnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(ColumnName), scale);
    }

    public byte[] getBytes(String ColumnName) throws SQLException {
        return this.getBytes(this.findColumn(ColumnName));
    }

    public Date getDate(String ColumnName) throws SQLException {
        return this.getDate(this.findColumn(ColumnName));
    }

    public Time getTime(String ColumnName) throws SQLException {
        return this.getTime(this.findColumn(ColumnName));
    }

    public Timestamp getTimestamp(String ColumnName) throws SQLException {
        return this.getTimestamp(this.findColumn(ColumnName));
    }

    public InputStream getAsciiStream(String ColumnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(ColumnName));
    }

    public InputStream getUnicodeStream(String ColumnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(ColumnName));
    }

    public InputStream getBinaryStream(String ColumnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(ColumnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.Warnings;
    }

    public void clearWarnings() throws SQLException {
        this.Warnings = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column index out of range (" + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        Field F = this.Fields[columnIndex - 1];
        if (this.This_Row[columnIndex - 1] == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        switch (F.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(columnIndex));
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: 
            case 3: {
                String S = this.getString(columnIndex);
                if (S != null) {
                    BigDecimal Val2;
                    if (S.length() == 0) {
                        BigDecimal Val2 = new BigDecimal(0.0);
                        return Val2;
                    }
                    try {
                        Val2 = new BigDecimal(S);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex - 1] + ").", "S1009");
                    }
                    return Val2;
                }
                return null;
            }
            case 6: 
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                if (F.isBinary()) {
                    return this.getBytes(columnIndex);
                }
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] Data;
                if (!F.isBlob()) {
                    return this.getString(columnIndex);
                }
                if (!F.isBinary()) {
                    return this.getString(columnIndex);
                }
                Object Obj = Data = this.getBytes(columnIndex);
                if (Data != null && Data.length >= 2 && Data[0] == -84 && Data[1] == -19) {
                    try {
                        ByteArrayInputStream BIn = new ByteArrayInputStream(Data);
                        ObjectInputStream ObjIn = new ObjectInputStream(BIn);
                        Obj = ObjIn.readObject();
                        ObjIn.close();
                        BIn.close();
                    }
                    catch (ClassNotFoundException CnFe) {
                        throw new SQLException("Class not found: " + CnFe.toString() + " while reading serialized object");
                    }
                    catch (IOException iOException) {
                        Obj = Data;
                    }
                }
                return Obj;
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    public Object getObject(String ColumnName) throws SQLException {
        return this.getObject(this.findColumn(ColumnName));
    }

    public int findColumn(String ColumnName) throws SQLException {
        Integer index = (Integer)this.columnNameToIndex.get(ColumnName);
        if (index == null) {
            index = (Integer)this.fullColumnNameToIndex.get(ColumnName);
        }
        if (index != null) {
            return index + 1;
        }
        throw new SQLException("Column '" + ColumnName + "' not found.", "S0022");
    }

    public ResultSet(Field[] Fields, Vector Tuples, Connection Conn) {
        this(Fields, Tuples);
        this.setConnection(Conn);
    }

    public ResultSet(Field[] Fields, Vector Tuples) {
        this.currentRow = -1;
        this.Fields = Fields;
        this.Rows = Tuples;
        this.updateCount = this.Rows.size();
        this.reallyResult = true;
        if (this.Rows.size() > 0) {
            this.This_Row = (byte[][])this.Rows.elementAt(0);
            if (this.updateCount == 1L && this.This_Row == null) {
                this.currentRow = -1;
                this.Rows.removeAllElements();
                this.updateCount = -1L;
            }
        } else {
            this.This_Row = null;
        }
        this.buildIndexMapping();
    }

    protected void buildIndexMapping() {
        int numFields = this.Fields.length;
        this.columnNameToIndex = new Hashtable();
        this.fullColumnNameToIndex = new Hashtable();
        int i = 0;
        while (i < numFields) {
            Integer index = new Integer(i);
            String columnName = this.Fields[i].getName();
            String fullColumnName = this.Fields[i].getFullName();
            if (columnName != null) {
                this.columnNameToIndex.put(this.Fields[i].getName(), index);
            }
            if (fullColumnName != null) {
                this.fullColumnNameToIndex.put(this.Fields[i].getFullName(), index);
            }
            ++i;
        }
    }

    public ResultSet(long updateCount, long updateID) {
        this.updateCount = updateCount;
        this.updateID = updateID;
        this.reallyResult = false;
        this.Fields = new Field[0];
    }

    public void setConnection(Connection Conn) {
        this.Conn = Conn;
    }

    boolean reallyResult() {
        return this.reallyResult;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateID;
    }

    private synchronized void checkRowPos() throws SQLException {
        if (this.currentRow < 0) {
            throw new SQLException("Before start of result set");
        }
        if (this.currentRow == this.Rows.size()) {
            throw new SQLException("After end of result set");
        }
    }

    public static double getDouble(byte[] buf) {
        char ch;
        double value = 0.0;
        int exp = 0;
        int sign = 1;
        int pos = 0;
        int len = buf.length;
        while (pos < len && (char)buf[pos] == ' ') {
            ++pos;
        }
        if (pos + 3 == len && (char)buf[pos] == 'N' && (char)buf[pos + 1] == 'a' && (char)buf[pos + 2] == 'N') {
            return Double.NaN;
        }
        if (pos < len && (char)buf[pos] == '-') {
            sign = -1;
            ++pos;
        }
        while (pos < len) {
            ch = (char)buf[pos];
            if (ch < '0' || ch > '9') {
                if (pos + 3 != len || (char)buf[pos] != 'I' || (char)buf[pos + 1] != 'n' || (char)buf[pos + 2] != 'f') break;
                if (sign > 0) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.NEGATIVE_INFINITY;
            }
            value = 10.0 * value + (double)ch - 48.0;
            ++pos;
        }
        if (pos == len) {
            return (double)sign * value;
        }
        if ((char)buf[pos] == '.') {
            ++pos;
            while (pos < len) {
                ch = (char)buf[pos];
                if (ch < '0' || ch > '9') break;
                value = 10.0 * value + (double)ch - 48.0;
                --exp;
                ++pos;
            }
        }
        if (pos < len && ((char)buf[pos] == 'e' || (char)buf[pos] == 'E')) {
            int eSign = 1;
            if (++pos < len && (char)buf[pos] == '-') {
                ++pos;
                eSign = -1;
            }
            if (pos < len && (char)buf[pos] == '+') {
                ++pos;
            }
            int expt = 0;
            while (pos < len) {
                char ch2 = (char)buf[pos];
                if (ch2 < '0' || ch2 > '9') break;
                expt = 10 * expt + ch2 - 48;
                ++pos;
            }
            exp += eSign * expt;
        }
        if (pos < len) {
            return 0.0;
        }
        if (exp >= 0) {
            return (double)sign * value * Math.pow(10.0, exp);
        }
        return (double)sign * value / Math.pow(10.0, -exp);
    }

    public long getLong(byte[] buf) throws NumberFormatException {
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = buf.length;
        int radix = 10;
        if (max > 0) {
            int digit;
            long limit;
            if ((char)buf[0] == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < max) {
                if ((digit = Character.digit((char)buf[i++], radix)) < 0) {
                    throw new NumberFormatException(new String(buf));
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit((char)buf[i++], radix)) < 0) {
                    throw new NumberFormatException(new String(buf));
                }
                if (result < multmin) {
                    throw new NumberFormatException(new String(buf));
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException(new String(buf));
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(new String(buf));
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(new String(buf));
        }
        return -result;
    }
}

