/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    File tarFile;
    File baseDir;

    public void execute() throws BuildException {
        this.project.log("Building tar: " + this.tarFile.getAbsolutePath());
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!");
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.baseDir);
        String[] files = ds.getIncludedFiles();
        try {
            TarOutputStream tOut = new TarOutputStream(new FileOutputStream(this.tarFile));
            tOut.setDebug(true);
            int i = 0;
            while (i < files.length) {
                File f = new File(this.baseDir, files[i]);
                String name = files[i].replace(File.separatorChar, '/');
                this.tarFile(f, tOut, name);
                ++i;
            }
            tOut.close();
        }
        catch (IOException ioe) {
            String msg = "Problem creating TAR: " + ioe.getMessage();
            throw new BuildException(msg);
        }
    }

    public void setBasedir(String baseDirname) {
        this.baseDir = this.project.resolveFile(baseDirname);
    }

    public void setTarfile(String tarFilename) {
        this.tarFile = this.project.resolveFile(tarFilename);
    }

    protected void tarFile(File file, TarOutputStream tOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        TarEntry te = new TarEntry(vPath);
        te.setSize(file.length());
        te.setModTime(file.lastModified() / 1000L);
        tOut.putNextEntry(te);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            tOut.write(buffer, 0, count);
        } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
        tOut.closeEntry();
        fIn.close();
    }
}

