/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLTree {
    private String name = null;
    private String value = null;
    private Hashtable attributes = new Hashtable();
    private Vector elements = new Vector();

    public void addAttribute(Object key, Object value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("addAttribute(key, value)");
        }
        this.attributes.put(key, value);
    }

    public void addElement(Object value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("addElement(value)");
        }
        this.elements.addElement(value);
    }

    public Enumeration attributes() {
        return this.attributes.keys();
    }

    public void clear() {
        this.attributes.clear();
        this.elements.removeAllElements();
    }

    public Enumeration elements() {
        return this.elements.elements();
    }

    public Enumeration elements(Object key) {
        return this.getElements(key).elements();
    }

    public Object getAttribute(Object key) {
        if (key == null) {
            throw new NullPointerException("getAttribute(key)");
        }
        return this.attributes.get(key);
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public Vector getElements() {
        return this.elements;
    }

    public Vector getElements(Object key) {
        Vector<XMLTree> v = new Vector<XMLTree>();
        Enumeration e = this.getElements().elements();
        while (e.hasMoreElements()) {
            XMLTree element = (XMLTree)e.nextElement();
            if (!element.getName().equals(key)) continue;
            v.addElement(element);
        }
        return v;
    }

    public XMLTree getFirstElement(Object key) {
        if (this.getElements(key).size() > 0) {
            return (XMLTree)this.getElements(key).elementAt(0);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void removeAttribute(Object key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("removeAttribute(key)");
        }
        this.attributes.remove(key);
    }

    public void removeElement(Object value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("removeElement(value)");
        }
        this.elements.removeElement(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim() : value;
    }

    public String toString() {
        String s = "Tree: name " + this.name + " value " + this.value;
        s = String.valueOf(s) + "\n elements: " + this.elements;
        return s;
    }
}

