/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpEndpoint;
import org.apache.tomcat.service.TcpWorkerThread;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.ThreadPool;

public class PoolTcpEndpoint
extends TcpEndpoint {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 1000;
    private boolean isPool = true;
    private int backlog = 100;
    private int timeout = 1000;
    TcpConnectionHandler handler;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    Runnable listener;
    boolean running = true;
    ThreadPool tp = new ThreadPool();

    Socket acceptSocket() {
        Socket accepted = null;
        try {
            if (this.running && this.serverSocket != null) {
                accepted = this.serverSocket.accept();
                if (!this.running && accepted != null) {
                    accepted.close();
                    accepted = null;
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (SocketException e) {
            if (this.running) {
                this.running = false;
                String msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, e);
                e.printStackTrace();
                System.err.println(msg);
            }
        }
        catch (Throwable e) {
            this.running = false;
            String msg = this.sm.getString("endpoint.err.fatal", this.serverSocket, e);
            e.printStackTrace();
            System.err.println(msg);
        }
        return accepted;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPoolOn() {
        return this.isPool;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.tp.setMaxSpareThreads(maxThreads);
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads == 1) {
            maxThreads = 2;
        }
        this.tp.setMaxThreads(maxThreads);
    }

    public void setMinSpareThreads(int minThreads) {
        this.tp.setMinSpareThreads(minThreads);
    }

    public void setPoolOn(boolean isPool) {
        this.isPool = isPool;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
            }
            if (this.isPool) {
                this.tp.start();
            }
        }
        catch (IOException ex) {
            this.running = false;
            throw ex;
        }
        catch (InstantiationException ex1) {
            this.running = false;
            throw ex1;
        }
        this.running = true;
        if (this.isPool) {
            this.listener = new TcpWorkerThread(this);
            this.tp.runIt(this.listener);
        } else {
            System.out.println("XXX Error - need pool !");
        }
    }

    public void stopEndpoint() {
        this.tp.shutdown();
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
        this.serverSocket = null;
    }
}

