/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.InputStream;
import java.net.URL;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.deployment.WebApplicationReader;
import org.apache.tomcat.util.StringManager;

public class WarWebXmlInterceptor
extends BaseInterceptor
implements ContextInterceptor {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");

    public void contextInit(Context ctx) {
        if (!ctx.getDocumentBase().getProtocol().equalsIgnoreCase("war")) {
            return;
        }
        WebApplicationReader webXmlReader = new WebApplicationReader();
        try {
            webXmlReader.processDefaultWebApp(ctx);
            String s = ctx.getDocumentBase().toString();
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            URL webURL = null;
            webURL = new URL(String.valueOf(s) + "!/WEB-INF/web.xml");
            InputStream is = webURL.openConnection().getInputStream();
            System.out.println("Context(" + ctx.getPath() + "): " + webURL.getFile());
            webXmlReader.processWebApp(ctx, is);
        }
        catch (Exception exception) {
            String string = sm.getString("context.getConfig.e", String.valueOf(ctx.getPath()) + " " + ctx.getDocBase());
        }
    }
}

