@echo off
cls
echo.
echo TEST.BAT calls INSMAC_D.EXE to manipulate macros in the Windows help file
echo TEST.HLP. The help file, and INSMAC_D.EXE, must be in the same directory
echo as TEST.BAT.
echo.
echo INSMAC_D.EXE has a short online help that is displaied when you run it without
echo parameters, or with parameters "?", "/?", or "-?".
echo.
echo When you press a key, the help screen will appear.
echo.
pause
cls
insmac_d
if errorlevel 1 goto error
pause
cls
echo.
echo When you press a key, TEST.BAT will execute the command
echo   insmac_d test.hlp -l
echo which will list the macros currently in TEST.HLP. If TEST.HLP is unmodified
echo there are none.
echo.
pause
cls
insmac_d test.hlp -l
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo TEST.BAT cannot verify that there were no macros in TEST.HLP, so it will run
echo INSMAC_D three times to delete macros that may have been inserted by an earlier
echo run of TEST.BAT or by INSMACRO.HLP.
echo.
echo The commands
echo   insmac_d test.hlp "CreateButton(`id_copy', `C&opy', `CopyTopic()')" -d
echo   insmac_d test.hlp "CreateButton(`id_exit',`E&xit',`Exit()')" -d
echo will delete TEST.BAT's two macros. The third call specifies a macro too long
echo to fit on one screen line, actually the same macros as above, but in a single
echo string, separated by a semicolon, the format used by INSMACRO.HLP.
echo.
echo Actually, INSMAC_D.EXE will take as many macro specifications as will fit on
echo one DOS command line. Later in this batch program, when we again insert and
echo delete the first two macros, we will use only one command.
echo.
echo You will find the three commands in this batch file after the line
echo "REM Delete 1".
echo.
echo The commands will be executed when you press a key.
echo.
pause
cls
REM Delete 1
REM Delete two macros possibly inserted by TEST.BAT
insmac_d test.hlp "CreateButton(`id_copy', `C&opy', `CopyTopic()')" -d
if errorlevel 1 goto error
insmac_d test.hlp "CreateButton(`id_exit',`E&xit',`Exit()')" -d
if errorlevel 1 goto error
REM Delete a semicolon-separated macro sequence possibly inserted by INSMACRO.HLP.
insmac_d test.hlp "CreateButton(`id_copy', `C&opy', `CopyTopic()');CreateButton(`id_exit',`E&xit',`Exit()')" -d
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo Now, there should not be any macros left in TEST.HLP. We will run INSMAC_D
echo again with the list option to verify that there are no macros.
echo.
pause
cls
insmac_d test.hlp -l
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo If you run TEST.BAT in a DOS box under Windows, you can return to Windows,
echo open TEST.HLP and see that it has only the standard hlep file buttons.
echo.
echo If you invoked TEST.BAT from the "INSMAC_D.EXE" hotspot in INSMACRO.HLP's
echo Demos topic, you can open TEST.HLP by clicking the "click here" hotspot. It
echo can be confusing if you click other hotspots in the Demos topic.
echo.
echo Close the help file again before you return to this window and press a key.
echo.
pause
cls
echo.
echo Now we will insert two macros into TEST.HLP. A single call to INSMAC_D.EXE
echo inserts both macros. The command line is too long to fit on a single screen
echo line, so read TEST.BAT. The command comes after the line "REM Insert". The
echo command specifies the two macros, quoted, as parameters to INSMAC_D.
echo.
echo The macros are inserted when you press a key.
echo.
pause
cls
insmac_d test.hlp "CreateButton(`id_copy', `C&opy', `CopyTopic()')" "CreateButton(`id_exit',`E&xit',`Exit()')"
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo Return to Windows and rerun TEST.HLP to verify that a Copy and an Exit button
echo appered. Again, close the help file before you return to this window - you
echo need just click the Exit button.
echo.
echo When you press a key, we will run INSMAC_D again with the list option.
echo.
pause
cls
insmac_d test.hlp -l
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo Now, let us delete the two macros again, just adding the delete option "-d"
echo to the command we used to insert the macros. You will find it in TEST.BAT
echo after the line "REM Delete 2".
echo.
echo The command is executed when you press a key.
echo.
pause
cls
REM Delete 2
insmac_d test.hlp "CreateButton(`id_copy', `C&opy', `CopyTopic()')" "CreateButton(`id_exit',`E&xit',`Exit()')" -d
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo There should not be any macros left in TEST.HLP. INSMAC_D's list option is
echo executed when you press a key.
echo.
pause
cls
insmac_d test.hlp -l
if errorlevel 1 goto error
echo.
pause
cls
echo.
echo This was all for now. Thanks for your attention.
echo.
goto exit
:error
echo.
echo Some error occured, TEST.BAT terminates.
echo.
:exit

