/*

CONV_LIB.H

   Converter Libraries for Apple II Oasis :: Disk Manager
---------------------------------------------------------
      Copyright (c) BG Universal Software, Inc. 1997-2002


mailto:APL24WIN@GeoCities.com
http://www.geocities.com/apl24win/A4W.HTM

*/

#ifndef _A2O_CONV_LIB_H
#define _A2O_CONV_LIB_H

// OS codes
#define   IOS_NONE           0
#define   IOS_MSDOS          1
#define   IOS_PRODOS         2
#define   IOS_DOS33          3
#define   IOS_USDOS          4
#define   IOS_UCSD           5
#define   IOS_CPM            6
#define   IOS_FTP            16

// attribs
#define   ATR_MSDOS_R        1
#define   ATR_MSDOS_A        2
#define   ATR_MSDOS_S        4
#define   ATR_MSDOS_H        8
#define   ATR_DOS33_W        16
#define   ATR_PRODOS_R       32
#define   ATR_PRODOS_W       64
#define   ATR_PRODOS_D       128
#define   ATR_PRODOS_N       256
#define   ATR_PRODOS_B       512

// file types
// MS-DOS
#define  IT_FOLDER          20  // directory
#define  IT_FDIMAGE         24  // disk image (DSK/DO/A4W-Disk II)
#define  IT_HDIMAGE         25  // disk image (HDV/A4W-Fixed Disk)
#define  IT_EXEFILE         26  // EXE/COM/BAT/PIF
#define  IT_FILE            27  // other
// DOS 3.3
#define  IT_DOS33           128
#define  IT_DOS33_A         IT_DOS33
#define  IT_DOS33_B         (IT_DOS33+1)
#define  IT_DOS33_T         (IT_DOS33+2)
#define  IT_DOS33_I         (IT_DOS33+3)
#define  IT_DOS33_R         (IT_DOS33+4)
#define  IT_DOS33_S         (IT_DOS33+5)
#define  IT_DOS33_A2        (IT_DOS33+6)
#define  IT_DOS33_B2        (IT_DOS33+7)
#define  IT_DOS33_X         (IT_DOS33+8)
// ProDOS base + $00..$FF
#define  IT_PRODOS          256
#define  IT_PRODOS_TXT      (IT_PRODOS+4)
#define  IT_PRODOS_BIN      (IT_PRODOS+6)
#define  IT_PRODOS_FOLDER   (IT_PRODOS+15)
#define  IT_PRODOS_ADB      (IT_PRODOS+25)
#define  IT_PRODOS_AWP      (IT_PRODOS+26)
#define  IT_PRODOS_ASP      (IT_PRODOS+27)
#define  IT_PRODOS_SHK      (IT_PRODOS+224)
#define  IT_PRODOS_INT      (IT_PRODOS+250)
#define  IT_PRODOS_BAS      (IT_PRODOS+252)
#define  IT_PRODOS_SYS      (IT_PRODOS+255)
// FTP
#define  IT_FTP_FOLDER      1024
#define  IT_FTP_FILE        (IT_FTP_FOLDER+2)

#ifndef  LP_DATA
#define  LP_DATA            LPVOID
#endif

// Converter Information
typedef struct tagCL_INFO
{
  WORD wFlags;                   // CLF_*
  char szName[30];               // converter/library name
  char szDescr[96];              // short description
} CL_INFO;

// File Information
typedef struct tagCL_FILE_INFO
{
  struct
  {
    DWORD size;             // file size in bytes
    WORD  type;             // file type IT_*
    WORD  subtype;
    WORD  created[6];       // file creation date&time - Y(1900-9999),M(1-12),D(1-31),H(0-23),M(0-59),S(0-59)
    WORD  modified[6];      // last mod. date/time
    DWORD attrib;           // file attributes ATR_*
    BYTE  os;               // OS - see the above IOS_* codes
    char  shortname[128];   // short filename (8.3 format); Windows charset
    char  prefix[326];
    char  name[256];
  } src;

  struct                    // "type", "subtype", and "name" can be changed in QueryName()
  {                         // "type" can be changed in QueryConv()
    WORD  type;
    WORD  subtype;
    BYTE  os;
    char  prefix[326];
    char  name[256];
  } dest;
} CL_FILE_INFO;

typedef   CL_INFO      FAR * LPCL_INFO;
typedef   CL_FILE_INFO FAR * LPCL_FILE_INFO;

#define   CLF_ENABLE         1   // default state for "Enable" checkbox; usually "ON"
#define   CLF_CONFIRM        2   // default state for "Confirm" checkbox; usually "OFF"
#define   CLF_INFO           16  // "Info" button supported
#define   CLF_SETUP          32  // "Setup" button supported

BOOL CALLBACK _export QueryName( WORD, LPCL_FILE_INFO, LP_DATA );
BOOL CALLBACK _export QueryConv( HWND, WORD, LPCL_FILE_INFO, LP_DATA );
BOOL CALLBACK _export OpenConv( HWND, WORD, LPCL_FILE_INFO, LP_DATA );
WORD CALLBACK _export RBlockSize( WORD, LP_DATA );
WORD CALLBACK _export Convert( LPBYTE, WORD, LPBYTE FAR *, LP_DATA );
void CALLBACK _export CloseConv( LP_DATA );

#endif
