/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : getpixel.c                                                */
/* Description  : bios level pixel routines                                 */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
#include <dos.h>

/* return the color value of the pixel at x, y */
char getpixel(int x, int y)
{
    union REGS inregs, outregs;

    inregs.h.ah = '\x0d';
    inregs.x.cx = x;
    inregs.x.dx = y;

    int86(0x10, &inregs,&outregs);
    return outregs.h.al;
}

void putpixel(int x, int y,int pixelvalue)
{
    union REGS inregs, outregs;

    inregs.h.ah = '\x0c';
    inregs.h.al = pixelvalue;
    inregs.x.cx = x;
    inregs.x.dx = y;

    int86(0x10, &inregs,&outregs);
}
