; Program Name    : grabsv.asm
; Author          : bill buckels
; Date            : oct 1993
;;Revised           jul 1996
;;                  removed the installation check
;;                  this causes some pentiums and PS2 compatible bios to hang

; Purpose         : a memory resident text screen grabber
;                   saves to disk in BSAVED image format

kb_data       equ 60h                       ;keyboard data port
kb_ctrl       equ 61h                       ;keyboard control port
eoi           equ 20h                       ;8259 end-of-interrupt value
int_ctrl_port equ 20h                       ;8259 PIC port
alt_key       equ 8                         ;alt key shift code
period        equ 34h                       ;hot key
_psegoff      equ 22    ;interrupt vector table address for
_poffoff      equ 20    ;the print screen handler vector entries

code          segment para public 'code'
              assume cs:code
              org 100h
begin:        jmp initialize         ;jump to initialization code

_crt         dd      0b8000000h      ;CGA screen address
_vmodeptr    dd      0400049h        ;BIOS display mode record
_installed   dd      0415h           ;Our Signature
pseg         dw      ?               ;Our Printscreen Vector Table Entries
poff         dw      ?
dos_seg      dw      ?               ;Dos Busy ?
indos        dw      ?               ;offset to indos flag
video_seg    dw      0b800h          ;CGA segment

ourpsp       dw      ?               ;save our psp for context switch
theirpsp     dw      ?               ;use their psp to restore context


; The Other ISR's in the chain must be serviced
old_int_9h         label dword       ;old keyboard interrupt vector
old_keyboard_int   dw 2 dup (?)
old_int_1ch        label dword       ;old timer interrupt vector
old_timer_int      dw 2 dup (?)
old_int_28h        label dword       ;old dos idle interrupt vector
old_dos_int        dw 2 dup (?)

hotkeystat         db 0              ;status of keyboard interrupt routine
dos_busy           db 0              ;status of dos
vid_ctr            dw 6              ;length of user defined filename
progress           db 0              ;is a screen save in progress ?
tick_cnt           db 0              ;timer counter

fheader      db      0fdh, 0, 0b8h, 0, 0, 0a0h, 0fh ; bsaved header
footer       db      1ah
buff         db      'S'   ; input field complete with screen attributes
             db      70h
             db      'V'
             db      70h
             db      'G'
             db      70h
             db      'R'
             db      70h
             db      'A'
             db      70h
             db      'B'
             db      70h
             db      '0'
             db      70h
             db      '0'
             db      70h
             db      '.'
             db      70h
             db      'B'
             db      70h
             db      'S'
             db      70h
             db      'V'
             db      70h
             db      ' '
             db      70h
             db         ' ',1fh
             db         'F',1fh
             db         'i',1fh
             db         'l',1fh
             db         'e',1fh
             db         'n',1fh
             db         'a',1fh
             db         'm',1fh
             db         'e',1fh
             db         '?',1fh
             db         ' ',1fh

screenbuffer db      48 dup(?)    ; save the screen under the field

fname                DB 'SVGRAB00.BSV',0    ; filename buffer
          fcnt1      DB '0'                 ; filename counters
          fcnt2      DB '0'
          handle     DW  ?                  ; filehandle

;-------------------------------------------------------
;Resident mainline and ISR routines
;-------------------------------------------------------

; hook the dos idle loop
; reset the dos busy flag if we are called
newdos proc near
       mov dos_busy,0
       jmp old_int_28h
       iret
newdos endp

;check if dos is busy
;ortoo in case the printscreen vectors get messed-up
;put our routine back again
timertick proc near
      sti
      push    ax
      push    cx
      push    dx
      push    bx
      push    sp
      push    bp
      push    si
      push    di
      push    ds
      push    es
      mov     bp,sp
      cmp     progress,0
      jne     inprogress
      push cs             ;put code seg into data seg
      pop ds

      mov     dos_busy,0                  ;test for dos busy?
      mov     ax,dos_seg
      mov     es,ax
      mov     bx,indos
      cmp     BYTE PTR es:[bx],0          ;if not we quietly leave
      je      SKIPDOS
      mov     dos_busy,1
SKIPDOS:
      ;replace the printscreen vectors
      ;every 5- seconds if it has been changed
      inc     tick_cnt
      cmp     tick_cnt,91
      jl      inprogress
      mov     tick_cnt,0

      mov     ax,0
      mov     es,ax

      mov     bx,_psegoff
      mov     ax, WORD PTR es:[bx]
      cmp     ax, pseg
      je      OK_SKIP
      mov     ax,pseg
      mov     WORD PTR es:[bx],ax

OK_SKIP:

      mov     bx,_poffoff
      mov     ax, WORD PTR es:[bx]
      cmp     ax, poff
      je      inprogress
      mov     ax, poff
      mov     WORD PTR es:[bx],ax

inprogress:
      mov     sp,bp
      pop     es
      pop     ds
      pop     di
      pop     si
      pop     bp
      pop     bx
      pop     bx
      pop     dx
      pop     cx
      pop     ax
      cli
      jmp     old_int_1ch
      iret
timertick endp

; when printscreen is pressed, save the screen to disk
printscreen proc near
      sti
      mov progress,1        ; don't bother us... we're busy
      push    ax
      push    cx
      push    dx
      push    bx
      push    sp
      push    bp
      push    si
      push    di
      push    ds
      push    es
      mov     bp,sp

      les     bx,DWORD PTR _vmodeptr      ;are we in text mode 3 or less
      cmp     BYTE PTR es:[bx],3          ;if not we quietly leave
      ja      FALSEXIT
      cmp     dos_busy,0                  ;is dos busy ?
      jne     FALSEXIT

      ;prepare for context switching
      mov ah, 51h
      int 21h
      mov theirpsp,bx
      mov ah, 50h
      mov bx, ourpsp
      int 21h

      push cs                ;put code seg into data seg
      pop  ds

      ;create the user name
      lea dx, fname          ; load the dos name buffer into es:[di]
      mov di,dx
      push ds
      pop es

      lea dx, buff           ; load the field name buffer into ds:[si]
      mov si, dx

doname:

      mov al, BYTE PTR ds:[si]  ;move the field into the dos buffer
      cmp al, 32                ;skip the screen attributes
      je finished               ;Blank ? We are done
      mov  BYTE PTR es:[di],al
      add si,2
      inc di
      jmp doname

finished:

      mov  al,0                 ;Replace the Blank with a NULL terminator
      mov  BYTE PTR es:[di],al
      sub  di,5
      mov  al,fcnt1             ;Embed the Counter Values Into The Name
      mov  BYTE PTR es:[di],al
      dec  di
      mov  al,fcnt2
      mov  BYTE PTR es:[di],al

      push ds                   ;Create/Truncate a Normal File
        lea dx, fname
        xor cx,cx
        mov ah,3ch
        int 21h
      jc MYEXIT
      pop ds
      mov handle,ax       ;save the handle for subsequent operations
      inc fcnt1           ;increment filename
      cmp fcnt1,'9'
      jle DOIT
      mov fcnt1,'0'
      inc fcnt2
      cmp fcnt2,'9'
      jle DOIT
      mov fcnt2,'0'
      jmp DOIT


FALSEXIT:
      jmp     TRUEXIT

DOIT:
      ; write the header
      push ds
        lea dx, fheader
        mov bx,handle
        mov cx,7
        mov ah,40h
        int 21h
      jc MYEXIT
      pop ds

      ; point to the screen
      ; write the body... 4000 bytes
      push ds
        mov bx,handle
        mov ds,video_seg
        xor dx,dx
        mov cx,4000
        mov ah,40h
        int 21h
      jc MYEXIT
      pop ds

      ; write the footer
      push ds
        lea dx, footer
        mov bx,handle
        mov cx,1
        mov ah,40h
        int 21h
      jc MYEXIT
      pop ds

      push ds
        ;close the file
        mov ah,3eh
        mov bx,handle
        int 21h
        mov ah,2
        mov dl,7
        int 21h
MYEXIT:
      pop ds
      clc
      mov ah, 50h
      mov bx, theirpsp
      int 21h
TRUEXIT:
      mov     sp,bp
      pop     es
      pop     ds
      pop     di
      pop     si
      pop     bp
      pop     bx
      pop     bx
      pop     dx
      pop     cx
      pop     ax
      mov progress,0      ;ok! we're not saving...
      cli
      iret
printscreen endp


keypress      proc near
              cmp hotkeystat,0       ;already displayed?
              jne short_exit         ;yes, then exit immediately
              sti                    ;enable interrupts
              push ax                ;save registers
              push bx
              push cx
              push dx
              push si
              push di
              push ds
              push es
              in al,kb_data                 ;get scan code from keyboard
              cmp al,period                 ;was the period pressed?
              jne exit                      ;no, then exit to normal routine
              mov ah,2                      ;get state of shift keys
              int 16h
              test al,alt_key               ;is the Alt key depressed?
              jne startup                   ;yes, then continue

;Exit is achieved thru here when execution is to be
;transferred to the normal
;BIOS keyboard interrupt handling routine.

exit:         pop es                 ;restore registers
              pop ds
              pop di
              pop si
              pop dx
              pop cx
              pop bx
              pop ax
short_exit:   jmp old_int_9h         ;goto BIOS keyboard routine

;The key combination Alt-Period was just pressed.
;Reset the keyboard and issue an
;EOI to the 8259 PIC to enable hardware interrupts.

startup:      call kb_reset          ;reset keyboard, end 8259 int
              push cs                ;set DS and ES to the code segment
              pop ds
              push cs
              pop es
              assume ds:code

;Check the current video mode to see if it's 80-column text mode 3
;If it's not, gracefully abort this
;routine by exiting thru an IRET.
;Set the interrupt routine status flag and
;Save the contents of the portion of the screen
;that will underlie the input field.
;Wait for a keypress.

              mov ah,15           ;get display mode
              int 10h
              cmp al,3            ;mode 3?
              jne done            ;yes, then continue
              mov hotkeystat,1    ;set interrupt routine status flag
              mov fcnt1,'0'       ;reset the counters
              mov fcnt2,'0'
              call open_screen    ;save screen contents

getaction:    mov ah,0            ;get a keypress
              int 16h
              cmp al,0            ;is it an extended code?
              je getaction        ;yes, then ignore
              cmp al,13           ;Enter key pressed?
              je do_done          ;no, then process
              cmp al,8            ;backspace pressed
              je process          ;allow only alpha-numeric input
              cmp al,'z'
              ja getaction
              cmp al,'a'
              jae process
              cmp al,'Z'
              ja getaction
              cmp al,'A'
              jae process
              cmp al,'9'
              ja getaction
              cmp al,'0'
              jb getaction
process:
              call update
              jmp getaction

;The Enter Key has been pressed.
;Restore the original contents of the screen,
;reset the status flag, and exit to the application.

do_done:
              call close_screen    ;restore video memory contents
              mov hotkeystat,0     ;reset status flag
done:         pop es               ;restore register values for exit
              pop ds
              pop di
              pop si
              pop dx
              pop cx
              pop bx
              pop ax
              iret           ;return to interrupted program
keypress      endp

;KB_RESET resets the keyboard and issues an EOI to the 8259 PIC.
kb_reset      proc near
              in al,kb_ctrl                 ;get current control port value
              mov ah,al                     ;save it in AH
              or al,80h                     ;set bit 7
              out kb_ctrl,al                ;send reset value
              mov al,ah                     ;get original value
              out kb_ctrl,al                ;send it out to enable keyboard
              cli                           ;suspend interrupts
              mov al,eoi                    ;get EOI value
              out int_ctrl_port,al          ;send EOI to 8259
              sti                           ;enable interrupts
              ret
kb_reset      endp

;call from keyboard handler to update the field
;and the screen as required
update proc near
      push es
      push ds
      push ax
      push bx
      push dx
      push si
      push di

      push cs
      pop ds

      cmp  al, 8            ;backspace... push everything back
      jne  normal           ;no? then insert a character
      cmp  vid_ctr,0        ;first character? don't allow underflow!
      jle  keydone          ;skip it!

      dec  vid_ctr
      lea  dx, buff
      mov  di, dx
      mov bx,vid_ctr
      shl bx,1
      mov si,bx
      add di,si

reverse:                     ;pull the current character out
       add  di,2
       mov  al,BYTE PTR ds:[di]
       sub  di,2
       mov  BYTE PTR ds:[di],al
       add  di,2
       add  si,2
       cmp  si,24
       jl  reverse

       jmp  keyupdate        ;display the shorter field

normal:
       cmp vid_ctr,5         ;6-character limit
       jg keydone            ;skip it!
       push ax               ;save the character
       lea  dx, buff
       mov  di, dx
       mov bx,vid_ctr
       shl bx,1
       mov si,bx
       add si,14
       add di,si

forward:                     ;make a space for the character

       mov  al,BYTE PTR ds:[di]
       add  di,2
       mov  BYTE PTR ds:[di],al
       sub  di,4
       sub  si,2
       cmp  si,bx
       jne  forward

       pop  ax                  ;pop the character and insert it.
       mov  BYTE PTR ds:[di],al
       inc vid_ctr

keyupdate:
      lea  dx, buff            ;point to the field
      mov  di, dx
      mov  es, video_seg       ;point to the screen
      xor  si,si

keydo:
      mov  al,BYTE PTR ds:[di] ; display the entry field
      mov  BYTE PTR es:[si],al ; all 24 characters
      inc di
      inc si
      cmp si,48
      jl keydo
keydone:

      pop di
      pop si
      pop dx
      pop bx
      pop ax
      pop ds
      pop es
      ret
update endp

close_screen proc near
      push es
      push ds
      push ax
      push dx
      push si
      push di

      push cs
      pop  ds
      lea  dx, screenbuffer
      mov  di, dx
      mov  es, video_seg
      xor  si,si

closeit:
      mov  al, BYTE PTR ds:[di] ; restore the screen
      mov  BYTE PTR es:[si],al
      inc di
      inc si
      cmp si,48
      jl closeit

      pop di
      pop si
      pop dx
      pop ax
      pop ds
      pop es
      ret
close_screen endp

open_screen proc near
      push es
      push ds
      push ax
      push dx
      push si
      push di

      push cs
      pop  ds
      lea  dx, screenbuffer
      mov  di, dx
      mov  es, video_seg
      xor  si,si

open1:
      mov  al, BYTE PTR es:[si] ; save the screen
      mov  BYTE PTR ds:[di],al
      inc di
      inc si
      cmp si,48
      jl open1

      lea  dx, buff
      mov  di,dx
      xor  si,si

open2:
      mov  al,BYTE PTR ds:[di] ; display the entry field
      mov  BYTE PTR es:[si],al
      inc di
      inc si
      cmp si,48
      jl open2

      pop di
      pop si
      pop dx
      pop ax
      pop ds
      pop es
      ret
open_screen endp

;------------------------------------------------------------
;         RESIDENT PORTION ENDS *** TRANSIENT PORTION STARTS
;------------------------------------------------------------

TITLE$  db 'ͻ',13,10
        db '  GRABSV(C) Copyright by Bill Buckels 1993,1996 ',13,10
        db '  A Memory Resident Text-Screen Frame-Grabber   ',13,10
        db '                                                ',13,10
        db '  Press Shift-Print Screen to Save Text Images  ',13,10
        db '  Text Screens will be saved in BSAVED Format   ',13,10
        db '                                                ',13,10
        db '  Press Alt-Period To Over-ride Image Name      ',13,10
        db 'ͼ'
TERM$   db 32  ; replace with a terminator
db  13,10
db 'Disclaimer: Although due care and caution is exercised by GRABSV(C),'
db  13,10
db 'Conflicts may arise when used with some programs or other TSRs.'
db  13,10
db 'This is also true with any TSR, especially those that write to disk.'
db  13,10
db 'Warning!!! Do Not Load More than 1 copy. The Installation check has been'
db  13, 10
db 'Removed for this version...'
db 13, 10
db 'Bill Buckels will not be held responsible for loss or damage caused by'
db  13,10
db 'the use of this program. Do you wish to continue ? (Y/N) $'

DUPE$    db 10,13,7,'GRABSV(C) is already installed!$'
NOWLOAD$ db 10,13,'GRABSV(C) is Now Resident!'
NICEDOS$ db 10,13,1,2,'Have a Nice Dos!$'

NEEDCGA$ db 'ͻ',13,10
         db '  GRABSV(C) Copyright by Bill Buckels 1993,1996 ',13,10
         db '  A Memory Resident Text-Screen Frame-Grabber   ',13,10
         db 'ͼ',13,10
         db 'A CGA Compatible Video Adapter is Required to Use GRABBSV(C)',13,10
         db 'It must be in 80 x 25 Text Mode...$'

;LIST$ writes a string to stdout
LIST$ proc near
      mov ah,9h ; call dos function 9H
      int 21h
      ret
LIST$ endp

;exit if the answer is no!
YESNO$ proc near
       mov ah,15           ;get display mode
       int 10h
       cmp al,3            ;mode 3?
       jne notcga          ;yes, then continue

       ;; removed the installation check
       ;; this causes some pentiums and PS2 compatible bios to hang
       ;; les     bx,DWORD PTR _installed    ;are we already installed
       ;; cmp     BYTE PTR es:[bx],128       ;if so we leave
       ;; je      installed

       lea dx, TITLE$
       call LIST$
       mov ah,1
       int 21h
       cmp al,'Y'
       je agree
       cmp al,'y'
       je agree
       lea dx,NICEDOS$
       call LIST$
       int 20h
notcga:
       lea dx, NEEDCGA$
       call LIST$
       lea dx, NICEDOS$
       call LIST$
       int 20h
installed:
       mov TERM$,'$'
       lea dx, TITLE$
       call LIST$
       lea dx, DUPE$
       call LIST$
       lea dx, NICEDOS$
       call LIST$
       int 20h
agree:
       lea dx, NOWLOAD$
       call LIST$
       ;; removed the installation check
       ;; this causes some pentiums and PS2 compatible bios to hang
       ;; mov     al, 128
       ;; les     bx,DWORD PTR _installed    ;installed signature
       ;; mov     BYTE PTR es:[bx],al
       ret
YESNO$ endp

;INITIALIZE performs tasks to set the stage for the resident part
;of the program.

initialize proc near

;let them know who we are

         call YESNO$

         ;prepare for context switching
         ;save our psp
         mov ah, 51h
         int 21h
         mov ourpsp,bx

         ;get the address of the dos busy flag
         mov ah, 34h
         int 21h
         mov dos_seg,es
         mov indos,bx

         ;save keyboard
         mov ah,35h              ;get current interrupt 9 vector
         mov al,9
         int 21h
         mov old_keyboard_int,bx       ;save vector offset
         mov old_keyboard_int[2],es    ;save vector segment
         ; save dos idle
         mov ah,35h               ;get current interrupt 28h vector
         mov al,28h
         int 21h
         mov old_dos_int,bx       ;save vector offset
         mov old_dos_int[2],es    ;save vector segment
         ; save timer tick
         mov ah,35h               ;get current interrupt 1ch vector
         mov al,1ch
         int 21h
         mov old_timer_int,bx     ;save vector offset
         mov old_timer_int[2],es  ;save vector segment

         mov ah,25h               ;set new printscreen vectors
         mov al,5
         lea dx,printscreen       ;point it to new handler
         int 21h
         ;save the address of the printscreen vectors
         mov ah, 35h
         mov al, 5
         int 21h
         mov pseg,es
         mov poff,bx

         mov ah,25h                ;set new keyboard vectors
         mov al,9
         lea dx,keypress           ;point it to new handler
         int 21h
         mov ah,25h                ;set new dos idle vectors
         mov al,28h
         lea dx,newdos             ;point it to new handler
         int 21h
         mov ah,25h                ;set new timertick vectors
         mov al,1ch
         lea dx,timertick          ;point it to new handler
         int 21h


;Exit thru INT 27h and reserve some room
;the offset of TITLE$ is a marker to end of resident code

           mov dx,offset TITLE$            ;reserve space for code
           int 27h                         ;terminate-but-stay-resident
initialize    endp

code          ends
              end begin

