@echo off
rem -------------------------------------------------------------
rem  %sndrive%\usr\lib\snuupm\rmuser.bat
rem  -----------------------------------
rem
rem  Removes a user from the SNUUPM system.
rem  Author: Mike Lawrie (mlawrie@apies.frd.ac.za)
rem  Uses ASKENV.EXE from Timo Salmi's tsbat40.zip (ts@uwasa.fi)
rem
rem   Modified Dave Cantor
rem   15-Aug-1994   Remove forward.txt, if it exists
rem        "        Anchor username search with terminating colon
rem   17-Aug-1994   Make loop with askenv and find to examine
rem                 each record in passwd file, and re-append records
rem                 which were removed extraneously.
rem
rem  Uses environment variables, so needs environment space. Make
rem  your CONFIG.SYS file have a line something like this, to allow
rem  for, say, 2048 bytes of environment space:-
rem
rem            shell=c:\command.com c:\ /e:2048  /p
rem
rem  (Dave Cantor's mods have been further altered by Mike Lawrie, so
rem  direct bug reports to Mike rather than to Dave.)
rem -------------------------------------------------------------

if not exist %sndrive%\etc\uupc\passwd.$$$ goto lastok
echo The file %sndrive%\etc\uupc\passwd.$$$ exists. This is possibly
echo due to a crash of a previous RMUSER run. Please check very
echo carefully before re-running this program.
goto ends

:lastok
copy %sndrive%\etc\uupc\passwd %sndrive%\etc\uupc\passwd.bak
if exist %sndrive%\etc\uupc\passwd goto gotpwdf
echo The file %sndrive%\etc\uupc\passwd does not exist.
echo.
echo Something has gone seriously wrong with your SNUUPM user-registration
echo process. You might have to remove and re-install the entire package,
echo which is bad news.
goto ends

:gotpwdf
if "%1"=="" goto getuser
set snuupmuser=%1
goto confirm
:getuser
askenv Type in the user-id to be removed ---
set snuupmuser=%ASKENV%
if "%SNUUPMUSER%"=="" goto ends
rem -------------------------------------------------------------

:confirm
echo %SNUUPMUSER%|askenv /b /l
set snuupmuser=%askenv%
echo You are about to remove USER-ID "%SNUUPMUSER%"
echo.
echo NOTE CAREFULLY ---- This must be the USER-ID, not the Proper Name.
askenv Is this correct? (y/n) /l
if "%ASKENV%"=="y" goto count
if "%ASKENV%"=="n" goto getuser
goto confirm
rem -------------------------------------------------------------

:count
type %sndrive%\etc\uupc\passwd|find /c "%SNUUPMUSER%:"|askenv x>nul
if not "%ASKENV%"=="0" goto chdir
echo.
echo I cannot find an entry in %sndrive%\etc\uupc\passwd for user-id "%SNUUPMUSER%".
echo.
echo Re-check that you have typed a valid user-id.
goto ends

:chdir
set sn_rmu=%sndrive%\usr\%snuupmuser%
if not exist %sn_rmu%\nul goto nodirs
if not exist %sn_rmu%\mail\nul goto nodirs
if not exist %sn_rmu%\mbox\nul goto nodirs
goto rmdirs
:nodirs
echo It seems as if the directories for "%snuupmuser%" do not exist.
echo Maybe you have mis-typed the user-id of the user to be removed?
echo Alternatively, re-create them manually and try again to remove
echo the user.
goto ends

:rmdirs
echo Removing directories....
if exist %sn_rmu%\mail\nul for %%x in (%sn_rmu%\mail\*.*) do del %%x
if exist %sn_rmu%\mail\nul rmdir %sn_rmu%\mail
if exist %sn_rmu%\mbox\nul for %%x in (%sn_rmu%\mbox\*.*) do del %%x
if exist %sn_rmu%\mbox\nul rmdir %sn_rmu%\mbox
if exist %sn_rmu%\aliases.txt del %sn_rmu%\aliases.txt
if exist %sn_rmu%\%SNUUPMUSER%.rc del %sn_rmu%\%SNUUPMUSER%.rc
if exist %sn_rmu%\alias del %sn_rmu%\alias
if exist %sn_rmu%\%SNUUPMUSER%.sig del %sn_rmu%\%SNUUPMUSER%.sig
if exist %sn_rmu%\snews.nrc del %sn_rmu%\snews.nrc
if exist %sn_rmu%\snews.rc del %sn_rmu%\snews.rc
if exist %sn_rmu%\forward.txt del %sn_rmu%\forward.txt
if exist %sn_rmu%\nul rmdir %sn_rmu%
if exist %UUPCNEWS%\%SNUUPMUSER%.nrc del %UUPCNEWS%\%SNUUPMUSER%.nrc

echo.
echo Removing %SNUUPMUSER% from %sndrive%\etc\uupc\passwd....
rem -------------------------------------------------------------
rem File usage for passwd.*
rem    (no extension) - password file
rem     .$$$            saved file from the start of this procedure
rem     .rem            "removals" -- records that are candidates to be
rem                                   removed from passwd file
rem     .tmp            temporary holding one line from .rem file
rem -------------------------------------------------------------

if "%debug%"=="" goto debug01
echo Original passwd file:-
type %sndrive%\etc\uupc\passwd
pause
:debug01

ren %sndrive%\etc\uupc\passwd passwd.$$$> nul
type %sndrive%\etc\uupc\passwd.$$$ |find /v "%SNUUPMUSER%:"> %sndrive%\etc\uupc\passwd

if "%debug%"=="" goto debug02
echo First attempt at creating the new passwd file:-
type %sndrive%\etc\uupc\passwd
pause
:debug02

if exist %sndrive%\etc\uupc\passwd.rem del %sndrive%\etc\uupc\passwd.rem
type %sndrive%\etc\uupc\passwd.$$$ |find "%SNUUPMUSER%:"> %sndrive%\etc\uupc\passwd.rem
if not errorlevel 1 goto checkline
if "%debug%"=="" echo No match found for user %snuupmuser% in passwd file.
rem  ...So now we restore the original file.  Too bad the files and
rem  directories are gone.

rem  At this stage, the original passwd file should not exist. So, here's
rem  a check - if it exists, stop the world.
if not exist %sndrive%\etc\uupc\passwd goto passwdok
echo DISASTER!
echo There is a major logic error in the
echo file %sndrive%\usr\lib\snuupm\rmuser.bat.
echo.
echo The file %sndrive%\etc\uupc\passwd exists at a point in the logic
echo of the process that says that it should not exist. Please have a
echo very good look at the various passwd files in the directory
echo %sndrive%\etc\uupc, and do a manual recovery.
pause
goto ends

:passwdok
ren %sndrive%\etc\uupc\passwd.$$$ passwd> nul
goto ends
rem -------------------------------------------------------------

:checkline
if "%debug%"=="" goto debug03
echo At label ":checkline". This is the removals file:-
type %sndrive%\etc\uupc\passwd.rem
pause
:debug03

rem Get one line from the removals file
askenv /b < %sndrive%\etc\uupc\passwd.rem> nul
set snu_1=%askenv%
rem  If the removals file was empty, we are done.
if "%snu_1%"=="" goto done

rem Prefix a ":" to the one line, and search for the username anchored
rem on both ends
rem If no match, re-append this record to main passwd file
echo :%snu_1% | find /c ":%snuupmuser%:" | askenv /b
if not "%askenv%"=="1" echo %snu_1%>> %sndrive%\etc\uupc\passwd

if "%debug%"=="" goto debug04
echo This is the passwd file as it builds up again:-
type %sndrive%\etc\uupc\passwd
pause
:debug04

rem Move significant lines (with ":") from removals to temp file
type %sndrive%\etc\uupc\passwd.rem |find ":"> %sndrive%\etc\uupc\passwd.tmp

rem Remove the one record we were working on from the temp file and
rem   rewrite as the new "removals" file.  Eventually we will deplete it.
type %sndrive%\etc\uupc\passwd.tmp |find /v "%snu_1%"> %sndrive%\etc\uupc\passwd.rem
goto checkline
:done
if exist %sndrive%\etc\uupc\passwd.rem del %sndrive%\etc\uupc\passwd.rem
if exist %sndrive%\etc\uupc\passwd.tmp del %sndrive%\etc\uupc\passwd.tmp
if exist %sndrive%\etc\uupc\passwd.$$$ del %sndrive%\etc\uupc\passwd.$$$
echo ...done.
rem -------------------------------------------------------------
:ends
set snuupmuser=
set askenv=
set sn_rmu=
set snu_1=
pause

rem -------------------------------------------------------------
rem  $Id: rmuser.bat 1.1 1995/04/30 20:14:00 mlawrie Exp $
rem
rem  $Log: rmuser.bat $
rem  Revision 1.1  1995/04/30 20:14:00  mlawrie
rem  Initial revision
rem
rem -------------------------------------------------------------
rem ----ends-----------------------------------------------------
