/*
 *      pwd.h: password function header file
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This is the header file for my family of password-file functions
 *      for MS-DOS.  I based these functions on information available in
 *      our library; I do not have access to any restricted source code.
 *      Therefore, these functions are in the public domain.
 *
 *      This implementation of getpwent() and friends should be pretty
 *      much compatible with the BSD implementation.  Some little-used
 *      features may have been omitted, but you've got the source and
 *      you are welcome to add whatever features you need.
 *
 */

struct passwd {
    char pw_name[12];
    char pw_passwd[12];
    int pw_uid;
    int pw_gid;
    char pw_gecos[80];
    char pw_dir[80];
    char pw_shell[80];
    } ;

struct passwd *getpwent(void);
struct passwd *getpwuid(int id);
struct passwd *getpwnam(char *nam);
int setpwent(void);
int endpwent(void);
int pw_openfile(char *name);  /* Specify a filename to use for password file */
