/**************************************
 * rmdupi.c - ANSI C
 * text filter
 * removes duplicate lines from a sorted file
 * Case-insensitive
 * Uses:
 *	rmdupi < sortedfile [ > outputfile]
 *      sort < infile |rmdupi [ > outputfile]
 */

/**************************************
 * rmdupi.c  - ANSI C
 * filtro de texto
 * remove duplicados de uma lista ordenada
 * Nao distingue maiusculas de minusculas
 * (excepto caracteres acentuados)
 * a saida e' a lista sem duplicados
 * Exemplos de uso:
 *	rmdupi < sortedfile [ > outputfile]
 *      sort < infile |rmdupi [ > outputfile]
 */

/* User-supported freeware with source
 * Freeware com codigo origem sem apoio do autor
 *
 * Joao Magalhaes, 1996
 * jcm@individual.EUnet.pt
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define LEN     4097    /* line length 		*/
			/* comprimento da linha */

char * UpCase(char * S)
   {
   char * P = S;

   while (*P) *P = toupper(*P), P++;
   return S;
   }

int Different(char * S1, char * S2)
   {
   char X1[LEN], X2[LEN];

   strcpy(X1, S1);
   strcpy(X2, S2);

   UpCase(X1);
   UpCase(X2);

   return strcmp(X1, X2);
   }


int main(void)
   {
   char Prev[LEN], Curr[LEN];

   gets(Prev);

   while(gets(Curr))
      {
      if (Different(Prev, Curr))
	  puts(Prev);
      strcpy(Prev, Curr);
      }
   puts(Prev);
   return 0;
   }

/* code ends */

