#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define LINE_LEN 81
#define LINE_NUM 121
#define PARA_LEN 9801           /* 121 lines of length 81*/
#define LEVEL_ONE_MARK "Chapter:"

int Log=0;

/* utilities for strings and that */

char * TrimLeft(char * S)
   {
   while ((*S) && isspace(*S)) S++;
   return S;
   }

char * TrimRight(char * S)
   {
   char *P = S;

   do {P++;} while (*P);
   do {P--;} while (isspace(*P));
   P++;
   *P=0;
   return S;
   }

char * SubString(char *S, int A, int B)
   {
   char *P1, *P2, *T, Temp[129];

   P1 = P2 = S;
   T = Temp;
   P1+=+A;
   P2+=+B;

   while (P1 !=P2)
      {
      *T = *P1;
      P1++;
      T++;
      }
   *T = 0;

   return Temp;
   }

char * UpCase(char * S)
   {
   char * P = S;

   while (*P) *P = toupper(*P), P++;
   return S;
   }

char * ClearString(char * S)
   {
   char *P = S;
   while (*P) *P=0x00, P++;
   return S;
   }

void RemoveLastCRLF(char * S)
   {
   char *P=S;

   while (*P) P++;
   while (*P != '\n') P--;
   *P=0;
   }


/*** Now something completely different ***/

int HasCRLF(char * S)
   {
   char *P=S;
   while (*P) P++;
   P--;
   if (*P == '\n') return 1;
   else return 0;
   }


int IsL1Mark(char * S)
   {
   char Temp[LINE_LEN];
   char *P = Temp;

   strcpy(Temp, S);

   P += (sizeof(LEVEL_ONE_MARK)-1);
   *P=0x00;

   if (!strcmpi(Temp, LEVEL_ONE_MARK))
      {
      UpCase(S);
      return 1;
      }
   return 0;
   }

int Scan(char * V, char * Key)
   {
   int I, J, K;
   I = 0;
   J = strlen(Key);
   K = strlen(V) - J;
   for (I=0; I< K; I++)
      {
      if (! V[I]) break;
      if (! strcmpi(Key, SubString(V, I, J)))
	 return 1;
      J++;
      }
   return 0;
   }

int Process(char S[][LINE_LEN], char * Word)
   {
   int I=0;
   int Len=0;
   char Vector[PARA_LEN];

   while (I< PARA_LEN) Vector[I]=0x00, I++;

   for (I=0; I<LINE_NUM; I++)
      {
      if(! *S[I]) break;
      if (HasCRLF(S[I])) RemoveLastCRLF(S[I]);

      Len += (strlen(S[I])+1);
      strcat(Vector, TrimLeft(TrimRight(S[I])));
      strcat(Vector, " ");
      }

   Vector[Len-1] = 0x00;

   if (Scan(Vector, Word)) return 1;
   else return 0;
   }

void WriteLog(FILE * Fp, char * S)
   {
   fprintf(Fp, "%s\n", S);
   fflush(Fp);
   }

void PrintArray(FILE * Fp, char S[][LINE_LEN])
   {
   int I=0;

   while(* S[I])
      {
      if (Log)
	 fprintf(Fp,"%s\n", S[I]);
      else
	 printf("%s\n", S[I]);
      I++;
      }
   if (Log)
      {
      fprintf(Fp, "\n");
      fflush(Fp);
      }
   else putchar('\n');
   }



int main(int argc, char ** argv)
   {
   FILE * Fp, *LogFp;
   int Line, I, J, Header, PartialHits, TotalHits;
   char FileName[80], LogFilePath[80];
   char PrevLineChar = '\n';
   char InStr[LINE_LEN];
   char CurrentHeader[81];
   char InArray[LINE_NUM][LINE_LEN];
   char Word[256];

   if (argc < 3 )
      {
      puts("Error: not enough parameters.\nExiting.");
      exit(1);
      }

   PartialHits = TotalHits = 0;

   strcpy(FileName, argv[1]);
   strcpy(Word, argv[2]);
   if (*argv[3])
      {
      Log =1;
      strcpy(LogFilePath, argv[3]);
      LogFp = fopen(LogFilePath, "a+");
      if (!LogFp)
	 {
	 printf("\nFatal: cannot open %s for append.\nExiting.\n",
		LogFilePath);
	 exit(1);
	 }
      }


   printf("\nParagraph scan of %s for \"%s\":\n\n",
	  FileName, Word);
   if (Log)
   fprintf(LogFp, "\nParagraph scan of %s for \"%s\":\n\n",
	  FileName, Word);

   Fp = fopen(FileName, "rt");
   if (!Fp)
      {
      printf("\nFatal: Cannot open %s for rt.\n", FileName);
      exit(1);
      }

   if (Log) printf("\nOutput will also be echoed to log file.\n");

   Line = 0;
   while(fgets(InStr,81,Fp))
      {
      if (*InStr != '\n')
	 if (IsL1Mark(InStr))
	    {
	    Header = 1;
	    if (PartialHits)
	       {
	       printf("Hits: %d paragraphs.\n", PartialHits);
	       if (Log)
		  fprintf(LogFp, "Hits: %d paragraphs.\n", PartialHits);
	       }
	    PartialHits=0;
	    strcpy(CurrentHeader, InStr);
	    printf("%s", CurrentHeader);
	    if (Log) fprintf(LogFp,"%s", CurrentHeader);
	    continue;
	    }
	 else
	    Header = 0;

      if (! Header)
	 if (PrevLineChar == '\n')
	    {
	    if (*InStr == '\n')
	       continue;
	    else
	       {
	       strcpy(InArray[Line], InStr);
	       Line++;
	       PrevLineChar = *InStr;
	       }
	    }
	 else
	    {
	    if (*InStr == '\n')
	       {
	       PrevLineChar= *InStr;
	       /* process & reset */
	       if (Process(InArray, Word)) /* a HIT occurred if TRUE */
		  {
		  PrintArray(LogFp, InArray);
		  PartialHits++; TotalHits++;
		  }

	       /* reset */
	       for (I=0; I<= Line; I++)
		   for(J=0; J<LINE_LEN; J++)
		      InArray[I][J] = 0x00;
	       Line =0;
	       }
	    else
	       {
	       strcpy(InArray[Line], InStr);
	       Line++;
	       PrevLineChar = *InStr;
	       }
	    }
      }

   fclose(Fp);
   printf("Total hits: %d paragraphs.\n", TotalHits);
   if (Log) fprintf(LogFp,"Total hits: %d paragraphs.\n", TotalHits);
   fclose(LogFp);
   return 0;
   }
