
								LM(1)



   Name
     LM  - file or stream line manipulator  (ver 2.06)

   Syntax
     LM [-options] [-@] [offstrs ...]

   Description
     The LM command inputs line by line from files or stdin,
     then manipulate the line according to the command line
     options before sending the final form to a file or stdout.
     If the final form of the line contains any/all the strings
     specified in offstrs, then that line will not be output --
     and is thus non-gripped. We note that the earlier version
     of this utililty is call NG or NGRIP.

     The main operations supported are grip/non-grip,
     search/replace, synchronised line appendage from other
     files, input/output line selection by line numbers or
     passwords, spaces/empty lines absorption, filewise update
     or renaming, line width imposition and etc. Input lines
     can also be taken from only the command line.

     All valid options strings must be immediately preceded by
     '-', or a valid option entry of single character or number
     option character type, see below. An invalid option string
     becomes a part of offstrs. However, offstrs can also be
     entered as normal parameters via -~offstrs. To force the
     current valid option string as the last option string,
     include '@' in that string.

     Duplicated execution of LM maybe separately by "-;", while
     long command parameters maybe taken from files via
     "-<filenames" from which each separate line serves as one
     execution of the LM. These two functions are largely
     implemented to overcome the time waste of reloading LM for
     multiple executions, and the maximum line width of a
     command in DOS.

     There are three types of option characters
       1. String option character:
	    all the characters in that string after the string
	    option character compose a single substring that
	    becomes the parameter specified by the option
	    character.
       2. Number option character:
	    all the digits and possibly a leading '-' will be
	    converted into an integer that becomes the
	    parameter specified by the number option character.
	    If no immediate digits are present, 0 is the
	    default parameter number.
       3. Simple single character:
	    it can be put anywhere (not after string option
	    character of course)

     Directives via multi parameters specified by a same option
     character will be performed sequentially. Thus all files
     of a same purpose will for instance be read sequentially.

     Different operation tasks are performed in the following
     sequential order

	-@  -<*  -;*  -hH -j# -v  -V  -X#  -/#  -{#(X13)  -[]*
	-}*  -BE*(#)  -zZ#  -$*(j20-j28 &1-4)  -c#  -:*  -^*(+1)
	-fF*(+0X#)  -*`*  -pP*(M#+2)  -iI#  -lL#  -sS#  -dD*(C2n#)
	-g*(G#J1!#j9)[X5]  -qr*(j1j2j6-8)  -QR*(j3j4j6-8)  -()*
	-m*(C3kK*)  -Y#  -t#  -T#  -a  -A*  -~*(C1J2)
	-=#(X1)  -y#  -oO#(N#!#) -!#  -N#  -be*(#)  -w#(W#)
	-uU*(+3)  -#?  -#?(even no. of such options)
	-.#  -x#

	(-=# -zZ# -$* -&# -j20-j28 are supported in DOS only)

     where * is a string, # or ? (after a character) is a
     number and the options in the parentheses are the related
     flags, and those in square brackets are forced options.

   Options
     -a     absorb white spaces
     -A*    add substr * in front of each character, other
	    than the ending linebreak '\n'. If the combined
	    string is '0xff'?$, where ? is any char and $ is
	    any string, then the char represented by ? will
	    represent in $ the char that the whole string is
	    in front of.    e.g. lm -/255A#x#y will translate
	    input "abc" into  "xayaxbybxcyc".
     -b*    strings * to be added at the beginning of each
	    output line
	    (cf. -e* -B* -E* -#)
     -B*    strings * to be added at the beginning of the
	    whole output
	    (cf. -E* -b* -e* -#)
     -c#    input comes only from the command line
	      0=input only
	      DOS meaningful:
	      1=output path to the current copy of LM
	      2=output full pathname of current LM
		(output immediately after -B*)
	    (cf. -:*)
     -C#    case insensitive.
	      0=no case for all (1,2,3 below)
	      1=no case for non-grip (command line strs or -~*)
	      2=no case for delimitered locate (-d* -D*)
	      3=no case for mask filter (-m*)
	      default: case sensitive
     -d*    left delimiter string * to locate a substring
	    (cf. -D* -C# -n#)
     -D*    right delimiter * to locate/filter through a sub
	    string
	    (cf. -d* -C# -n#)
     -e*    strings to be appended at end of each output line
	    (cf. -b* -B* -E* -#)
     -E*    strings * appended at the end of whole output
	    (cf. -B* -b* -e* -#)
     -f*    filename * for input, empty * implies stdin device.
	    -f//# will replace //# by the #th-entry of the
	    environmental parameter LMFILES (if it exists),
	    separated by ";" for DOS or ":" for UNIX.
	    (cf. -** -F* -+# -X7)
     -F*    input filename *, support wild cards '*' and '?'
	    in the UNIX convention. -F will also default to -X5
	    unless -X# option is explicitly entered. -F* will
	    make first level expansion of wild card filenames
	    before any line input is done.  In the case of
	    -F//*, * will be parsed and each entry separated
	    by ';' for DOS or ':' for UNIX will be treated
	    separately. e.g. -F//one*;two?? will be parsed as
	    -Fone* -Ftwo??
	    (cf. -** -`* -f* -+# -X5 -X7)
     -g*    keep/output current line if it matches string * in
	    the sense specified by -G#. If any of options -j9, -(*
	    and -)* is present, -g* no longer grips lines for
	    output. Instead, it lets all lines into output while
	    marking those conaining specified substr for treatment
	    by the -(* -)* options. In the case of -j9 being present,
	    replacement via -qrQR* are applicable only to those
	    gripped lines
	    (cf. -G# -!#)
     -G#    comparison mode:  (not co-existent)
	      0=identical
	      1=substring inside main line (default)
	      2=identical upto letter case
	      3=substring inside main line upto letter case
	      4=identical upto case and consecutive spaces
	      5=substring inside main line upto case and
		consecutive spaces, e.g. "ab AB" = "ab   AB"
	     10-15=0-5 plus interpretation for wild cards '*'
		   and '?' in the UNIX convention.
	    (cf. -g* -M#)
     -h     simple help    =-? /? /h /H
	    the above variants become active only if '@' is not
	    used to terminate the option strings. It is used to
	    guess user's intention to seek help.
	    (cf. -H)
     -H     further help. -hH will output this manual.
	    (cf. -h)
     -i#    lines after and including #-th one from input will
	    be read in
	      #<0 =reset line counter to 0 filewise
	    (cf. -I# -o# -O# -p* -P*)
     -I#    lines after #-th one from input will be dumped
	    (cf. -i# -o# -O# -p* -P*)
	      #<0 =reset line counter to 0 filewise
     -j#    mode of string replacement
	      1=replace all found strings via -qr (default)
	      2=replace strings which start from the first
		letter of the line for via -qr
	      3=replace all via -QR (default)
	      4=replace far left string via -QR
	      5=normal mode
	      6=only words separated by non-alphabets are to
		be replaced
	      7=only words separated by non-alphabets other
		than '_' are to	be replaced
	      8=only words separated by space or tab are to be
		replaced
	      9=replace only those strs in the lines gripped via
		the -g* option (changes normal meaning of -g)
	     10-19=change buffer line width to MAXINT/11*(j-9)
	     20-28=(DOS only)
		   keyboard instant input of a char via -$*,
		   the opposite of the following 20-27 is the
		   default mode
	     20=match is case insensitive
	     21=char echo off
	     22=escape key enabled: escape key leaves the
		direct key input mode
	     23=no beep at an unexpected key
	     24=exitcode returned in the end will be the ASCII
		char code instead of the position found in the
		string given via -$*
	     25=clear keyboard buffer first
	     26=no loop: leave immediately after getting a key,
		whether it is valid or not
	     27=no wait: get a key from keyboard buffer, leave
		immediately afterwards. Priority over looping.
	     28=get extended keys. In this mode extended keys
		can be filtered in via -$* directly
	     <0=maximum line width is forced to corresponding
		absolute value #
	    (cf. -q* -r* -Q* -R* -$*)
     -J#    AND mode for multi-string search
	      0=AND mode for all (1+2 below)
	      1=for grip via -g*
	      2=for non-grip via -~* or offstrs
	    (cf. -g* -~*)
     -k#    character of ASCII code # is accepted as one of the
	    pre-delimiters for the masked filter via -m* .
	    default pre-delimiters=" \n"
            (cf. -K# -m*)
     -K#    character of ASCII code # as one of the post-
            delimiters for the masked filter via -m*.  All
            pre-delimiters that are not in the post-delimiters
	    will be translated into the post-delimiters if
	    successfully filtered.
	    default post-delimiters=" \n", -kK0=no delimiters
	    (cf. -k# -m*)
     -l#    letters in any line will be kept after and including
	    the #-th letter
	    (cf. -L# -s# -S#)
     -L#    letters in any line will not be kept after #-th one
            (cf. -l# -s# -S#)
     -m*    string * as mask (no wild cards) for filtering
	    through the substrings *.
	    (cf. -C# -k# -K#)
     -M#    comparison mode for input password on/off switch,
	    see -G# for the meaning of #.
	    default: #=1 (inside, case sensitive)
	    (cf. -p* -P* -G#)
     -n#    directive for locating substrings via -d* -D*
	      0=find the last occurrence, i.e. find from right
		hand side
              1=located substring will go along with its
                delimiters
		default: find from the left, delimiters will be
		striped off
	    (cf. -d* -D* -C#)
     -N#    total number of allowed output lines, terminate
	    immediately when reached
	      #<0 =reset output line counter to 0 filewise
	    (cf. -o# -O#)
     -o#    output lines after and including the #-th line
	    will be sent to stdout, -o# -O# can be given in
	    any order as the program will figure out a
	    meaningful collection of choice intervals.
	      #<0 =reset line counter to 0 filewise
	    (cf. -O# -N# -!# -i# -I#)
     -O#    output lines after #-th line will not be sent to
	    the stdout
	      #<0 =reset line counter to 0 filewise
	    (cf. -o# -N# -!# -i# -I#)
     -p*    password to switch on/off the input, the current
	    line will not be taken. Only one switch per line
	    may be performed.
	    (cf. -M# -i# -I#)
     -P*    password * to switch on/off the input, the current
            line will be taken
            (cf. -M# -i# -I#)
     -q*    search string * for replacement, case sensitive
	    (cf. -r* -j# -Q* -R*)
     -Q*    search string * for replacement, no case
	    (cf. -R* -j# -q* -r*)
     -r*    replaced string *, for the case sensitive search
	    via -q*
	    (cf. -q* -j# -Q* -R*)
     -R*    replaced string *, for the case insensitive search
            via -Q*
	    (cf. -Q* -j# -q* -r*)
     -s#    string/word after and including the #-th one will
	    be kept
            (cf. -S# -l# -L#)
     -S#    string/word after the #-th one will be dumped
            (cf. -s# -l# -L#)
     -t#    translate characters
	      0=TAB to single space
	      1=convert to upper case (priority)
	      2=convert to lower case
	      3=reverse the order of characters in a line
     -T#    trim off the leading and trailing spaces
	      0=1+2 of the options below
	      1=remove leading spaces/TABs
	      2=remove trailing spaces/TABs
     -u*    file * whose lines will be added in front of each
	    input line in the synchronised mode
	    (cf. -U* -+# -w#)
     -U*    file * whose lines will be added at the end of each
	    input line in the synchronised mode
	    (cf. -u* -+# -w#)
     -v     view the command parameters, as understood by the
	    computer
     -V     the strings specified via -beBE$ will be sent to
	    the stderr.
     -w#    wrap line into no more than the width #. If -u* or
	    -U* are present, then -w# is disabled.
	    (cf. -W# -u* -U*)
     -W#    width of line-wrap control
	      0=1+2 of the options below
	      1=protect words  (default: no protection)
	      2=pad spaces on the right upto the width given
		via -w#
	      3=pad spaces on the right without break up lines
	    (cf. -w*)
     -x#    exit error level request of type #
	      0=any of the followings has been achieved
	      1=pP (-p -P are the corresponding option letters)
	      2=empty input
	      3=lL    4=sS    5=dD     6=qrQR    7=g      8=m
	      9=t    10=T    11=Y     12=a      13=A     14=N
	      15=y   16=~ or non-grip (command line strs)
	      17=-=* successful (DOS only)
	      18=dir/file names via -fF matched with -* -` options
	      19=readable filenames via -fF matched with -* -`
	      20=exit code is number of output lines + initial
		 number given via -#. Lines given via -beBEw
		 are not counted, lines linked via -Y# will
		 still be counted separately. If -# is entered
		 even number of times, the virtual input line
		 number plus the initial number specified by the
		 sum of the -# option will be the exit code.
	      21=some lines not gripped nor accepted via -!, when
		 a -g option is present. This option is disabled
		 -(* or -)*
	      -$* overrides exitcode request via -x#.
	    (cf. -.#)
     -X#    message display level
	      0=1+2
	      1=suppress the line width overflow warning, or
		warning for unable to set (some) environment
		parameters
	      2=no input filenames display
	      3=input filenames sent to stderr device
	      4=input filenames sent to stdout or output file
	      5=display all filenames searched/failed to stderr
	      6=display all filenames searched/failed to stdout
		or the output file
	      7=display extra filenames for the matched entries
	      8=same as 7, except without the prompt "MATCHED: "
	      9=display in 7/8 dir names
	     10=display in 7/8 file names
	     11=always display all file names to stderr
	      default=none of the above, unless -F option is
		      used in which default=-X5
	      When -X7 or -X8 is present, if neither -X9 nor -X10
	      is present, then all dir/file names will be
	      displayed with "+" added to the front of the
	      directory names.
	     12=quiet: no messages for rename filewise via -{1[*]*
		Otherwise output to device stderr or stdout
	     13=allow overwrite via -{2 (double confirmation)

	     99=programmer's memory report, 0=all memory released
	    (cf. -F*)
     -y#    empty line deletion
	      0=consecutive empty lines become one single empty
		line
	      1=remove all empty lines
	      2=consecutive duplicated input lines will be left
		with just one input line
	     <0=consecutive lines considered mathched as in 2
		if (-#)-th words are matched correspondingly.
		Action in 2 will then be performed. Empty words
		are always matched.
     -Y#    line link-up (line break deletion)
	    linebreak becomes/absorbed-into a white space.
	      0=paragraph become a single line
	      1=whole input becomes a single line
     -z#    (DOS only) play sound of frequency # immediately
	    after -B* with duration given via -Z#
	    (cf. -Z#)
     -Z#    (DOS only) sound duration in milliseconds matching
	    the frequency one by one given via -z#
	    (cf. -z#)
     -<*    take line by line from file *, as if they are
	    the command parameters. This option is to enable
	    long command parameters to be treated properly.
	    -<* has priority over -;*
	    (cf. -;* -~*)
	    When -<* type options are present, then all command
            parameters upto the last occurrence of -<* will be
            processed first if there's at least one separate
	    option appears in front of the string that contains
            the first -<* type option, otherwise such
	    intermediate options will be ignored. If there are
            further options string after the last occurrence of
	    -<*, LM is run again with these option parameters.
            e.g.
	      LM -a "-Y<file1" -y "-t<file2" -w60
	    gives essentially the output of
	      LM -aYyt | LM "-<file1" "-<file2" |LM -w60
	    while
	      LM  "-Y<file1" -y "-t<file2"
	    gives the output of
	      LM  "-<file1"  "-<file2"
            as the 'middle' options -Yyt under such circumstance
	    is best ignored because their natural interpretation
	    is somewhat ambiguous.
     -;*    execute LM with command parameters upto the
	    current one, then execute LM again with the
            following parameters upto the next appearance of
	    ";" as the command parameters. Then go on likewise.
	    (cf. -<* -~*)
     -[*    string in filename to be searched in filewise mode via
	    -{#. Replaced str given by -]*
	    (cf. -]* -{# -}*)
     -]*    replaced str for the found match via -]*.
	    (cf. -[* -{# -}#)
     -{#    output filewise: output filenams are changed along with
	    the input filenames via the use of -[* -]* and -}*.
	      0=filewise rename for DOS and move for UNIX
	      1=normal filewise
	      2=make subdirs if needed
	      3=2+ no query
	      4=3+ no query
	     -n=remove leading subdirs upto n dir delimiters
	     default=no filewise
	    For update, root files for DOS or /tmp/ files for UNIX
	    are used for temporary files on the same disk as input
	    files.
     -}*    in filewise output mode (-{#: #>=0), output filenames
	    are dressed up by the strs * from the input filenames.
	    Input filenames (minus path) are first processed by the
	    -[]* replacement, the resulting str is appended in the
	    front of every -}* option starting from the 2nd one.
	    If none of -}* exist, the resulting str above is the
	    default output filename. e.g. option
	      -{}d: -}xx -fc:foo.txt -[.txt -].a
	    implies input from c:foo.txt and output to d:foo.axx
	    (cf. -{# -[* -]*)
     -~*    this is option version of entering offstrs: lines
	    that contain * will be removed from considerations.
	    This option is to allow "-<*" or "-;*" to be properly
	    entered.
	    (cf. -<* -;*)
     -.#    force the summation of such # as the exit code,
            overriding -x# and -$* options.
            (cf. -x# -$#)
     -:*    token string/lines as input, they are always the
	    first ones to be read in when present.
	    (cf. -c)
     -+#    cyclic mode of some operations.
	      0=dir read in recursively
	      1=output via -^* will be in append mode
	      2=last two parameters  specified by -p* or -P*
                will be duplicated infinitely.
              3=cyclically read files specified by -u* and -U*
            (cf. -f* -F* -p* -P* -u* -U*)
     -#?    input number placement mode, ?=the initial line
	    number. In this mode, if the character immediately
	    following any of -beBE is '#', then that position
	    is replaced by the current output line number plus
            the summation (initial value) of the numbers entered
	    via -#. Moreover, even number of options of -# type
            imply that the summation of the initial value with
	    the input line number will be used instead. This
	    likewise affects the exit code via -x20.
     -^*    first valid filename * will be sent the output. If
            none of the names specified by * is valid, the
            output is sent to stdout device.
	    -^//# replaces //# there by the #-th entry in the
	    environmental parameter LMFILES.
	    Since -h -v has priority over -^*, their output is
            always directed to stdout device.
            (cf. -f*, -+#)
     -/#    #=ASCII code of a character.  -/# provides a means
	    to enter any (non-zero) character into any string
	    parameter specified after a string option character.
	    Characters specified by -/# will be absorbed into
            the first encountered string parameter on the right.
            If there are -/# type characters between two string
	    parameters following a same string option character,
	    then these parameter strings will be linked up along
	    with the characters specified via -/# into a single
	    string parameter.
            e.g.
		    LM -/65/66/67dok -/68/69
	       is   LM -dABCokEF
		    LM -done -/0dtwo -fONE -fTWO
	       is   LM -donetwo -fONE -fTWO
     -!#    # number of lines will be accepted unconditionally
	    after any line that is accepted because it contains a
	    substring specified by a -g option
	    (cf. -g* -N# -o# -O#)
     -(*    strs to be inserted in front of each line marked by
	    -g*, thus changes the normal meaning of -g* and disables
	    -x21
	    (cf. -)* -g* -!# -x21)
     -)*    strs to be appended after each line marked by -g*
	    (cf. -(* -g* -!# -x21)
     -=#    (DOS only) set the 'proper' lines as environment
	    parameters. The output device that would be affected
	    under option -V (e.g. -BEbe) will thus not be
	    interpreted. When a line is interpreted as an
	    environment parameter, there must be an unique '='
	    in the line so that the left hand side is the name
	    and the right hand side is the parameter it will set
	    to. However, if "==" are the first two characters,
	    then all environment parameters will be deleted. If
	    '=' is the first character, then all the environment
	    parameters will be displayed unless there is a specific
	    parameter name following that leading '=' (and may be
	    terminated by another '=') in which case only that
	    specific environment parameter is to be displayed.
	    Otherwise the input line will be ignored. The ending
	    linebreaks will be ignored too. (old version: '-=#' 
	    will try to set the lines in the environmental blocks
	    belonging to upto #-th process).
	      0=set environment parameter of the ancestor's
		process (oldest parent), set only the valid
		environment parameters
	      1=0+set even invalid env parameters, if possible
     -&#    (DOS only) meaning of such options depend their
	    appearing order. The first to the last such options
	    are sequentially described below
	      timeout:  at which second to time out
			(positive timeout enables ^C for -$*)
		 beep:  which second to beep
	    countdown:  which second to display count down on
			the upper right corner of the screen
	      default:  default pressed key in ASCII for the
			timeout case under -$*
	     exitcode:  exitcode under ^C
	       column:  column the cursor will be moved to
			immediately moved to at the start
	    (7)   row:  row cursor to move to initially
	      clrline:  nonzero number clear the line from the
			current cursor to the end of line
	      delline:  delete the number of lines starting from
			the line containing the current cursor.
			Negative number deletes just one line
	      insline:  insert the number of empty line below
	       clrscr:  nonzero number clears current screen
	      scrmode:  0=do nothing. Nonzero number is the
			screen mode to set.
			e.g.  1= 40x25   at B800
			      2= 80x25   at B800
			      3= 80x50   at B800
			      7= 80x25   mono at B800
			 others= graphic modes
	    (cf. -$*)
     -$*    (DOS only) this option is available for DOS version
	    only. Input an instant key from keyboard immediately
	    after the completion of -B*. Then return accordingly
	    as the exitcode (unless overridden by -.#). The
	    strategy is controlled by the modes via -j20 to -j28.
	    Return the char position in $* if retchar (j24) is
	    not enabled (0=not found or escaped when escapemode
	    is on), otherwise return charcode of the last read
	    key. If * is empty, i.e. -$ stands alone, then it
	    will wait for just one any key, and exit with code 0
	    unless option -j24 is set. One may use this function
	    to find out the code number of any extended key.
	       case:   match will be case sensitive
	       echo:   echo the last read char unless escaped
		       when escapemode is on
	     escape:   escape key leaves input
	       beep:   beep at any illegal input char
	    retchar:   return last input char code
	    clrkeys:   clear keyboard buffer first
	       loop:   keep reading when waitmode is on until a
		       legal char is read in or escaped when
		       escapemode is on
	       wait:   wait to get chars if key buffer is empty
	   extended:   if this mode is on, then any character
		       in -$* following the char 0xFF (code 255)
		       will denote the corresponding extended
		       key. The char of code 255 itself will
		       thus be meaningless.
	    (cf. -&#, -j#)
     -**   only files matching name mask (2nd) * will be read in
	   (cf. -`* -F*)
     -`*   only files not matching * will be read in
	   (cf. -** -F*)
     -

   Environment
     If environment parameter LMFILES exists, then any of
	   -f//#   -^//#   -u//#   -U//#  "-<//#"
     is a shorthand notation: "//#" there will be replaced
     by the #-th entry in LMFILES. Entries of filenames in
     LMFILES are separated by ";" for DOS and by ":" for UNIX.

     TMPDIR is the preferred directory for temporary files.

   Examples
     1.  Keep 2nd to 3rd words and all those after the 5th one,
	 and convert everything into upper case
	      LM -s2S3s5t1

     2.  Throw away the lines that contain "ONE" and "two"
	      LM -J2 ONE two

     3.  Input lines first from stdin, then file foo.txt and
	 finally from stdin again
	      LM -f -ffoo.txt -f

     4.  Replace "help" to "HELP" and "keyword" to "_KEYWORD".
	 Disregard the case of "keyword". Do the str replacement
	 only if the lines contains "do:" at the beginning
	      LM -qhelp -rHELP -R_KEYWORD -Qkeyword -j9G10gdo:*
	 (or any other order)

     5.  Replace string "man" in foo.txt to highlight it in
	 the way UNIX man file requires
	      LM -qman -/95/8rm -/95/8ra -/95/8/rn <foo.txt

     6.  Pick all the files foo.* in subdirectory "dir"  (and
	 the lines inside) that contain the strings "seed??"
	 and "is" in a same line.
	 DOS:      LM -J1G11gseed?? -gis -Fdir\foo.*
	 UNIX:     LM -J1G11gseed\?\? -gis -Fdir/foo.\*

     7.  Pick out from foo.txt the lines between "-START-" and
	 "-END-" sequentially, regardless the letter case.
	      LM -M3+2p -p-start- -p-end- -ffoo.txt

     8.  Get a line of music in ANSI format from file tune.ans
	 into current input file foo.txt, so that the display
	 speed of the file is controlled/accompanied by the
	 music. e.g. add the music notes cyclically.
	      LM -ffoo.txt -+3Utune.ans

     9.  Format file foo.txt paragraph-wise to the width of 50
	 characters, do not break up long words
	      LM -atTYffoo.txt | LM -W1w50
	 or via direct temporary file
	      LM -atTYffoo.txt -^d:tmp -; -W1w50fd:tmp
	 or via environment parameter
	      set LMFILES=d:filename.tmp
	      LM -atTYffoo.txt -^//1 -; -W1w50f//1

    10.  Count the lines of file foo.txt
	      LM -##E# -G0g0 < foo.txt

    11.  Count the words (connected strings) of file foo.txt
	      set LMFILES=d:tmp1;d:tmp2;
	      LM -atT/32q -/10r -ffoo.txt -^//1 -;
		 -f//1 -y1^//2 -; -f//2 -##E# -G0g0^nul
	 (above two lines should be on a same line)

    12.  Get first two word columns from file foo and try
	 to align them at 0-th and 20-th character position
	      set LMFILES=c:\tmp\tmpfile
	      LM -Ts1S1^//1 -Ww20 -ffoo -; -Ts2S2u//1 -ffoo

    13.  Find the PATH of a file specimen (in DOS)
	 Thus
	      LM -c:c:\one\two\file.exe -nn1D\ -D:
	      LM -c:c:file.exe -nn1D\ -D:
	 gives respectively
	      c:\one\two\
              c:

    14.  Check if PATH contains c:\gscript  (in DOS)
	      path |LM -C2dpath= |LM -q; -/10r
	      |LM -Ty1e; -/10e |LM -x7G5gc:\gscript; >nul
	 (above two lines should be one a same line)
	 if errorlevel==2, then c:\gscript has been found.

    15.  List all the file numerically (in DOS 5)
	    dir /b /aa|LM -#b#=|LM -W2w18Y1|LM -W1w74t2

    16.  Get the 5th file of current directory (UNIX)
	      ls | LM -o5O5 | LM -x1
	 If exit error code is 2, then 5th file not found.

    17.  Find out if user "xyz" have currently logged on in UNIX
	      users |LM -mxyz |LM -x1 >/dev/null
	 If exitcode is 0, then "xyz" is logged on.

    18.  Get long command parameters such as these
	 (PsWD) <-- my password
	     "-cBDEMO for input command line parameters" -/10/10
	     "-cBLong command parameters may be given " -/10
	     "-cBin a file like this one, as a long line" -/10
	     "-cBor in a few lines!" -/10/10
	     "-cBWe may look for this file from e.g." -/10
	     "-c1Bthe place [" "-:] where we kept LM" -/10/10
	     -+t1F* -G5gjiang "-BSEARCH KEYWORD jiang :" -/10
	 (PsWD)
	 use e.g.
	     set LMFILES=d:\tmpfile.tmp
	     LM -p -pPsWD -pPsWD -flm.man -^//1 "-<//1"
	 Here we used this current file for the input of long
	 or multi-options.

    19.  Display the first 2 lines of all files of names LM*.C
	     LM -N-1N2+F\* -**\LM*.C

    20.  List all file names inside current directory and its
	 subdirectories, matching mask "*bc*.c"; return exitcode
	 2 if such files are found.
	     LM -N-1N+F -**bc*.c -X8x19

    21.  Increase environment parameter COUNT by -2 (in DOS
	 batch mode)
	     LM -c#-2#%COUNT% -ECOUNT= -E# | LM -=

    22.  Read from stdin and force input line width be no
	 more than 99 characters; pick out lines marked by
	 "+/" and throw aways lines with have same 2nd and
	 5th words as the previous line.
	     LM -j-99 -G10g+/* -y-2y-5
	 e.g.  an input of phone records
		+/  Jim 5/12/96  mobile  London
		+/  Jim 6/11/96  home Paris
		+/  Kay 30/11/96 office Sydney
	 will thus give last phone type and date for all
	 people at all different places
		+/  Jim 5/12/96  mobile  London
		+/  Kay 30/11/96 office Sydney

    23.  Rename all files in foo and its subdirs so that all
	 "abc" and extension ".c" in the filenames are
	 replaced by "xyz" and ".cpp" correspondingly, with
	 renaming messages suppressed
	     LM -{[.c -].cpp -[abc -]xyz -+Ffoo -X12

    24.  Update all files with extension ".doc" so that all
	 lines containing "mark??me" will be preceded by the
	 inserted line "+++" and followed by "---" likewise.
	 Set exitcode to 2 if at least one replacement is done
	     LM -x7{1F*.doc -gmark??me -(+++ -/10( -)--- -/10)

    25.  Process all files with extension ".c" in dir c:\foo and
	 its subdirs by replacing "ver1.21" to "ver1.22".
	 Save the results in dir d:newfoo and preserve subdir structure
	 with no confirmation asked for overwrite permission. e.g.
	     LM -+Fc:\foo -**.c -X13{-2{4}d:newfoo\ -}
		-qver1.21 -rver1.22
	 will process file c:\foo\tmp\x.c and save it as
	 d:newfoo\tmp\x.c, and creating subdir d:newfoo\tmp
	 if necessary without asking for confirmation
      .

   Author
     Zhuhan Jiang (zjiang@metz.une.edu.au)
     University of New England, Armidale NSW 2351, Australia

   Restrictions
     Lines of width over 2/3 of maximum integer may cause some
     manipulations unprecise of their definitions. In current
     version, options -Y and -w# are not fully compatible.
     Instead, LM should be run twice or via "-;" to achieve
     this task.
