{$a+,n-,x-,s-,i-,r-,b-,v-}


(* Note: the statements "input: text;", "assign(input,'con:');",
 *    and "reset(input);" appear below as comments; some version of
 *    Pascal require you to activate one or more of these statements.
 *
 *  Some versions of TURBO Pascal (e.g. PC versions >= 4) require
 *  splitting the following source into several "units".  The goo
 *  between pairs of !! lines gives a way to do this.  If you have
 *  this file on a UNIX system, you can simply pipe it through
 *         sed /!!/d | /bin/sh
 *  to create files mainvars.pas, unit1.pas, unit2.pas, and par.pas;
 *  the first 3 are "units" needed in the fourth.  If using a UNIX
 *  system is inconvenient, you can do the splitting by hand:
 *  omit the lines that contain !! (that's what "sed /!!/d" does)
 *  and put the lines between each "cat >..." and the following
 *  "//GO.SYSIN DD" line into the file named on these lines.
 *)


program paranoia(input,output);
uses mainvars, Unit1, Unit2;

   begin (*PARA*)
   start;
   mile2060;
   mile70170;

{=============================================}
   Milestone := 175;
{=============================================}
   writeln;
   for Index := 1 to 3 do
      begin
      case Index of
         1:
            Z := UnderflowThreshold;
         2:
            Z := E0;
         3:
            Z := PseudoZero;
         end;
      if Z <> 0 then
         begin
         V9 := sqrt (Z);
         Y := V9 * V9;
         if (Y / (One - Radix * E9) < Z)
               or (Y > (One + Radix * E9) * Z) then (* dgh: + E9 --> * E9 *)
            begin
            if V9 > U1 then
               begin
               NoErrors [SeriousDefect] := NoErrors [SeriousDefect] + 1;
               write ('SERIOUS DEFECT:');
               end
            else
               begin
               NoErrors [Defect] := NoErrors [Defect] + 1;
               write ('DEFECT:');
               end;
            writeln ('  Comparison alleges that what prints as Z = ', Z);
            writeln ('is too far from sqrt(Z) ^ 2 = ', Y);
            end;
         end;
      end;

{=============================================}
   Milestone := 180;
{=============================================}
      for Index := 1 to 2 do
         begin
         if Index = 1 then
            Z := V
         else
            Z := V0;
         V9 := sqrt (Z);
         X := (One - Radix * E9) * V9;
         V9 := V9 * X;
         if ((V9 < (One - Two * Radix * E9) * Z) or (V9 > Z)) then
            begin
            Y := V9;
            if X < W then
               begin
               NoErrors [SeriousDefect] := NoErrors [SeriousDefect] + 1;
               write ('SERIOUS ');
               end
            else
               NoErrors [Defect] := NoErrors [Defect] + 1;
            writeln ('DEFECT:  Comparison alleges that Z = ', Z);
            writeln ('is too far from sqrt(Z) ^ 2 is: ', Y);
            end;
         end;
{=============================================}
   Milestone := 190;
{=============================================}
   Pause;
   X := UnderflowThreshold * V;
   Y := Radix * Radix;
   if not ((X * Y >= One) and (X <= Y)) then
      begin
      if ((X * Y >= U1) and (X <= Y / U1)) then
         begin
         NoErrors [Flaw] := NoErrors [Flaw] + 1;
         write ('FLAW:');
         end
      else
         begin
         NoErrors [Defect] := NoErrors [Defect] + 1;
         write ('DEFECT: Badly');
         end;
      writeln (' unbalanced range; UnderflowThreshold * V = ');
      writeln (X, ' is too far from 1 .');
      end;
{=============================================}
   Milestone := 200;
{=============================================}
(*   for Index := 1 to 5 do
      begin
      X := F9;
      case Index of
         1:
            begin { Dummy Body }
            X := X;
            end;
         2:
            X := One + U2;
         3:
            X := V;
         4:
            X := UnderflowThreshold;
         5:
            X := Radix;
         end;
      Y := X;
      V9 := (Y / X - Half) - Half;
      if V9 <> 0 then
         begin
         if (V9 = - U1) and (Index < 5) then
            begin
            NoErrors [Flaw] := NoErrors [Flaw] + 1;
            write ('FLAW:');
            end
         else
            begin
            NoErrors [SeriousDefect] := NoErrors [SeriousDefect] + 1;
            write ('SERIOUS DEFECT:');
            end;
         writeln ('  X / X differs from 1 when X = ', X);
         writeln ('  instead, X / X - 1/2 - 1/2 = ', V9);
         writeln;
         end;
      end;*)
{=============================================}
   Milestone := 210;
{=============================================}
   MyZero := 0;
   writeln;
   writeln ('What message and/or values does Division by Zero produce?')
      ;
   writeln ('This can interupt your program. You can ',
         'skip this part if you wish.');
   writeln ('Do you wish to compute 1 / 0? ');
   readln (input);
   read (input, ch);
   if (ch = 'Y') or (ch = 'y') then
      writeln ('Trying to compute 1 / 0 produces: ', One / MyZero)
   else
      writeln ('O.K.');
   writeln ('Do you wish to compute 0 / 0?');
   readln (input);
   read (input, ch);
   if (ch = 'Y') or (ch = 'y') then
      writeln ('Trying to compute 0 / 0 produces: ', MyZero / MyZero)
   else
      writeln ('O.K.');
{=============================================}
   Milestone := 220;
{=============================================}
   Pause;
   writeln;
   if NoErrors[Failure] > 0 then begin
      write ('The number of  FAILUREs  encountered =        ');
      writeln (NoErrors [Failure]);
      end;
   if NoErrors[SeriousDefect] > 0 then begin
      write ('The number of  SERIOUS DEFECTs  encountered = ');
      writeln (NoErrors [SeriousDefect]);
      end;
   if NoErrors[Defect] > 0 then begin
      write ('The number of  DEFECTs  encountered =         ');
      writeln (NoErrors [Defect]);
      end;
   if NoErrors[Flaw] > 0 then begin
      write ('The number of  FLAWs  encountered =           ');
      writeln (NoErrors [Flaw]);
      end;
   if (NoErrors [Failure] + NoErrors [SeriousDefect] + NoErrors [Defect]
         + NoErrors [Flaw]) > 0 then
      begin
      writeln;
      if (NoErrors [Failure] + NoErrors [SeriousDefect] + NoErrors [
            Defect] = 0) and (NoErrors [Flaw] > 0) then
         begin
         write ('The arithmetic diagnosed seems ');
         writeln ('Satisfactory though flawed.');
         end;
      if (NoErrors [Failure] + NoErrors [SeriousDefect] = 0)
            and ( NoErrors [Defect] > 0) then
         begin
         writeln ('The arithmetic diagnosed may be Acceptable');
         writeln ('despite inconvenient Defects.');
         end;
         (* dgh: Defect --> SeriousDefect in next line *)
      if (NoErrors [Failure] + NoErrors [SeriousDefect] > 0) then
         begin
         write ('The arithmetic diagnosed has ');
         writeln ('unacceptable Serious Defects.');
         end;
      if (NoErrors [Failure] > 0) then
         writeln ('Potentially fatal FAILURE may have spoiled this',
                  ' program''s subsequent diagnoses.');
      end
   else
      begin
      writeln ('No failures, defects nor flaws have been discovered.');
      if not ((RMult = Rounded) and (RDiv = Rounded)
            and (RAddSub = Rounded) and (RSqrt = Rounded)) then
         writeln ('The arithmetic diagnosed seems Satisfactory.')
      else begin
        if (StickyBit >= One)
            and ((Radix - Two) * (Radix - Nine - One) = 0) then begin
         write ('Rounding appears to conform to ');
         write ('the proposed IEEE standard P');
         if (Radix = Two)
               and ((Precision - Four * Three * Two) * ( Precision -
               TwentySeven - TwentySeven + One) = Zero) then
            write ('754')
         else
            write ('854');
         if IEEE then writeln('.')
          else begin
            writeln(',');
            writeln ('except possibly for Double Rounding',
               ' during Gradual Underflow.');
            end;
         end;
        writeln ('The arithmetic diagnosed appears to be Excellent!')
        end;
      end;
   writeln ('END OF TEST.');
   end (* PARA *).
