(*****************************************************************************

  Program: Menu demonstration.

  Purpose:
    This program is designed to demonstrate the menu unit.

  Features:
    Demonstrates the bar menu and the status line option.
    Demonstrates the box menu using data from Menu.Dat.

  Limitations:
    The status line does not operate with Turbo Pascal version 4.0.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Menu_Demonstration( Input, Output );

  Uses
    CRT,
    Menu;

  Const
   { These attributes are defined for TextAttr. }
    Black_Background   = 0;
    Yellow_Background  = 96;
    White_Background   = 112;
    Black_Character    = 0;
    Yellow_Character   = 14;
    White_Character    = 15;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Alternative status line.
    This procedure is substituted for the default
    status line procedure so that the status line
    can be updated for each choice on the menu.

*************************************************)

 {$F+} { Make this procedure a far call model. }
  Procedure Alternative_Status_Line( Choice: Word );
    Var
      Command: Char;
    Begin
      GotoXY( 1, 25 );
      Write( 'Status line for choice ', Choice:1 );
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Read in.
    This function returns true if the file is
    completely read into the menu system.  If not,
    it returns false.

*************************************************)

  Function ReadIn( FileName: String; Var The_Menu: Box_Menu_Type ): Boolean;
    Var
      Okay: Boolean;
      Value: Integer;
      The_File: Text;
      The_String: String;
    Begin
      Value := 0;
      Okay := True;
      Assign( The_File, FileName );
      Reset( The_File );
      If ( IoResult = 0 )
        then
          Begin;
            While ( ( Not EOF( The_File ) ) and Okay ) do
              Begin;
                Inc( Value );
                Readln( The_File, The_String );
                Okay := Insert_Bottom_Box_Menu( The_Menu, The_String, Value );
              End;
            Close( The_File );
          End;
      ReadIn := Okay;
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Main program.
    Allocate and offer the bar menu.
    Allocate and offer the box menu.

*************************************************)

  Var
    Counter: Word;
    Flag: Boolean;
    The_Menu: Box_Menu_Type;
    Menu_line: Bar_Menu_Type;
    Point: Byte;
    Selection: Word;
    Data: String;
    Data2: Real;
    Data3: Integer;
    Data4: Boolean;
    Data5: LongInt;

  Begin
    DirectVideo := True;

    ClrScr;
    WriteLn( 'Menu unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program will demonstate the abilities of the Menu unit.  Two' );
    WriteLn( 'seperate menus will be offered to you to choose from, the first, being' );
    WriteLn( 'the bar menu while the second being the more familiar box type.' );
    WriteLn( 'Simply choose from the two menus to end the program.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

    ClrScr;
    Leave_Choice_On := False;
    Blend_Attribute := False;
    Selector_Color := Yellow_Character + Black_Background;
    Normal_Color := Black_Character + Yellow_Background;
    First_Character_Color := White_Character + Yellow_Background;
   {$IFNDEF VER40}
    Menu.Display_Status := Alternative_Status_Line;
   {$ENDIF}
    Initialize_Bar_Menu( Menu_Line, '    Choice 1  Choice 2  Choice 3  Choice 4  Choice 5  ' );
    Offer_Bar_Menu( Menu_Line, Point );
    WriteLn;
    WriteLn( 'You selected ', Point, '.' );
    WriteLn( 'Press enter to continue.' );
    ReadLn;

    ClrScr;
    Window( 10, 5, 70, 20 );
    HighLight_Letter := True;
    Initialize_Box_Menu( The_Menu );
    If ReadIn( 'Menu.Dat', The_Menu )
      then
        Offer_Box_Menu( The_Menu, Selection )
      else
        WriteLn( 'Error: Out of memory.' );
    ClrScr;
    WriteLn( 'You selected choice number ', Selection );
  End.

