(*****************************************************************************

  Program: Instructions per second.

  Purpose:
    This program is designed to calculate the amount of instructions the
    machine can execute per second.

  Features:
    Simple to use.

  Limitations:
    The accuracy ratio diminishes as the speed of the system increases due
    to the fact that the clock time is only so accurate while the time it
    takes to complete the cycle decreases.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal version 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program Instructions_Per_Second( Input, Output );

  Uses
    CRT,
    Time,
    String_Utilities;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Waste time.
    This routine, once it is called will generate
    approximately 164012007 various instructions.

*************************************************)

    Procedure Waste_Time;
      Var
        Data: Byte;
      Begin
        ASM
          { This loop repeats 4000 times, generating exactly 1 + 4000 * ( 41001 + 2 ) = 164012001 instructions }
          Mov BX, 4000
          @Middle_Loop:
          { This loop repeats 1000 times, generating exactly 1 + 1000 * 41 = 41001 instructions }
          Mov CX, 1000
          @Inner_Loop:
          AdC AX, BX
          Add AX, CX
          And AL, Data
          CBW
          AAM
          CMP AX, CX
          Mul CL
          IMul AH
          Or  AL,Data
          Mov Data,10
          IDiv Data
          AAS
          Push BX
          Pop AX
          Mov AX,$A1F0
          Div AL
          Not AX
          RCL Data,1
          AAD
          RCR AX,1
          ROL Data,1
          ROR AX,1
          SAL Data,1
          CLC
          JNC @Over
          @Under:
          Dec AX
          STC
          JC @Done
          @Over:
          Inc AX
          Jmp @Under
          @Done:
          AAA
          SAR AH,1
          SBB AX,1
          ShL Data,1
          ShR AX,1
          Neg AX
          Sub AX, CX
          Test AL,Data
          Xchg Data,AH
          XOr  AX,AX
          Loop @Inner_Loop
          { End of the loop }
          Dec BX
          JNZ @Middle_Loop
        End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main section
    This program starts by getting the time from
    the system.  Then it allows the computer to
    perform a set of instructions.  Then it gets
    the finishing time from the system and tries
    to calculate the approximate amount of
    instructions the machine can do per second.

*************************************************)

  Var
    The_Time: Real;
    Result: String;
  Begin
    ClrScr;
    WriteLn( 'Speed testing program for 80x86 processors' );
    WriteLn( ' Copyright 1994 by P. A. R. Renaud' );
    WriteLn;
    WriteLn( 'This program is designed to test the main processor''s speed by performing' );
    WriteLn( 'an exactly coded subroutine.  This subroutine is coded to generate exactly' );
    WriteLn( '164012007 machine language instructions.  Taking the system time before and' );
    WriteLn( 'after the subroutine, enables this program to roughly evaluate the speed of' );
    WriteLn( 'the processor in instructions per second.' );
    WriteLn;
    WriteLn( 'Due to the nature of operating systems, this program doesn''t take into account' );
    WriteLn( 'the periodic interrupts the system generates.  This allows a more accurate' );
    WriteLn( 'picture of the real working speed of the processor for application programs.' );
    WriteLn;
    WriteLn;
    Start_Timer;
    Waste_Time;
    The_Time := End_Timer - Accuracy_Adjustment;

    If ( The_Time > 0.0 )
      then
        Begin
          WriteLn( 'The testing of the main 80x86 processor required approximately', The_Time:8:2, ' seconds' );
          WriteLn( 'to complete the 164,012,007 instruction test.' );
          WriteLn;
          Str( ( 164012007 / The_Time ):12:0, Result );
          Comma_The_String( Result );
          WriteLn( 'The processor''s speed is roughly ', Result, ' instructions per second.' );
        End
      else
        Begin
          WriteLn( 'Error!  Timer value is invalid.' );
          WriteLn( 'Error!  System timer is invalid.' );
        End;
  End.
