{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Replace.pas              [x] Protected mode

  This program demonstrates tReplaceFilter which can replace data
  when it is written to some base stream. This class uses the KMP
  search algorithm defined in tSearchFilter.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

uses EFDEF, EFSTREAM, EFFILE, EFSEARCH;


var InF      : pIFile;
    OutF     : pSearchFilter;
    T, R     : string;
    I        : word;


begin
     if (ParamStr(1) = '') or (ParamStr(2) = '')
        then begin
             WriteLn ('Syntax: REPLACE <file1> <file2> <text1> <text2>');
             WriteLn ('  Searches for a word in <file1> and replaces the word');
             WriteLn ('  whenever it is found. Result is written to <file2>.');
             WriteLn ('  The word <text1> is replaced with <text2>.');
             Halt;
             end;

     T := ParamStr(3);
     R := ParamStr(4);

     InF  := New (pIFile, Initialize (ParamStr(1), 1024) );
     OutF := New (pReplaceFilter, Initialize (T[1], Length(T),
             R[1], Length(R), New (pOFile, Initialize (ParamStr(2), 1024))));

     InF^.CopyOut (OutF, InF^.Size);

     WriteLn ('Text repladced ', OutF^.Occurrences, ' times.');

     InF^.Free; OutF^.Free;
end.