{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/CRC32.pas                [x] Protected mode

  An example on how you generate CRC32 validation code for data.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFSTREAM, EFFILTER, EFSTRING;


const CRCBuffer = 4096;

var CRC  : pCRC32Filter;
    Null : pNullStream;

{ ParamStr(1) must contain a filename }

begin
     { This program uses a CRC filter to calculate Z-MODEM, PKZIP
       and ARJ style CRC32 validation codes. }

     if ParamStr(1) = '' then begin
        WriteLn ('No file specified!'); Halt (1); end;

     { Initialize CRC filter with a file stream as base }
     CRC := New ( pCRC32Filter,
                  Initialize ( New ( pFileStream,
                                     { Base stream }
                               Initialize (ParamStr(1), CRCBuffer))   )    );
                                         { Filename } { Buffer size }


     New (Null, Initialize);

     CRC^.MoveOut (Null, CRC^.Size);

     { Use $DEFINE CRCTABLES for faster but more memory consuming
       CRC calculations. }

     WriteLn ('The CRC32 is ', Copy (StringHexNumber(CRC^.Result), 1, 255), 'h.');

     CRC^.Free; { Dispose filter including base stream }
     Null^.Free; { Dispose the null stream }
end.