{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Extend/Elemext1.pas              [x] Protected mode

  This program demonstrates how you can override methods in tElement
  and hence create new elements for your data structures.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFDEF, EFELEM, EFLIST, EFKERNEL, EFSTRING;


type pMyElement = ^tMyElement;
     tMyElement = object (tElement)

       { Element for real numbers. In this case, we have to
         override the compare method since real numbers are stored
         in a strange way (we cannot use bitwise comparison here -
         if we could, we would not have to override the compare
         method). Data and Size must always be overridden. }

       public

         constructor Initialize (Number : real); {*}

         procedure   Update (var nData; nSize : word); virtual; {*}
         procedure   Retrieve (var nData); virtual; {*}

         function    Compare (What : pElement) : shortint;
                     virtual;
         procedure   StreamWrite (Stream : pStream); virtual;

         function    Data (Position : word) : pointer; virtual; {*}
         function    Size : word; virtual; {*}

       private

         fReal : real;

     end;


     tMyList = object (tOrderedList)

       { This list make use of the new element. We override
         the create element method to provide a flexible
         interface (all methods, including Store and Retrieve,
         will now use tMyElement). }

         constructor Initialize;
         function    CreateElement : pElement; virtual;

     end;


constructor tMyElement.Initialize (Number : real);
begin
     Inherited Initialize;
     fReal := Number;
end;

procedure tMyElement.Update (var nData; nSize : word);
begin
     Assert ( nSize = SizeOf(Real), Error_Compatibility );
     Move ( nData, fReal, SizeOf(Real) );
end;

procedure tMyElement.Retrieve (var nData);
begin
     Move ( fReal, nData, SizeOf(Real) );
end;

function tMyElement.Compare (What : pElement) : shortint;
begin
     Assert ( IsEqualType (What), Error_Compatibility );

     if fReal > pMyElement(What)^.fReal then Compare := 1
        else if fReal < pMyElement(What)^.fReal then Compare := -1
                else Compare := 0; { Equal }
end;

procedure tMyElement.StreamWrite (Stream : pStream);
begin
     Assert ( IsValidStream (Stream), Error_Resource );
     Stream^.PutLine ( StringNumber ( fReal, 4, 2 ) );
end;

function tMyElement.Data (Position : word) : pointer;
begin
     Data := Ptr (Seg(fReal), Ofs(fReal) + Position);
end;

function tMyElement.Size : word;
begin
     Size := SizeOf(fReal);
end;


constructor tMyList.Initialize;
begin
     Inherited Initialize (SizeOf(real));
end;

function tMyList.CreateElement : pElement;
begin
     CreateElement := New (pMyElement, Initialize (0));
end;


var Numbers : tMyList; Number : real; Index : word;
begin
     WriteLn ('* My ADT uses my own element! *');

     { We must register the element to permit type compatibility
       checks (safety). You can also register the extended list
       class (tMyList). Register you classes with identities
       >= 1000, EFLIB reserves all other numbers. (Try 1 and see
       what EFLIB says!) }
     Classes^.Register ( 1000, 'tMyElement', TypeOf(tMyElement), TypeOf(tElement), NIL, NIL );

     with Numbers do begin

          Initialize;

          { Add some elements to the new data type }
          Number := Pi;     Store (Number);
          Number := 1.414;  Store (Number);
          Number := 5;      Store (Number);

          { Check the result }
          Number := 0; Retrieve (Number, 1);
          WriteLn ('List contains ', Elements,
                 ' elements. The first is ', Number:0:5, '.');

          WriteLn ('It is ordered! We have defined the relation between numbers');
          Write ('in the compare method: ');

          for Index := 1 to Elements do begin
              Retrieve (Number, Index);
              Write (Number:3:2, ' ');
          end;

          WriteLn; WriteLn;

          { Do not forget to intercept your list. }
          Intercept;
     end;
end.