/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* howard.h  -  Howard Kapustein's basic header file */

/*  Note: for many functions the type 'byte' is defined as 'unsigned char'
          in the evironment menu as #define cannot do it. Other such defines
          are:
                #define byte        unsigned char
                #define word        unsigned int
                #define bboolean    unsigned int    /* used for bit fields */

    See TCHK.DOC for futher details.                                        */

#ifndef HOWARD_HEADER
#define HOWARD_HEADER   1

#define FALSE       0
#define TRUE        (!FALSE)
#define boolean     char
#define EQU(b1,b2)  (((b1)&&(b2)) || ((!b1)&&(!b2)))    /* boolean equal */
#define NEQ(b1,b2)  (((b1)&&(!b2)) || ((!b1)&&(b2)))    /* boolean not equal */
#define BINV(b1)    (b1 ? FALSE : TRUE)                 /* boolean invert (return opposite) */

#define NONE        0               /* text justification */
#define LEFT        1
#define CENTER      2
#define RIGHT       3

#define OFF     0
#define ON      1

#define _TCmajor    ((__TURBOC__&0xFF00)>>8)        /* Turbo C major version number */
#define _TCminor    ((__TURBOC__&0x00FF)>>4)        /* Turbo C minor version number */

#endif              /* HOWARD_HEADER */
