/* simpwin9 copyright 1995 - 1997 by bruce r. o'banion */

# include <stdio.h>
# include <string.h>
# include <dos.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <alloc.h>

# include "mouse92.h"

int mou_installed = 0;
unsigned int old_mov_x;
unsigned int old_mov_y;


void mouinterrupt(int mou_ax,int mou_bx,int mou_cx,int mou_dx)
{
	asm  mov ax,mou_ax;
	asm mov bx,mou_bx;
	asm mov cx,mou_cx;
	asm mov dx,mou_dx;
	asm int 0x33;
}


int mouinstalled(void)
{
	int rows,cols;

	if(mou_get_adapter() == 0)
	{

		return(-1);
	}
	mouinterrupt(0,0,0,0);
	asm mov mou_installed,bx;
	if(_AX == 0)
	{
		mou_installed = 0;
	}
	else
	{
		if(mou_get_mode(&rows,&cols) == -1)
		{

			return(-1);
		}
	}
	mousetmaxposition(1,cols,1,rows);
	old_mov_x = -1;
	old_mov_y = -1;
	return(mou_installed);
}

void moureset(void)
{
	mouinterrupt(0,0,0,0);
}

int moubuttonpressed(int button)
{

	int code;

	if(mou_installed)
	{
		mouinterrupt(0x0005,button,0,0);
		asm mov code,bx;
		return(code);
	}
	return(0);
}


void mouhide(void)
{
	if(mou_installed)
	{
		mouinterrupt(0x02,0,0,0);
	}
}


void moushow(void)
{
	if(mou_installed)
	{
		mouinterrupt(0x01,0,0,0);
	}
}

void mousetposition(int x,int y)
{
	if(mou_installed)
	{
		mouinterrupt(0x04,0x00,(x - 1) * 8,(y - 1) * 8);
	}
}


int mouposition(int *x,int *y)
{
	int mov_x,mov_y;

	if(mou_installed)
	{
		mouinterrupt(0x03,0,0,0);
		asm mov mov_x,cx;
		asm mov mov_y,dx;
		*x = (mov_x / 8) + 1;
		*y = (mov_y / 8) + 1;
		if((old_mov_x != mov_x) | (old_mov_y != mov_y))
		{
			old_mov_x = mov_x;
			old_mov_y = mov_y;
			return(1);
		}
		else
		{
			return(0);
		}
	}
	return(0);
}

int mousetmaxposition(int minx,int maxx,int miny,int maxy)
{
	mouinterrupt(0x0007,0x0000,(minx - 1) * 8,(maxx - 1) * 8);
	mouinterrupt(0x0008,0x0000,(miny - 1) * 8,(maxy - 1) * 8);
	return(0);
}

int moubuttonrelease(int button)
{
	int code;

	if(mou_installed)
	{
		mouinterrupt(0x06,button,0x00,0x00);
		code = _BX;
		return(code);
	}
	return(0);
}

int mou_get_adapter(void)
{
	char *adapt_buff;

	if((adapt_buff = (char*)malloc(64)) == NULL)
	{

		return(0);
	}
	asm push es;
	asm  mov ax,ds;
	asm mov es,ax;
	asm mov ax,adapt_buff;
	asm push di;
	asm mov di,ax;
	asm mov bx,0x00;
	asm mov ah,0x1b;
	asm int 0x10;
	asm pop di;
	asm pop es;
	if(_AL == 0x1b)
	{

		free(adapt_buff);
		return(9);
	}
	if(peek(0x0000,0x0487))
	{
		free(adapt_buff);
		return(3);
	}
	free(adapt_buff);
	return(0);
}

int mou_get_mode(int *rows,int *cols)
{
	int mode;

	asm push bp;
	asm push es;
	asm mov ah,0x11;
	asm mov al,0x30;
	asm mov bh,0x03;
	asm int 0x10;
	asm pop es;
	asm pop bp;
	*rows = _DL + 1;
	asm mov ah,0x0f;
	asm int 0x10;
	asm push ax;
	*cols = _AH;
	asm pop ax;
	mode = _AL;
	if((mode == 3) & (*rows > 25))
	{
		mode = 64;
	}
	switch(mode)
	{
		case 3 :
		case 64 :
		case 84 :
		case 85 : break;
		default : mode = -1;
	}
	return(mode);
}

void moucursortype(unsigned int type)
{
	if(mou_installed)
	{
		if(type == 0)
		{
			mouinterrupt(0x000a,0x0000,0xffff,0x3300);
		}
		else
		{
			mouinterrupt(0x000a,0x0000,0xff00,type);
		}
	}
}



