/*
 * Header file for Tag Image File Format (TIFF) routines.
 */

#ifndef _TIFF_H

#define _TIFF_H

/* TIFF data types */

typedef char BYTE;
typedef char ASCII;
typedef short SHORT;
typedef long LONG;
struct rational
{
	LONG numerator;
	LONG denominator;
};
typedef struct rational RATIONAL;

/* other data types */
typedef char far * LONGPTR;
typedef int BOOL;
struct tiff_header
{
	SHORT byte_order;
	SHORT version;
	LONG dir_offset;
};
typedef struct tiff_header TIFF_HEADER;

#define TIFF_HEADER_SIZE sizeof(TIFF_HEADER)

struct tiff_dir_entry
{
	SHORT tag;
	SHORT type;
	LONG length;
	LONG value_offset;
};
typedef struct tiff_dir_entry TIFF_DIR_ENTRY;

#define TIFF_DIR_ENTRY_SIZE sizeof(TIFF_DIR_ENTRY)

struct field_info
{
	SHORT num_tags;
	LONG num_bytes;
};
typedef struct field_info FIELD_INFO;

#define FIELD_INFO_SIZE sizeof(FIELD_INFO)

/* constants */
#define TRUE		1
#define FALSE		0
#define INTEL		0x4949
#define MOTOROLA	0x4d4d
#define BYTE_SIZE	sizeof(BYTE)
#define ASCII_SIZE	sizeof(ASCII)
#define SHORT_SIZE	sizeof(SHORT)
#define LONG_SIZE	sizeof(LONG)
#define RATIONAL_SIZE	sizeof(RATIONAL)
#define ERROR_VALUE	0
#define DIRECT_VALUE	1
#define INDIRECT_VALUE	2

/* tags */
#define SUBFILE_TYPE_TAG	0x00ff
#define IMAGE_WIDTH_TAG		0x0100
#define IMAGE_LENGTH_TAG	0x0101
#define BITS_PER_SAMPLE_TAG	0x0102
#define COMPRESSION_TAG		0x0103

#define PHOTOMETRIC_INTERP_TAG	0x0106
#define THRESHOLDING_TAG	0x0107
#define CELL_WIDTH_TAG		0x0108
#define CELL_LENGTH_TAG		0x0109
#define FILL_ORDER_TAG		0x010a

#define DOCUMENT_NAME_TAG	0x010d
#define IMAGE_DESCRIPTION_TAG	0x010e
#define MAKE_TAG		0x010f
#define MODEL_TAG		0x0110
#define STRIP_OFFSETS_TAG	0x0111
#define ORIENTATION_TAG		0x0112
#define SAMPLES_PER_PIXEL_TAG	0x0115
#define ROWS_PER_STRIP_TAG	0x0116
#define STRIP_BYTE_COUNTS_TAG	0x0117
#define MIN_SAMPLE_VALUE_TAG	0x0118
#define MAX_SAMPLE_VALUE_TAG	0x0119
#define X_RESOLUTION_TAG	0x011a
#define Y_RESOLUTION_TAG	0x011b
#define PLANAR_CONFIG_TAG	0x011c
#define PAGE_NAME_TAG		0x011d
#define X_POSITION_TAG		0x011e
#define Y_POSITION_TAG		0x011f
#define FREE_OFFSETS_TAG	0x0120
#define FREE_BYTE_COUNTS_TAG	0x0121

/*
 * Legal compression types.  See the description of the "Compression" tag
 * in the "Tag Image File Format" abstract, Aldus Corporation, 8/5/86 or
 * later.
 */
#define PACK_TIGHTLY		1
#define ONE_D_MOD_HUFFMAN	2

/*
 * Answer to the question of the meaning of life and arbitrarily-chosen
 * version number.
 */
#define LEGAL_VERSION	42

/* macros */
#define HIBYTE(X)	((BYTE)(((SHORT)(X)) >> 8))
#define LOBYTE(X)	((BYTE)(((SHORT)(X)) & 0xff))
#define HIWORD(X)	((SHORT)(((LONG)(X)) >> 16))
#define LOWORD(X)	((SHORT)(((LONG)(X)) & 0xffff))
#define ELEMENTS(X)	(sizeof(X)/sizeof((X)[0]))

#endif /* _TIFF_H */
