{$M 4000,0,655360}

program prob;

uses
  pax_u,xap_u,
  Dos, TpCrt, TpDos, TpString, TpEntry, TpWindow, TpTSR, Tp8087;

const
  progname : string[16] = 'PROB version 2.0';
  hotkey : word = $0619;  { Ctrl-Leftshift-P }

const
  start_up_instruction = '  Press Ctrl-Leftshift-P to activate.';

type
  disttype = (Chisq, Fdist, Tdist, Normal);

var
  regs : registers;
  d : byte;
  distno : disttype;
  ctype, ifault :integer;
  value,evalue,df1,df2 : double;
  p,x : double;
  ESR : ESrecord;
  ExitCommand : ESType;
  w : windowptr;
  fileoutput : boolean;
  stderr : text;

const
  distfld = 0;
  df1fld = 1;
  df2fld = 2;
  xfld = 3;
  pfld = 4;


const
  distname : array[disttype] of string[9] =
    ('Chisquare','F Dist','T Dist','Normal');

procedure writeline;
begin
  writeln(pad(distname[distno],10),df1:8:2,df2:8:2,x:9:5,p:9:6,ifault:8);
end;

procedure Synchronize_entry_window;
begin
  with WindowP(w)^ do
    SetEntryWindow(ESR,xl,yl,xh,yh,false,$07,0);
end;

{$F+}
procedure NextDist(var value; id : byte; factor : integer; var s: string);
var
  distno : disttype absolute value;

begin
  case factor of
   +1 : if distno<Normal then
          inc(distno)
        else
          distno := Chisq;
   -1 : if distno>Chisq then
          dec(distno)
        else
          distno := Normal;
  end;
  s := distname[distno];
end;

procedure UpdateHandler(var ESR : ESrecord);
const
  calc_x : boolean = false;

procedure show(field:byte;onoff:boolean);
var
  f : fieldrecptr;

begin
  f := FindFieldId(ESR, field);
  with f^ do
    if onoff = on then
    begin
      ChangeProtection(ESR,field,off);
      FieldAttr := $70;
    end
    else
    begin
      ChangeProtection(ESR,field,on);
      FieldAttr := 0;
    end;
  DrawField(ESR,field);
end;

begin
  case LastEntryCommand of
   ESuser1:
      if movewindow(0,-1) then
        synchronize_entry_window;
   ESuser2:
      if movewindow(0,1) then
        synchronize_entry_window;
   ESuser3:
      if movewindow(-1,0) then
        synchronize_entry_window;
   ESuser4:
      if movewindow(1,0) then
        synchronize_entry_window;
   ESuser5:
      begin
        close(output);
        if not DisableTSR then
          fastwritewindow('Can''t unload!',7,1,7)
        else
          LastEntryCommand := ESdone;
        end;
   else
   begin
     case ESR.currentID of
     distfld:  {distno}
         case distno of
         Chisq : begin
                   show(df1fld, on);
                   show(df2fld, off);
                 end;
         Fdist : begin
                   show(df1fld, on);
                   show(df2fld, on);
                 end;
         Tdist : begin
                   show(df1fld, on);
                   show(df2fld, off);
                 end;
         Normal :begin
                   show(df1fld, off);
                   show(df2fld, off);
                 end;
         end;

     xfld: calc_x := false;
     pfld: calc_x := true;
     end;

     if calc_x then
     begin
       x := pax(byte(distno)+1,ifault,1.0-p,df1,df2);
       drawfield(ESR, xfld);
     end
     else
     begin
       p := 1.0-xap(byte(distno)+1,ifault,x,df1,df2);
       drawfield(ESR, pfld);
     end;
     if (error8087 and $0D) <> 0 then
       fastwritewindow  ('8087 error!   ',6,1,7)
     else
       fastwritewindow  ('              ',6,1,7);
     case ifault of
     0 : fastwritewindow('              ',7,1,7);
     1 : fastwritewindow('Illegal d.f.  ',7,1,7);
     2 : if calc_x then
           fastwritewindow('Illegal P     ',7,1,7)
         else
           fastwritewindow('Illegal X     ',7,1,7);
     else
         fastwritewindow('Unknown error!',7,1,7);
     end;
   end;
  end;

  if fileoutput and (LastEntryCommand = ESuser0) then
  begin
    writeline;
    if not Textflush(output) then;
  end;

  if LastEntryCommand in [ESuser0..ESuser5] then
    LastEntryCommand := ESnone;
end;

procedure Popup(var Regs: registers);
var
  Save8087Regs : SaveBuffer8087;
begin
  PopupsOff;
  Save8087(Save8087Regs);
  if DisplayWindow(w) then
  begin
    Synchronize_Entry_Window;
    repeat until editscreen(esr, ESR.currentID, false) in [ESdone, ESquit];
    w:=EraseTopWindow;
  end;
  Restore8087(Save8087Regs);
  PopupsOn;
end;
{$F-}

begin
  Exceptions8087(off);
  if not OpenStdDev(Stderr,2) then;  { Can't fail }
  if (not HandleIsConsole(StdoutHandle)) or (not HandleIsConsole(StdinHandle))
  then
  begin
    assign(output,'');
    rewrite(output);
    writeln('Distn         DF1     DF2     X        P        Ifault');
    fileoutput := true;
  end
  else
    fileoutput := false;
  if HandleIsConsole(StdinHandle) then
  begin
    distno := Normal;
    p := 0.5;
    x := 0.0;
    df1 := 1.0;
    df2 := 1.0;

    if not AddEntryCommand(ESuser0,1,$0D,0) then;
    if not AddEntryCommand(ESuser1,1,$8400,0) then;  { ^PgUp }
    if not AddEntryCommand(ESuser1,1,$8D00,0) then;  { ^Up (enhanced) }
    if not AddEntryCommand(ESuser2,1,$7600,0) then;  { ^PgDn }
    if not AddEntryCommand(ESuser2,1,$9100,0) then;  { ^Down (enhanced) }
    if not AddEntryCommand(ESuser3,1,$7300,0) then;  { ^Left }
    if not AddEntryCommand(ESuser4,1,$7400,0) then;  { ^Right }
    if not AddEntryCommand(ESdone ,1,$2D00,0) then;  { Alt-X }
    if not AddEntryCommand(ESdone ,1,$011B,0) then;  { Escape }

    InitESrecord(ESR);
    if not MakeWindow(w,
                      10,10,
                      35,18,
                      true,   {drawframe}
                      true,   {clearwindow}
                      true,   {savewindow}
                      $7,$7,$7,
                      progname) then
                      halt;
    SetPromptAttr($0F);
    SetFieldAttr($70);
    SetStringAttr($70);
    SetCtrlAttr($70);
    SetPostEditPtr(ESR, @updatehandler);
    SetWrapMode(ESR, WrapAtEdges);
    SetAutoAdvance(off);
    InsertMode := false;
    AddChoiceField(ESR,
                   'Distribution: ',
                   1,1,
                   'XXXXXXXXX',
                   1,15,
                   0,
                   1,
                   @NextDist,
                   distno);
    SetProtection(on);
    SetFieldAttr(0);
    AddDblField  (ESR,
                   'D.F. 1:',
                   2,1,
                   '#########',
                   2,15,
                   1,
                   0.0,1.e30,
                   4,
                   df1);
    AddDblField  (ESR,
                   'D.F. 2:',
                   3,1,
                   '#########',
                   3,15,
                   2,
                   0.0,1.e30,
                   4,
                   df2);
    SetProtection(off);
    SetFieldAttr($70);
    AddDblField  (ESR,
                   'X:',
                   4,1,
                   '#########',
                   4,15,
                   3,
                   0.0,0.0,
                   7,
                   x);
    AddDblField  (ESR,
                   'Pr(larger):',
                   5,1,
                   '#########',
                   5,15,
                   4,
                   0.0,1.0,
                   7,
                   p);
    ESR.currentID := xfld;

    if StUpCase(paramstr(1)) = '/R' then
    begin
      if not ModuleInstalled(progname) then
      begin
        if DefinePop(Hotkey, @Popup, ptr(sseg,sptr), true) then
        begin
          writeln(stderr,progname,' going resident.',start_up_instruction);
          InstallModule(progname,nil);
          if not AddEntryCommand(ESuser5,1,$2D00,0) then;  { Alt-X }
          PopupsOn;
          if not TerminateAndStayResident(ParagraphsToKeep+100,0) then
          begin
            writeln(stderr,'U','nable to stay resident!');
            UninstallModule;
          end;
        end
        else
          writeln(stderr,progname,' u','nable to stay resident!');
      end
      else
      begin
        writeln(stderr,progname,' already resident.',start_up_instruction);
        halt;
      end;
    end;
    popup(regs);
  end
  else
  begin
    assign(input,'');
    reset(input);
    repeat
         readln(d, ctype, x, df1, df2);
         if (d = 0) then
              halt;
         distno := disttype(d-1);
         if (ctype = 2) then
         begin
              p := x;
              x := pax(d,ifault,1.0-p,df1,df2);
         end
         else if (ctype = 1) then
              p := 1.0-xap(d,ifault,x,df1,df2)
         else
              ifault := 3;

         writeline;

         if ifault <> 0 then
         begin
           writeln(stderr,'Distno 0=stop 1=Chi Squared 2=F 3=T 4=Normal');
           writeln(stderr,'Type X->P=1  P->X=2');
           writeln(stderr,'Enter Distno, Type, Value, df1, df2');
           if (ifault = 1) then
              writeln(stderr,'Illegal degrees of freedom')
           else if (ifault = 2) then
              writeln(stderr,'Illegal input value')
           else if (ifault = 3) then
              writeln(stderr,'Distno must be 1, 2, 3, or 4 and Type must be 1 or 2')
           else
              writeln(stderr,'Unknown error!');
         end;
    until false;
  end;
end.
