unit gamain_u;
interface
  uses acrcy;

  function gamain(x,p,g:double;var ifault:integer):double;

implementation

      function gamain(x,p,g:double;var ifault:integer):double;
{
c        algorithm as 32 appl stats  vol 19  (1970) no 3 pp 286-287
c
c        computes incomplete gamma ratio for positive values of
c         arguments x and p.  g must be supplied and should be equal to
c        ln(gamma(p)).
c        ifault = 1 if p.le.0 else 2 if x.lt.0 else 0.
c        uses series expansion if p.gt.x or x.le.1 otherwise a
c        continued fraction approximation.
}
var
   pn : array[1..6] of double;
   oflo,
   gin,
   factor,
   term,
   an,rn,
   a,b,
   dif
     : double;
   i : integer;
label
  label42;
begin
      oflo := 1.0e30;
      gin := 0.0;
      gamain := gin;
      ifault := 0;
{
c        test for admissibility of arguments.
}
      if(p<=0.0) then
        ifault := 1;
      if(x<0.0) then
        ifault := 2;
      if(ifault>0) then
        exit;
      if(x=0.0) then
        exit;
   {10} factor := exp(p*ln(x)-x-g);
      if not ((x>1.0) and (x>=p)) then
      begin
{
c        calculation by series expansion.
}
        gin := 1.0;
        term := 1.0;
        rn := p;
        repeat
     {20} rn := rn + 1.0;
          term := term * x / rn;
          gin := gin + term;
        until (term <= acu);
        gin := gin * factor / p;
      end
      else
      begin
{
c        calculation by continued fraction.
}
  { 30} a := 1.0 - p;
        b := a + x + 1.0;
        term := 0.0;
        pn[1] := 1.0;
        pn[2] := x;
        pn[3] := x + 1.0;
        pn[4] := x*b;
        gin := pn[3] / pn[4];
        repeat
      { 32} a := a + 1.0;
          b := b + 2.0;
          term := term + 1.0;
          an := a * term;
          for i := 1 to 2 do
        { 33} pn[i+4] := b*pn[i+2]-an*pn[i];
          if(pn[6] <> 0) then {31,35,31}
          begin
        { 31} rn := pn[5] / pn[6];
            dif := abs(gin - rn);
            if(dif<=acu) and (dif<=acu*rn) then
              goto label42;
       {34} gin := rn
          end;
       {35} for i := 1 to 4 do
              pn[i] := pn[i+2];
          if (abs(pn[5])>=oflo) then
            for i := 1 to 4 do
              pn[i] := pn[i]/oflo;
        until false;

        label42:
        gin := 1.0 - factor*gin;

      end;
   {50} gamain := gin;
end;

end.
