//----------------------------------------------------------------------
// Michael Finnegan
// Last update: 18 Feb 2000
//
// This is the second half of the Parse class.
// see the readme.txt file for info.
//----------------------------------------------------------------------
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <mem.h>
#include <dos.h>
#include <conio.h>
#include <time.h>
#include "parse.h"
#include "labels.h"

//------------------------------------------------------------------------
// compute the Internal Rate of Return of a stream of cash out-flows
// and in-flows.
// There is no mathematical formula for determining the Internal Rate of
// Return, it can only be calculated by taking a series of guesses
// using the Net Present Value function an an initial
// estimated interest rate.  (This is the normal way spreadsheet
//  programs figure it out). Then the interest rate in successively
// increased or decresed until it homes in on a target NPV of 0.0
// or within -+0.0001 or until 60 times looping.
// The interest rate that results in 0.0 for those cash flows is then returned
// as the Return on Investment interest rate.
// The result is a percentage. ie., it return 9% as 0.09

// Syntax:
//  =@Irr(B1, D9:G9)
// b1 = the estimated discount interest rate ie., 9% is .09
// D9:G9 is the range of cash flow payments out and in
void Parse::Irr(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	double factor, app, i, stp, r, result, lastopr;
	Answer rate;


	get_token();
	if(!*token == '(') {serror(1); return;}
	get_token();
	eval_exp2(&rate);
	if(errnum) return;
	if(rate.type != 2) {serror(1); return;}
	r = rate.numeric;
	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count = 0;    //loop counter
	app = 0.0L ; //app = the target



	stp = 1;
	lastopr = 1;  //last operation on stp: -1 = smaller, +1 = bigger

		factor = .01L;
top:
		count++;
		if(count>1)
			r = r + lastopr*factor;

		i = r;
		if(count>500) {serror(10); return;}    //number out of range


		result = Npv1(i+1, x1, y1, x2, y2);

		//round payment
		if((result >= (-0.01)) &&  (result <= (0.01L))) goto found;


		if(result <  0.0L)
		{

			if(lastopr == 1)
			{
				factor = factor /2;
				lastopr = -1;
				goto top;
			}

			factor = factor * 2;
			lastopr = -1;
			goto top;
		}

		if( result > 0.0L)
		{
			 if(lastopr == -1)
			 {
				 //factor = factor /2;
				 lastopr = 1;

				 goto top;
			 }
			 factor = factor *2;
			 lastopr = 1;

			 goto top;
		}


found:
	answer->numeric = r;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;

}
//------------------------------------------------------------------------
//Get the present value of an ordinary annuity
// syntax = @Pv(pmt, interest rate, terms)
void Parse::Pv(Answer *answer)
{
	double x, y, i;

	Answer pmt, interest, terms;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&pmt, &interest, &terms);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	i = pmt.type + interest.type + terms.type;
	if(i != 6) { serror(5); return;}  //type mysmatch

	x = 1+ interest.numeric;
	y = -terms.numeric;
	if(interest.numeric == 0.0L){serror(10); return;}
	answer->numeric = (pmt.numeric * (1 - pow(x, y)))/interest.numeric;


	answer->type = 2;


}
//-------------------------------------------------------------------------
//Get the future value of an ordinary annuity
void Parse::Fv(Answer *answer)
{
	double x, y, i;

	Answer pmt, interest, terms;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&pmt, &interest, &terms);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	i = pmt.type + interest.type + terms.type;
	if(i != 6) { serror(5); return;}  //type mysmatch

	x = 1+ interest.numeric;
	y = terms.numeric;
	if(interest.numeric == 0.0L){ serror(10); return;}
	answer->numeric = pmt.numeric * (pow(x, y)-1)/interest.numeric;


	answer->type = 2;


}
//-------------------------------------------------------------------------
// Calculate the number of periods required to accumulate a specified
// future value by making equal payments into an interest bearing account at
// the end of each period.
//	Syntax: @Term(pmt, interest, future value)
// interest should be expressed as ie., 0.09 for 9%

void Parse::Term(Answer *answer)
{
	double x, y, i;

	Answer pmt, interest, fv;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&pmt, &interest, &fv);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	i = pmt.type + interest.type + fv.type;
	if(i != 6) { serror(5); return;}  //type mysmatch
	i = interest.numeric;
	if(pmt.numeric == 0.0L) { serror(10); return;}
	answer->numeric = log(1+(i*fv.numeric /pmt.numeric)) / log(1+i);

	answer->type = 2;

}
//-------------------------------------------------------------------------
// Calculate the number of periods required for an initial
// investment earning a specified interest rate to grow to a
// specified future value. Whereas @Term calculates the number of
// periods needed for a series of payments to grow to a future value
//at a specified interest rate, the @Cterm function specifies the present
// value, the future value, and the interest rate, and finds the required
// number of periods.
//Syntax:
//  CTerm(interest, future value, present value)
//  interest rate should be expressed as 9% or 0.09

void Parse::CTerm(Answer *answer)
{
	double x, y, i;

	Answer interest, fv, pv;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&interest, &fv, &pv);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	i = interest.type + fv.type + pv.type;
	if(i != 6) { serror(5); return;}  //type mysmatch
	i = interest.numeric;
	if(pv.numeric == 0.0L) {serror(10); return;}

	answer->numeric = log(fv.numeric /pv.numeric) / log(1+i);

	answer->type = 2;


}
//-------------------------------------------------------------------------
//Count the number of non-blank cells in the range
//Syntax: =@Count(A1:A50)
void Parse::Count(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;

	get_token();
	if(!*token == '(') {serror(1); return;}

	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count = 0;    //loop counter
	for(cy = y1; cy<= y2; cy++)
	{
		for(cx = x1; cx <= x2; cx++)
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type != 0)
			{
				count++;
			}

		}

	}


found:
	answer->numeric = (double) count;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;
}
//-------------------------------------------------------------------------
//Find the lowest value in a range of cells
// Syntax: =@Min(A1:A12);
void Parse::Min(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;
	double min;

	get_token();
	if(!*token == '(') {serror(1); return;}

	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >y100 || y2 < 0 || y2 >y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count =0;
	min = 0.0L;
	for(cy = y1; cy<= y2; cy++)
	{
		for(cx = x1; cx <= x2; cx++)
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				count++;
				if(count ==1) min =j->answer.numeric;
				else
				{
					if(j->answer.numeric < min) min = j->answer.numeric;
				}

			}

		}

	}


found:
	answer->numeric = min;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;
}
//-------------------------------------------------------------------------
void Parse::Max(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;
	double max;

	get_token();
	if(!*token == '(') {serror(1); return;}

	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count =0;
	max = 0.0L;
	for(cy = y1; cy<= y2; cy++)
	{
		for(cx = x1; cx <= x2; cx++)
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				count++;
				if(count ==1) max =j->answer.numeric;
				else
				{
					if(j->answer.numeric > max) max = j->answer.numeric;
				}

			}

		}

	}


found:
	answer->numeric = max;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;
}
//-------------------------------------------------------------------------
void Parse::Avg(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;
	double acc;

	get_token();
	if(!*token == '(') {serror(1); return;}

	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count =0;
	acc = 0.0L;
	for(cy = y1; cy<= y2; cy++)
	{
		for(cx = x1; cx <= x2; cx++)
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				count++;
				acc+= j->answer.numeric;
			}

		}

	}
	if(count)
	{
		acc = acc/ (double) count;
	}

found:
	answer->numeric = acc;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;
}
//-------------------------------------------------------------------------
// Calculate the double declining balance
// Syntax
//  =@DDB(cost, salvage value, life, period)
void Parse::Ddb(Answer *answer)
{
	double total_deprec, acc, bookvalue, deprec;
	Answer cost, salvage, life, period;

	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&cost, &salvage, &life);
	if(errnum) return;
	if(!*token){ serror(1); return;}
	if(*token == ')') {serror(1); return;}

	//token now contains the forth parameter. period
	//make sure there was a comma separating the 3rd and 4th parameters
	t= strlen(token)+1;
	while(*(prog-t) == ' ') t++; //skip any spaces
	if(*(prog -t) != ',') {serror(1); return;}
	eval_exp2(&period);
	if(errnum) return;
	if(*token != ')') {serror(1); return;}


	//We now have all the parameters.
	//Check that their values are all numeric
	int i = cost.type + salvage.type + life.type + period.type;
	if(i != 8) { serror(5); return;}  //type mysmatch
	//-----
	if(life.numeric <=2.0L) {serror(10); return;}
	if(period.numeric <1.0L || period.numeric > life.numeric)
		{serror(10); return;}

	int lfe = (int) life.numeric;
	int p = (int) period.numeric;
	acc = 0.0L;
	total_deprec = cost.numeric - salvage.numeric;
	for(t = 1; t <= lfe; t++)
	{

		if((acc + 2*cost.numeric / (double) lfe) >= total_deprec)
		{
			bookvalue = total_deprec - acc;
			//break;
		}
		else
			bookvalue = 2* cost.numeric / (double) lfe;
		acc+= bookvalue;
		cost.numeric -= bookvalue;

		if( p == t) break;

	}


	answer->numeric = bookvalue;
	answer->errnum =0;
	//-----
	answer->type = 2;
	get_token();

}
//-------------------------------------------------------------------------
//Straight_line depreciation
//Syntax: @SLN(cost, salvage value, life)
void Parse::Sln(Answer *answer)
{

	Answer cost, salvage, life;

	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&cost, &salvage, &life);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	int i = cost.type + salvage.type + life.type;
	if(i != 6) { serror(5); return;}  //type mysmatch
	//-----
	if(life.numeric == 0.0){serror(10); return;}
	if(salvage.numeric >= cost.numeric){ serror(10); return;}

	answer->numeric = (cost.numeric - salvage.numeric) / life.numeric;
	answer->errnum =0;
	//-----
	answer->type = 2;


}
//-------------------------------------------------------------------------
// Calculates the depreciation by the sum-of-the-years'-digits method.
// This method also accelerates depreciation so that the earlier life of the
// item reflects greater depreciation than later periods.
//Syntax: @SYD(cost, salvage value, life, period)

void Parse::Syd(Answer *answer)
{
	double b, m, f, bookvalue;
	Answer cost, salvage, life, period;

	int t, l;

	if(errnum) return;
	get_token();
	eval_exp66(&cost, &salvage, &life);
	if(errnum) return;
	if(!*token){ serror(1); return;}
	if(*token == ')') {serror(1); return;}

	//token now contains the forth parameter. period
	//make sure there was a comma separating the 3rd and 4th parameters
	t= strlen(token)+1;
	while(*(prog-t) == ' ') t++; //skip any spaces
	if(*(prog -t) != ',') {serror(1); return;}
	eval_exp2(&period);
	if(errnum) return;
	if(*token != ')') {serror(1); return;}


	//We now have all the parameters.
	//Check that their values are all numeric
	int i = cost.type + salvage.type + life.type + period.type;
	if(i != 8) { serror(5); return;}  //type mysmatch
	//-----
	if(life.numeric <1 ) {serror(10); return;}
	if(period.numeric <1){ serror(10); return;}
	if(cost.numeric < salvage.numeric) {serror(10); return;}
	if(period.numeric > life.numeric) {serror(10); return;}
	b = cost.numeric - salvage.numeric;
	l = (int) life.numeric;
	m = ((life.numeric+1)/2)*life.numeric;
	f = life.numeric;

	answer->numeric = b*(((f+1)-period.numeric)/m);

	answer->errnum =0;
	//-----
	answer->type = 2;
	get_token();

}
//-------------------------------------------------------------------------
void Parse::Sqrt(Answer *answer)
{
	if(errnum) return;
	get_token();
	if(*token != '(') {serror(1); return;}
	eval_exp22(answer);
	if(errnum) return;
	if(*token == ')') {serror(1); return;}
	get_token();

	if(answer->type != 2) {serror(5); return;}  //type mismatch
	if(answer->numeric <=0.0L) {serror(10); return;} // # out of range
	answer->numeric = sqrt(answer->numeric);

}
//-------------------------------------------------------------------------
//Variance and standard deviation are related dispersion statistics. The
// variance is the amount of deviation from the mean. The standard
//deviation, closely related to the variance, is the degree of
//deviation from the mean.
//  To calculate the variance, you subtract the mean of the numbers from each
//number in the group and square each result. You then add the
//squares and divide the total by the number of items in the group.
//To compute the standard deviaton, you the the square root of the variance.
//Syntax @Var(B3:B20)
void Parse::Var(Answer *answer)
{
	int count, x1, y1, x2, y2, l, t, cx, cy, s;
	char *p, cell_name[6];
	Cell *j;
	double mean, var;

	var = 0.0L;
	get_token();
	if(!*token == '(') {serror(1); return;}

	get_token();

	p = token;
	//we now should have a string like 'D1:D8'  pointed to by p
	x1 = toupper(*token) - 'A';
	s =0;
	if(token[1] =='$') s=1;   //its the second $ (ie., A$12)
	y1 = atoi(&token[1+s]) -1;
	p = strchr(token, ':');
	if(p == NULL) {serror(1); return;}     //syntax error
	p++;
	while(*p == ' ' || *p=='$') p++;  //skip any spaces after ':' and before the sceond
									//cell reference
	if(!*p) {serror(1); return;}
	x2 = toupper(*p) -'A';

	p++;
	if(*p=='$') p++;
	y2 = atoi(p) -1;

	get_token();     //get the current token pointed to by prog
	if(*token !=')') {serror(1); return;}

	get_token(); //move forward (most likely to the null terminator)


	//make sure cell references are legal
	if(x1< 0 || x1 > 25 || x2 < 0 || x2 > 25 || y1 <0 || y1 >=y100 || y2 < 0 || y2 >=y100)
	{
		answer->type =-1;
		answer->errnum =7;  //cell out of range
		serror(7);
		return;
	}

	//if range twisted retwist back to normal
	if(x2 < x1)
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if(y2 <y1)
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

//-------------
	count =0;
	mean = 0.0L;
	for(cy = y1; cy<= y2; cy++)
	{
		for(cx = x1; cx <= x2; cx++)
		{
			cell_name[0] = cx+'A';
			itoa(cy+1, &cell_name[1], 10);
			j = Find(cell_name);
			if(j->answer.type == 2)
			{
				count++;
				mean+= j->answer.numeric;
			}

		}

	}
	if(count)
	{
		mean = mean/ (double) count;

		for(cy = y1; cy<= y2; cy++)
		{
			for(cx = x1; cx <= x2; cx++)
			{
				cell_name[0] = cx+'A';
				itoa(cy+1, &cell_name[1], 10);
				j = Find(cell_name);
				if(j->answer.type == 2)
				{
					var += pow((j->answer.numeric -mean), 2);
				}

			}

		}

		var = var / (double) count;
	}

found:
	answer->numeric = var;
	answer->errnum =0;
	//-----
	answer->type = 2;
	errnum =0;

}
//-------------------------------------------------------------------------
//To compute the standard deviaton, you take the square root of the variance.
//Syntax @STD(B3:B20)

void Parse::Std(Answer *answer)
{
	Var(answer);
	if(!errnum)
	{
		if(answer->numeric >0)
		{
			answer->numeric = sqrt(answer->numeric);
		}
		else {serror(10); return;}   // # out of range
	}

}
//-------------------------------------------------------------------------
void Parse::Rate(Answer *answer)
{

	Answer fv, pv, periods;
	double x, y;
	int t;

	if(errnum) return;
	get_token();
	eval_exp66(&fv, &pv, &periods);
	if(errnum) return;

	//We now have all the parameters.
	//Check that their values are all numeric
	int i = fv.type + pv.type + periods.type;
	if(i != 6) { serror(5); return;}  //type mysmatch
	//-----
	if(fv.numeric == 0.0L){serror(10); return;}
	if(pv.numeric ==0.0L){ serror(10); return;}
	if(periods.numeric == 0.0L){serror(10); return;}

	x = (fv.numeric / pv.numeric);
	y = 1 / periods.numeric;
	answer->numeric = (pow(x, y)-1);
	answer->errnum =0;
	//-----
	answer->type = 2;

}
//-------------------------------------------------------------------------
static int ri =0;
void Parse::Rand(Answer *answer)
{

	double r;



	time_t t;
	if(!ri) srand((unsigned) time(&t));
	if(!ri) randomize();
	ri++;

top:
	r = (double) rand() * (double) rand();
	r = abs(r);
	while( r >1) r = r/rand();
	if(r == 0.0 || r == 1.0L) goto top;


	answer->numeric = r;
	answer->type = 2;
	errnum =0;
	get_token();
	if(*token != '(') {serror(1); return;}
	get_token();
	if(*token != ')') {serror(1); return ;}
	get_token();


}
//-------------------------------------------------------------------------
void Parse::Round(Answer *answer)
{
	Answer temp;

	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;}  //type mismatch
	if(*token != ',') {serror(1); return;}

	get_token();
	eval_exp2(&temp);
	if(temp.type != 2 || *token != ')'){serror(1); return;}
	get_token();
	if(temp.numeric >9.0L) temp.numeric = 9.0L;
	if(temp.numeric <1) temp.numeric = 0;
	answer->numeric = Precision(answer->numeric, (int)temp.numeric);
	answer->type = 2;

}
//-------------------------------------------------------------------------
//join string but without putting a space between them
void Parse::Strcat1(Answer *answer)
{

	char string1[250];
	char string2[250];
	int l;

	if(errnum) return;
	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	strcpy(string1, answer->text);
	RightTrim(string1);
	l = strlen(string1);
	/*
	if(l)
	{
		string1[l] = 32;
		string1[l+1] =0;
	}
	*/
	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(answer);    //get second string
	if(errnum) return;
	if(answer->type != 1) {serror(5); return;}  //type mismatch
	RightTrim(answer->text);
	l = strlen(answer->text);
	/*if(l)
	{
		answer->text[l] = 32;
		answer->text[l+1] =0;
	}
	*/
	strcat(string1, answer->text);
	string1[120] =0;
	strcpy(answer->text, string1);

	if(*token != ')') {serror(1); return;}
	get_token();

}
//-----------------------------------------------------------------------
void Parse::Pi(Answer *answer)
{
	get_token();
	if(*token != '('){serror(1); return;}
	//-----


	answer->numeric = 3.141592653589794L;
	answer->type =2;
	get_token();
	if(*token != ')') {serror(1); return;}
	get_token();


}
//-----------------------------------------------------------------------
// Get the Remainder after performing a division
// Syntax: @MOD(9, 5) results in 4
void Parse::Mod(Answer *answer)
{
	Answer temp;

	get_token();
	if(*token != '('){serror(1); return;}
	get_token();
	eval_exp2(answer);
	if(errnum) return;
	if(answer->type != 2) {serror(5); return;} //type mismatch
	if(*token != ',') {serror(1); return;}
	get_token();
	eval_exp2(&temp);
	if(errnum) return;
	if(temp.type != 2) {serror(5); return;}
	if(*token != ')') {serror(1); return;}
	get_token();
	if(temp.numeric == 0)  //trap division by zero error
	{
		serror(10);      //number out of range
		return;
	}

	answer->numeric = (long int) answer->numeric % (long int) temp.numeric;
	answer->type =2;
}
//-----------------------------------------------------------------------
//convert from Effective rate to Nominal rate
//
void Parse::Nom(Answer *answer)
{
	double eff, x, y;

	get_token();
	if(*token != '(') {serror(1); return;}
	get_token();
	eval_exp2(answer);   //evaluate the Eff rate parameter
	if(errnum) return;
	if(answer->type != 2){ serror(1); return;}

	eff = answer->numeric;

	if(*token != ',') {serror(1); return;}  //syntax error
	get_token();

	eval_exp2(answer);   //evaluate the x12 parameter
	if(errnum) return;
	if(answer->type != 2){ serror(1); return;}
	if(answer->numeric == 0.0L) {serror(10); return;}  //x12 out of range

	x = 1 +eff;
	y = 1 / answer->numeric;
	answer->numeric = (pow(x, y) -1) * answer->numeric;

	if(*token != ')') {serror(1); return;}
	get_token();
}
//----------------------------------------------------------------------
