//-----------------------------------------------------------------------
//Last update: 17 Feb 2000

#ifndef _PARSE_H
#define _PARSE_H
#include <stdio.h>
#include "farvars.h"
//The answer can be either numeric or text.
//if numeric its in var numeric, or if text its in var text
//its type is in var type. if type =0 its blank, if 1 text, 2 numeric
//if type <0 its the # of an an error message

struct Answer
{
	int type;             //0 = blank, 1 = text, 2 numeric, anything else = error
	int errnum;           //r # of the error message
	double numeric;
	char text[128];

};



struct Cell
{
	Answer answer;
	char cell_name[6];   //ie., A1, B7 etc.
	char input[130];      //blank, text, number, or formula

};



class Parse
{

	public:
		Parse();  //init sheet to null
		~Parse(); //free any memory that was reserved
      void StoreString(char *buf, unsigned int line);
      void FetchString(char *buf, unsigned int line);
		void DeallocatePages();
		int IsEMMInstalled();
		int Number(char *buf, double num, int decplaces, int commas);
		int RightTrim(char *buf);
      void Store(Cell *i, int clip=0); //store a cell
      Cell *Find(char *cell_name, int clip=0);  //find a cell, if found return a pointer
												//to its structure
		void Delete(Cell *i);         //delete a cell from the array

		double Precision(double v, int p);
       
      Cell *eval_exp(char *linebuf1, int c, int r);   //parser entry point
      Cell *eval_exp0(char *linebuf1, int c, int r);   
      void eval_exp1(Answer *result);
      void eval_exp2(Answer *answer);
		void eval_exp22(Answer *answer);
		void eval_exp3(Answer *answer);
		void eval_exp4(Answer *answer);
		void eval_exp5(Answer *answer);
		void eval_exp6(Answer *answer);
		void eval_exp66(Answer *answer1, Answer *answer2, Answer *answer3);
		void eval_exp99(Answer *answer1, Answer *answer2, Answer *answer3);

		void atom(Answer *answer);
		void get_token();
		void putback();
		void serror(int error);
		int isdelim(char c);
		void massage();    //remove any errors and return the type of the
								//input whether blank=0, text=1 or numeric=2
		void massage2();  //Change '=' into '=='
		int checkType();
		double Npv1(double rate, int x1, int y1, int x2, int y2);

		//these are the math functions supported by the parser:
		void Abs(Answer *answer);
		void Acos(Answer *answer);
		void If(Answer *answer);
		void Pmtc(Answer *answer);
		void Sum(Answer *answer);
		void Choose(Answer *answer);
		void Irate(Answer *answer);
		void Type(Answer *answer);
		void Eff(Answer *answer);
		void Cos(Answer *answer);
		void Sin(Answer *answer);
		void Tan(Answer *answer);
		void Ln(Answer *answer);
		void Log(Answer *answer);
		void Exp(Answer *answer);
		void Str(Answer *answer);
		void Strcat(Answer *answer);
		void Strcat1(Answer *answer);
		void Strcmp(Answer *answer);
		void Bigdays(Answer *answer);
		void Today(Answer *answer);
		void Easter(Answer *answer);
		void GetDate(Answer *answer);
		void Int(Answer *answer);
		void Npv(Answer *answer);
		void Irr(Answer *answer);
		void Pv(Answer *answer);
		void Fv(Answer *answer);
		void Term(Answer *answer);
		void CTerm(Answer *answer);
		void Count(Answer *answer);
		void Min(Answer *answer);
		void Max(Answer *answer);
		void Avg(Answer *answer);
		void Ddb(Answer *answer);
		void Sln(Answer *answer);
		void Syd(Answer *answer);
		void Sqrt(Answer *answer);
		void Var(Answer *answer);
		void Std(Answer *answer);
		void Rate(Answer *answer);
		void Round(Answer *answer);
		void Rand(Answer *answer);
		void Pi(Answer *answer);
		void Mod(Answer *answer);
		void Nom(Answer *answer);       //Eff to nominal rate

		//-----------------------
		int FindFunction(char *name);   //see if the function named is
		char *AdjustReference(char *buf, int x1, int y1, int x2, int y2,
					int distx, int disty, int absol);										  //supported.

		int AdjustReferences(char *prog, int x1, int y1, int x2, int y2,
										int distx, int disty, int absol);

		void AutoCalc();                //evaluate all text and numeric cells
												  //and update accordingly
		char errorMessage[80];
		int errnum;                     //error message number, 0 = ok
		int assumetext;                 //normally =0, if =1 default to text


		FARVARS sheet;
      Cell ce;
      char packed[302];      //cell info
     
   private:
      int allocated;      //whether EMM allocated or nor 0 = no.
      int row, col;      //current cell 1- 100, 1-26
		int x2, y2;        //if a range is selected: end coordinates
      char *prog;        //points to the expression to be analysed
      char token[80];
      char tok_type;      
      int num_funcs;                  
      public:
      FILE *phandle;

};
//-------------------------------------------------------------------------
#endif
