/*-------------------------------------------------------------------------
  9 Feb 2000
-------------------------------------------------------------------------*/


#include "keyboard.h"

#if !defined MENU_H
#define MENU_H

struct TMENU
{
        char *txt;               //pointer to name of item
        char qletter;            //quick letter of item
        char *exptxt;            //pointer to text that explains option
        unsigned len:        7;  //len of text in item name
        unsigned qletterpos: 6;  //position in item name of quick letter
        unsigned qlettersw:  1;  //quick letter on or off
        unsigned barsw:      1;  //horizontal bar under item on/off
        unsigned availablesw:1;  //item available yes/no

};
//-------------------------------------------------------------------
class Menu : public Keyboard     //inherits from keyboard class,
{                                                                 //Keyboard class in turn inherits from
                                                                  //class Screen
	  public:
         TMENU  m_menu[7][11];            //contains menu item details
			int m_topMenuPos[7];            //pos on top line of each item
			int m_subMenuCursorPos[16];      //separate cursor y pos in each menu box
			int m_numOfSubOpts[7];          //num of items in each box
			int m_topMenuCursorPos;           //current menu cursor pos of line menu

			int m_bc, m_fc;                //background & foreground colours of screen


	public:
			 Menu();                         //constructor: initialises the items
			 int GetTopMenuItem();           //wait for user to cursor select item
			 int ShowTopMenu(int sw);        //show top menu on or off

			 //show box and items, but don't wait
			 int ShowMenuBox(int drawboxflg, int subitemsw=1);

			 int GetSubMenuItem(int keybrd=1); //wait for user to select an option
			 int MouseMovement(int boxon);  //button held down. wait for mouse move
			 int CheckTopMenu();   //see if mouse on top menu item
			 int ShowCoordinates();  //for debugging only

			 int CopyCoordinates();  //copy from bigmapper into m_boxmapper
			 int IsMouseInBox();
			 TMousePos m_boxmapper[16];     //sub items to screen rows, cols
			 TMousePos m_bigmapper[7][16];  //sun items rows, cols for all boxes



};
//----------------------------------------------------------------------
#endif
