;--------------------------------------------------------------------------
;Last update 18 Feb 2000

					  .model medium, C

;--------------------------------------------------------------------------
					  .FARDATA txttab             ;
					  db   65535 dup(0)           ;reserve 128k for text
					  .FARDATA txttab1
					  db   65535 dup(0)
					  .FARDATA txttab2
					  db 2 dup(0)              ;make sure its exactly 128k
;----------------------------------------
					  .DATA

					  .CODE
LOCALS

;--------------------------------------------------------------------------
;Initialise the 128k of far memory

					  PUBLIC _initfarmem
_initfarmem      PROC C far uses es di, \

					 cld
					 mov ax, txttab
					 mov es, ax
					 mov ax, 0
					 mov di, ax;
					 mov cx, 32768
					 rep stosw
									  ;di is now at 0 again because of looping
									  ;from 0 to 65536
					 mov bx, es   ;move up to next 64k seg at txttab1
					 add bx, 16
					 mov es, bx
					 mov cx, 32768
					 rep stosw      ;repeatedly store ax into es:di
										;inc'ing di by 2 after each store
					 ret
_initfarmem     ENDP

;--------------------------------------------------------------------------
;Return a byte from the 64k of reserve far memory
;int _peek(unsigned int pos);
; pos can be any position from 0 to 65534
; Exit
;  ax = the byte fetched

					  PUBLIC _peek
_peek            PROC C far uses ds si, \
					  pos: ptr dword

					  mov dx, word ptr pos+2      ;hi word
					  mov ax, word ptr pos
					  mov cx, 16
					  div cx
					  add ax, txttab
					  mov ds, ax
					  mov si, dx
					  mov al, byte ptr ds:[si]
					  mov ah, 0

					 ret
_peek           ENDP

;--------------------------------------------------------------------------
;Store a byte into a position in the 64k of reserve far memory
;int _poke(unsigned int pos, int val);
; pos can be any position from 0 to 65534
;Exit:
;

					  PUBLIC _poke
_poke            PROC C far uses ds es si, pos: ptr dword, val: ptr word
					  push ds
					  pop  es                     ;make sure es poinnts to ds
					  mov bx, val+2

					  mov  dx, word ptr pos+2
					  mov  ax, word ptr pos
					  mov  cx, 16
					  div  cx
					  mov  si, dx     			;remainder
					  add  ax, txttab 			;quotient added to seg
					  mov  ds, ax


					  mov  byte ptr ds:[si], bl
					  mov  ax, bx

					 ret
_poke           ENDP

;--------------------------------------------------------------------------
					  END

