//----------------------------------------------------------------
// Last updated: 19 Feb 2000
//----------------------------------------------------------------

#if !defined _GRID_H
#define _GRID_H
#include "parse.h"
#include "disk2.h"


struct CellBlock              //structure for a range of cells
{
	int x1, y1;
	int x2, y2;
	int validsw;
};

class Grid
{

	public:
           Grid();         //constructor to init Grid class
           ~Grid();               //auto save grid's scrnsheet[] to disk
      int GetMaxWidth(int cx, int cy, int desired);
      void SetAltRows();  //pattern cols
      void SetAltCol(int cx);  //pattern just this col
      void DispScrollBar();
      void DispStatusLine();
		//the col, row references on the left and top
      int DrawBorder(int x, int y);
      int DrawSheet();   //the sheet display area
		//draw sheet but not the border
      int ReDrawSheet(int active);
      int DrawRow();
      int ColourRow();
      int DispCell(int active);
      int NewSheet();    //delete all cells in spreadsheet
      int DoBit(int col);  //mouse clicked on column header bit
      int AutoScrollLeft();
      int AutoScrollRight();
      //return any spill over text (from the right of the text) for use
		//in a blank cell
      int PreText(char *buf, int cy);
      int DispCell1(char *linebuf1, char *formula,
						  unsigned int colour, int sel, int cx, int cy);



		//int IsCellInBlockRange(int cx, int cy);
      int Cut();    //cut block of cells in x
      int Copy();   //copy block of cells in x
      int Paste();  //paste from clipb to current col,row
      int Clear();  //clear a block of cells
      int InsertCol();   //
      int InsertRow();   //
      int DeleteCol();   //
      int DeleteRow();   //
      int ColWidth();    //change the width
      int RevealCols();  //reveal any hidden cols

      int Auto();
      int Manual();       //
      int RightJustify(); //
      int LeftJustify();  //
      int Centre();       //
      int NumbersInCommas(); //
      int DecimalPlaces();   //
      int Percent();         //toggle the percent display flag



		//Get parser's cell contents if any and format it
		//and store the result in buf
		//if parser cell is blank return an blank string the
		//size of the column width
      int GetLineBuf(char *linebuf1,
			char *input, int cx, int cy, int *colour);

      int CursorRight(int active);
      int CursorLeft(int active);
      int CursorDown(int active);
      int CursorUp(int active);
      int PageDown(int active);
      int PageUp(int active);
      int CellInput(int flg);
		//---------
		// scrollbar
      int MouseCursorDown(int active);
      int MouseCursorUp(int active);
      int ScrollDownArrow(int active);
      int ScrollUpArrow(int active);
		int CalcScrollBar(int topline);
      int MoveScrollBarCursorUp(int active);
      int MoveScrollBarCursorDown(int active);
      int ClickInScrollBar(int active);
		//-------------
		//--text area--
		int ClickedInWhichCell(int *cx, int *cy);
      int BlockCursorUp();
      int BlockCursorDown();
      int BlockCursorLeft();
      int BlockCursorRight();

		//set cell to where click occurred
      int SetCellToMouse();
		void TwistBlockVars();
		void GetBlockVars();
      void Refresh();
     int TrackCursor();
     int MouseInWhichColumn();
     void NormaliseScreen();
	  //--------------
     int ChangeAllignment(int allign);
     int AdjustFormulas(int x1, int y1, int x2, int y2,
                     int destx, int desty, int absol);

     int CkeckBlocks();   //check that the block or multiple copies of it
                           //can be pasted at desired location.
     int PasteCell(int scol, int srow, int dcol, int drow);
	  int LockCells();
	  int UnlockCells();
	  int ColourCells();
     int ShowLockedErrorMsg();
     int DoHeader();        //mouse was clicked in the column header
     int IncreaseColumnWidth(int dist);
     int ReduceColumnWidth(int dist);
     int MouseOnWhichBit(int dist);
     int ShowWidth(int x);
     int LimitVars();
     void RefreshNormalRow();
	  RePatternRows(int insert_or_delete);   //helper for "insert row" & "delete row"
     int FindLastRow();
      
      ScreenCell *scrnsheet;  //first 2600 cells are main grid, second
                                    //2600 cells are clip grid
     
		int scrncol, scrnrow;   //current relative screen cell row, col
										//(ie., 0,0 = upper left corner of data area)
      
		int homex, homey;        //the first cell on the screen
		//if homex = 5 and homey = 1 and if scrncol = 1 and scrn row = 2
		//then the cell selected is homex+ scrncol, homey+scrnrow
		//= G4

      
		int colwidths[26];
      
		CellBlock block;
      CellBlock c_block;         //pars for block in clipboard
      int calc;               	//0 = manual, 1 = auto
		unsigned char letters[81]; //current column headers letters
		int starts[80];         	//starting pos of each column
											//ie., 0, 9, 18, etc.,

		int orghomey;           	//original vars for the cut routine
		int orgscrnrow;         	//this was where the mouse selection began
		int orgscrncol;
		int orgcy;
		int orgcx;
      FILE *han;             //for saving and loading the grids sheet[]
      //---------
      //vars used by various pasting helper functions
      int oxl, oyl, dxl, dyl, xfit, yfit; //org x len, org y, len
                                          //dest x len dest y len,
                                          //xfit = r # of horizontal copies
                                          //yfit = r # of vertical copies


};
//-------------------------------------------------------------------------
#endif
