#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "allegro.h"
#include "midifile.h"
#include "lmuse.h"

/*extern lmuse.c*/
extern MAP maps[];
extern int factstacks_p, transposestack_p;
extern int draw_p;
extern int division;
extern float thick;
int esc_or_right_mouse_button_pressed();

/*extern prod.c*/
extern char *production;

/*extern scales.c*/
extern int (*scalefn)(int, SCALE*);
extern SCALE * cur_scale;

/*extern draw.c*/
extern int maxcolor;
inline void drawline(float x,float y,float z,float xl,float yl,float zl,int clr);

STATE curstate;
int curchar;
int prevchar;
float curdrawlength;

void sprint_curstate(char *buffer);
void print_curstate();
unsigned long maxcumtime;
float deflscale = .9;   /* default scaling for '*/

float dmultiplier=4.0;
float pspread=1.0;
float dspread=1.0;
float vspread=1.0;

float maxx=0,maxy=0,maxz=0,minx=0,miny=0,minz=0;
float fmaxx=0,fmaxy=0,fmaxz=0,fminx=0,fminy=0,fminz=0;
float umaxx=0,umaxy=0,umaxz=0,uminx=0,uminy=0,uminz=0;
float lmaxx=0,lmaxy=0,lmaxz=0,lminx=0,lminy=0,lminz=0;
float maxlength;
float minlength;
float maxdrawlength;
float mindrawlength;

float maxthickness;
float minthickness;

int numobjects;

float deltaanglerad=10.0*PI/180.0;

VECTOR sky={0.0,1.0,0.0};

float fzero=0.0;
VARIABLE constantvar={&fzero,0,0,0};

VARIABLE pitchvariable;
VARIABLE durationvariable;
VARIABLE velocityvariable;

unsigned char trackchannel[MAXTRACKS]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
unsigned long trackcumtime[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
unsigned long trackprevcumtime[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
unsigned char trackflags[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/*midi list stuff*/
MIDINOTELIST * tracklist[MAXTRACKS];
MIDINOTELIST * tracklastnode[MAXTRACKS];
MIDINOTELIST * tracknextnode[MAXTRACKS];


MIDINOTELIST *
makenewnode()
{
     MIDINOTELIST * mlist= (MIDINOTELIST *)malloc(sizeof(MIDINOTELIST));
     if (mlist==NULL){
        allegroexiterror("midinotelist allocation error");
     }
     mlist->next=NULL;
     mlist->prev=NULL;

     return mlist;
}

MIDINOTELIST *
findlast(L) MIDINOTELIST * L;
{
	MIDINOTELIST * this_node;
	this_node=L;
        if(this_node==NULL) return (this_node);
	while(this_node->next != NULL)
		this_node=this_node->next;
	
	return (this_node);
}

MIDINOTELIST *
findtime(L, tm) MIDINOTELIST * L; unsigned long tm;
{
/*supposed to return the last node whose time is less than or equal to tm*/
	MIDINOTELIST * this_node;
	unsigned long accumtime=0L;

	this_node=L;
	while(this_node != NULL){
		accumtime += this_node->m.t;
		if(this_node->next != NULL){

			if(accumtime+(this_node->next->m.t)>tm)
				return (this_node);
			this_node=this_node->next;
		}
		else return (this_node);
	}
        return NULL;
}

MIDINOTELIST * 
appendnewnode(last_node) MIDINOTELIST * last_node;
{  
        MIDINOTELIST * this_node;
        this_node = makenewnode();

        this_node->prev  = last_node;

	if(last_node != NULL)
        	(last_node)->next  = this_node;

        return (this_node);
}

void insertnode(afterme, newL)  MIDINOTELIST * afterme, * newL;
{
	MIDINOTELIST * oldnxt;
	if(afterme !=NULL){
		oldnxt = afterme->next;
		afterme->next = newL;
	}
	else	oldnxt=NULL;
	newL->next = oldnxt;
	newL->prev = afterme;
	if(oldnxt !=NULL)
		oldnxt->prev = newL;
}

MIDINOTELIST *insertattime(MIDINOTELIST * *L,MIDINOTELIST *newL,unsigned long attime, int priority){

        MIDINOTELIST * afterme;
        MIDINOTELIST * beforeme;
        MIDINOTELIST * this_node;
	unsigned long accumtime=0L;

	this_node=*L;
        if(this_node->m.t<attime || (this_node->m.t==attime && priority <1)){
	    while(this_node != NULL){
		accumtime += this_node->m.t;
                if(accumtime==attime && priority==1){
                          newL->next=this_node;
                          newL->prev=this_node->prev;
                          if(this_node->prev)
                               (this_node->prev)->next=newL;
                          this_node->prev=newL;
                          newL->m.t=this_node->m.t;
                          this_node->m.t=0;
                          return newL;
                }
		if(this_node->next != NULL){


			if(accumtime+(this_node->next->m.t)>attime)
				break;
			this_node=this_node->next;
		}
		else break;
	     }
        }
        else{  /* attime goes at beginning of list */
             *L=newL;
             newL->next=this_node;
             newL->prev=NULL;
             newL->m.t=attime;
             this_node->m.t -= attime;
             this_node->prev=newL;
             return newL;
        }
        afterme=this_node;
        beforeme=this_node->next;
        newL->m.t = attime-accumtime;
        if(beforeme!=NULL){ /*attime is before the end of the list*/
             beforeme->m.t -= newL->m.t;
             beforeme->prev=newL;
        }
        newL->prev=afterme;
        newL->next=beforeme;
        afterme->next=newL;


        return(newL);
}

MIDINOTELIST *insertlistattime(MIDINOTELIST * *L,MIDINOTELIST *newL,unsigned long attime){

        MIDINOTELIST * afterme;
        MIDINOTELIST * beforeme;
        MIDINOTELIST * this_node;
        MIDINOTELIST * end_node;
	unsigned long accumtime=0L;
        /*first find the end node of the list to be added*/
        this_node=newL;
        end_node=newL;
        while(this_node->next !=NULL){
             end_node=this_node->next;
             this_node=end_node;
        }


	this_node=*L;
        if(this_node->m.t<attime){
	    while(this_node != NULL){
		accumtime += this_node->m.t;
                if(this_node->next != NULL){


			if(accumtime+(this_node->next->m.t)>attime)
				break;
			this_node=this_node->next;
		}
		else break;
	     }
        }
        else{  /* attime goes at beginning of list */
             *L=newL;
             end_node->next=this_node;
             newL->prev=NULL;
             newL->m.t=attime;
             this_node->m.t -= attime;
             this_node->prev=end_node;
             return newL;
        }
        afterme=this_node;
        beforeme=this_node->next;
        newL->m.t = attime-accumtime;
        if(beforeme!=NULL){ /*attime is before the end of the list*/
             beforeme->m.t -= newL->m.t;
             beforeme->prev=end_node;
        }
        newL->prev=afterme;
        end_node->next=beforeme;
        afterme->next=newL;


        return(newL);
}

MIDINOTELIST * findmynoteoff(MIDINOTELIST * me,unsigned long * dur){
         unsigned long accumtime=0L;
         MIDINOTELIST * cur_node=me->next;
         MIDICHANEVENT m=me->m;
         MIDICHANEVENT m1;
         int stat;
         int mychannel=m.status&0x0F,channel;
         int mypitch=m.data1;
         while(cur_node!=NULL){
                m1=cur_node->m;
                stat=m1.status&0xF0;
                channel=m1.status&0x0F;
                accumtime+=m1.t;
                if(stat==NOTEOFF && channel==mychannel){
                    if(m1.data1==mypitch){
                              *dur=accumtime;
                              return cur_node;
                    }
                }
                cur_node=cur_node->next;
         }
         return cur_node;
}

/*this only works if the list has an end!*/
void free_midi_note_list( MIDINOTELIST  * M)
{
     MIDINOTELIST * current_element = M;
     MIDINOTELIST * next_element;
     if(M != NULL && M->prev != NULL) (M->prev)->next=NULL;     
     while(current_element != NULL){
          next_element = current_element->next;
          free(current_element);
          current_element = next_element;
     }
     
}


float  getfloat();

/*stacks */
STATE statestack[STACKDEPTH];
int stacktop=0;

unsigned long timestack[STACKDEPTH];
int timestacktop=0;

int transposestack[STACKDEPTH]={0};
int transposestacktop=0;

float dfactstack[STACKDEPTH]={1.0};
int dfactstacktop=0;

float vfactstack[STACKDEPTH]={1.0};
int vfactstacktop=0;


void pushtime(unsigned long t){
     timestack[timestacktop]=t;

     timestacktop++;
}

unsigned long poptime(){

     if (timestacktop<1){
        return timestack[0];
     }
     return timestack[--timestacktop];
}

/*state stack functions*/
void pushstate(STATE s){
     statestack[stacktop]=s;
     stacktop++;
}

STATE popstate(){
     if (stacktop<1){
        return statestack[0];
     }
     return statestack[--stacktop];
}

/*transpose stack functions*/
void pushtranspose(int t){

     transposestack[transposestacktop]=t;

     transposestacktop++;
}
int poptranspose(){
     if (transposestacktop<1){

                return transposestack[0];
     }
     return transposestack[--transposestacktop];

}

/*duration stack functions*/
void pushdfact(float fact){


     dfactstack[dfactstacktop]=fact;

     dfactstacktop++;
}
float popdfact(){
     if (dfactstacktop<1){


        return dfactstack[0];
     }
     return dfactstack[--dfactstacktop];

}

/*velocity stack functions*/
void pushvfact(float fact){

     vfactstack[vfactstacktop]=fact;

     vfactstacktop++;
}

float popvfact(){
     if (vfactstacktop<1){


        return vfactstack[0];
     }
     return vfactstack[--vfactstacktop];

}


VARIABLE statevariablearray[NUMSTATEVARS]= {
         {&(curstate.x),COORDINATE,&minx,&maxx},
         {&(curstate.y),COORDINATE,&miny,&maxy},
         {&(curstate.z),COORDINATE,&minz,&maxz},
         {&(curstate.fdirection.x),DIRECTION,&fminx,&fmaxx},
         {&(curstate.fdirection.y),DIRECTION,&fminy,&fmaxy},
         {&(curstate.fdirection.z),DIRECTION,&fminz,&fmaxz},
         {&(curstate.udirection.x),DIRECTION,&uminx,&umaxx},
         {&(curstate.udirection.y),DIRECTION,&uminy,&umaxy},
         {&(curstate.udirection.z),DIRECTION,&uminz,&umaxz},
         {&(curstate.ldirection.x),DIRECTION,&lminx,&lmaxx},
         {&(curstate.ldirection.y),DIRECTION,&lminy,&lmaxy},
         {&(curstate.ldirection.z),DIRECTION,&lminz,&lmaxz},
         {&(curstate.length),LENGTH,&minlength,&maxlength},
         {&(curdrawlength),LENGTH,&mindrawlength,&maxdrawlength},
         {&(curstate.thickness),LENGTH,&minthickness,&maxthickness}

};

void getvariablelimits(){
   if( curstate.x > maxx ) maxx = curstate.x;
   if( curstate.x < minx ) minx = curstate.x;
   if( curstate.y > maxy ) maxy = curstate.y;
   if( curstate.y < miny ) miny = curstate.y;
   if( curstate.z > maxz ) maxz = curstate.z;
   if( curstate.z < minz ) minz = curstate.z;
   if( curstate.fdirection.x > fmaxx ) fmaxx = curstate.fdirection.x;
   if( curstate.fdirection.x < fminx ) fminx = curstate.fdirection.x;
   if( curstate.fdirection.y > fmaxy ) fmaxy = curstate.fdirection.y;
   if( curstate.fdirection.y < fminy ) fminy = curstate.fdirection.y;
   if( curstate.fdirection.z > fmaxz ) fmaxz = curstate.fdirection.z;
   if( curstate.fdirection.z < fminz ) fminz = curstate.fdirection.z;
   if( curstate.udirection.x > umaxx ) umaxx = curstate.udirection.x;
   if( curstate.udirection.x < uminx ) uminx = curstate.udirection.x;
   if( curstate.udirection.y > umaxy ) umaxy = curstate.udirection.y;
   if( curstate.udirection.y < uminy ) uminy = curstate.udirection.y;
   if( curstate.udirection.z > umaxz ) umaxz = curstate.udirection.z;
   if( curstate.udirection.z < uminz ) uminz = curstate.udirection.z;
   if( curstate.ldirection.x > lmaxx ) lmaxx = curstate.ldirection.x;
   if( curstate.ldirection.x < lminx ) lminx = curstate.ldirection.x;
   if( curstate.ldirection.y > lmaxy ) lmaxy = curstate.ldirection.y;
   if( curstate.ldirection.y < lminy ) lminy = curstate.ldirection.y;
   if( curstate.ldirection.z > lmaxz ) lmaxz = curstate.ldirection.z;
   if( curstate.ldirection.z < lminz ) lminz = curstate.ldirection.z;

   if(curstate.length>maxlength)maxlength=curstate.length;
   if(curstate.length<minlength)minlength=curstate.length;
   if(curdrawlength>maxdrawlength)maxdrawlength=curdrawlength;
   if(curdrawlength<mindrawlength)mindrawlength=curdrawlength;
   if(curstate.thickness>maxthickness)maxthickness=curstate.thickness;
   if(curstate.thickness<minthickness)minthickness=curstate.thickness;
}
char curstatestring[512];
int checkvariablewidths(){
        int i;
        float pwd,dwd,vwd;
        for(i=0;i<MAXMAPS;i++){
            pwd=*(maps[i].pitch->mymax)-*(maps[i].pitch->mymin);
            dwd=*(maps[i].duration->mymax)-*(maps[i].duration->mymin);
            vwd=*(maps[i].volume->mymax)-*(maps[i].volume->mymin);
            if(isinf(pwd) ||isinf(dwd)||isinf(vwd)){
                sprintf(curstatestring,"Map %d:\npitch variable width: %f,\nduration variable width: %f,\nvolume variable width: %f,\n",
                        i, pwd,dwd,vwd);
                return -1;
            }
        }
        return 0;
}
void initvariablelimits(){

   fmaxx = curstate.fdirection.x;
   fminx = curstate.fdirection.x;
   fmaxy = curstate.fdirection.y;
   fminy = curstate.fdirection.y;
   fmaxz = curstate.fdirection.z;
   fminz = curstate.fdirection.z;
   umaxx = curstate.udirection.x;
   uminx = curstate.udirection.x;
   umaxy = curstate.udirection.y;
   uminy = curstate.udirection.y;
   umaxz = curstate.udirection.z;
   uminz = curstate.udirection.z;
   lmaxx = curstate.ldirection.x;
   lminx = curstate.ldirection.x;
   lmaxy = curstate.ldirection.y;
   lminy = curstate.ldirection.y;
   lmaxz = curstate.ldirection.z;
   lminz = curstate.ldirection.z;

   maxlength=curstate.length;
   minlength=curstate.length;
   maxdrawlength=curdrawlength;
   mindrawlength=curdrawlength;
   maxthickness=curstate.thickness;
   minthickness=curstate.thickness;
}

void cross (VECTOR *v, VECTOR *w, VECTOR *r){
/* r = v X w;  'r' for 'result'*/
  r->x = v->y * w->z - v->z * w->y;
  r->y = v->z * w->x - v->x * w->z;
  r->z = v->x * w->y - v->y * w->x;
}


void rotate (VECTOR *t , VECTOR *v , VECTOR *r, float a){
/*rotate v around t by angle a. result stored in r*/
    float tx=t->x,ty=t->y,tz=t->z,vx=v->x,vy=v->y,vz=v->z;
    float ac,bc,cc,cosa,sina,gz;
    float R11,R12,R13,R21,R22,R23,R31,R32,R33;
    float tlen = sqrt(tx*tx + ty*ty + tz*tz);
    if(tlen>0){
      ac = tx/tlen;
      bc = ty/tlen;
      cc = tz/tlen;
      cosa = cos(a); sina = sin(a);
      gz = 1 - cosa;
  
      R11 = ac*ac*gz + cosa;    R12 = ac*bc*gz - cc*sina; R13 = ac*cc*gz + bc*sina;
      R21 = ac*bc*gz + cc*sina; R22 = bc*bc*gz + cosa;    R23 = bc*cc*gz - ac * sina;
      R31 = ac*cc*gz - bc*sina; R32 = bc*cc*gz + ac*sina; R33 = cc*cc*gz + cosa;
  
      r->x = R11*vx + R12*vy + R13*vz;
      r->y = R21*vx + R22*vy + R23*vz;
      r->z = R31*vx + R32*vy + R33*vz;
    }
}


void xrot (VECTOR *v, VECTOR *vn, float theta){
        vn->x = v->x;
        vn->y = (v->y) * cos(theta) - (v->z) * sin(theta);
        vn->z = (v->z) * cos(theta) + (v->y) * sin(theta);
}

void yrot (VECTOR *v, VECTOR * vnew, float theta){

        vnew->x = (v->x) * cos(theta) + (v->z) * sin(theta);
        vnew->y = v->y;
        vnew->z = (v->z) * cos(theta) - (v->x) * sin(theta);
}

void zrot (VECTOR *v, VECTOR *vnew, float theta){
        vnew->x = (v->x) * cos(theta) + (v->y) * sin(theta);
        vnew->y = (v->y) * cos(theta) - (v->x) * sin(theta);
        vnew->z = v->z;
}


#include <signal.h>
void arithmeticerrorhandler(){

    allegro_exit();
    print_curstate();
    exit(0);

}
END_OF_FUNCTION(arithmeticerrorhandler);


void setmapto(int mapnumber){
     pitchvariable=*(maps[mapnumber].pitch);
     durationvariable=*(maps[mapnumber].duration);
     velocityvariable=*(maps[mapnumber].volume);
     pspread=maps[mapnumber].pspread;
     dspread=maps[mapnumber].dspread;
     vspread=maps[mapnumber].vspread;
     dmultiplier=maps[mapnumber].dmultiplier;
     transposestack_p=maps[mapnumber].tstack;
     factstacks_p=maps[mapnumber].fstacks;

}

int getapitch();
int getavelocity();
long getaduration();
int count_notes=0;

long inserttracknote(int tracknumber, int on_off){
      int pitch;
      long dur =getaduration();
      int vel=0;
      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * last_node;
      prev_cum_time=trackprevcumtime[tracknumber];

      if(on_off){
           pitch = getapitch()&0x7F;
           vel=getavelocity()&0x7F;
      }
      else {
           pitch=0;
           cum_time=cum_time+dur;
      }
      if(pitch>0){

           count_notes++;
           /*make the note_on node*/
           last_node=makenewnode();
           if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=last_node;
                last_node->m.t=cum_time-prev_cum_time;
           }
           else
                insertattime(&tracklist[tracknumber],last_node,cum_time,0);
           last_node->m.status=NOTEON|channel;
           last_node->m.data1=pitch;
           last_node->m.data2=vel;

           /*make the note_off*/
           last_node=makenewnode();

           insertattime(&tracklist[tracknumber],last_node,cum_time+dur,0);

           last_node->m.status=NOTEOFF|channel;
           last_node->m.data1=pitch;
           last_node->m.data2=0;


           trackprevcumtime[tracknumber]=cum_time+dur;
           curstate.prevcumtime=cum_time+dur;

           tracklastnode[tracknumber]=last_node;

           trackflags[tracknumber]|=ACTIVE;
      }
      curstate.cumtime+=dur;

      return dur;
}
long insertpatchandnote(int tracknumber){

      int program =curstate.clr%127;

      int pitch;
      long dur =getaduration();
      int vel;
      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * patch_node,*note_node;
      prev_cum_time=trackprevcumtime[tracknumber];

      pitch = getapitch()&0x7F;
      vel=getavelocity()&0x7F;


      if(pitch>0){

           count_notes++;
           /*make the note_on node*/
           patch_node=makenewnode();
           note_node=makenewnode();
           patch_node->next=note_node;
           note_node->prev=patch_node;
           note_node->m.t=0L;

           if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=patch_node;
                patch_node->m.t=cum_time-prev_cum_time;
           }
           else
                insertlistattime(&tracklist[tracknumber],patch_node,cum_time);
           patch_node->m.status=PRG_CHG|channel;
           patch_node->m.data1=program;
           patch_node->m.data2=0;
           note_node->m.status=NOTEON|channel;
           note_node->m.data1=pitch;
           note_node->m.data2=vel;

           /*make the note_off*/
           note_node=makenewnode();

           insertattime(&tracklist[tracknumber],note_node,cum_time+dur,0);

           note_node->m.status=NOTEOFF|channel;
           note_node->m.data1=pitch;
           note_node->m.data2=0;


           trackprevcumtime[tracknumber]=cum_time+dur;
           curstate.prevcumtime=cum_time+dur;

           tracklastnode[tracknumber]=note_node;

           trackflags[tracknumber]|=ACTIVE;
      }
      curstate.cumtime+=dur;

      return dur;
}

void inserttrackpatch(int tracknumber){

      long program =curstate.clr%127;

      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * last_node;

      count_notes++;
      /*make the note_on node*/
      last_node=makenewnode();
      if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=last_node;
                last_node->m.t=cum_time-prev_cum_time;
      }
      else
           insertattime(&tracklist[tracknumber],last_node,cum_time,1);
      last_node->m.status=PRG_CHG|channel;
      last_node->m.data1=program;

      tracklastnode[tracknumber]=last_node;

      trackflags[tracknumber]|=ACTIVE;

}


int basenote=60;
#define FPZERODIF 1e-5

int getapitch(){
      int pitch;
      VARIABLE p=pitchvariable;
      float pwide=*p.mymax-*p.mymin;
      float midp=(*p.mymax+*p.mymin)/2;

      if(pwide>FPZERODIF){

                 pitch=basenote+curstate.transpose+curstate.mymap->transpose+scalefn( pspread*(*p.v-midp)*30/pwide ,cur_scale);
      }
      else
                 pitch=basenote+curstate.transpose+curstate.mymap->transpose+scalefn( 0,cur_scale);
      return pitch;
}


long getaduration(){
      long dur;
      VARIABLE d=durationvariable;
      float dwide=*d.mymax-*d.mymin;
      float midd=(*d.mymax+*d.mymin)/2;

      if(dwide>FPZERODIF){

                 dur=curstate.dfact*dmultiplier*division/8*pow(2,dspread*(*d.v-midd)/dwide);
      }
      else
                 dur=curstate.dfact*dmultiplier*division/8*pow(2,0);

      return dur;
}


int getavelocity(){
      int vel;
      VARIABLE v=velocityvariable;
      float vwide=*v.mymax-*v.mymin;
      float midv=(*v.mymax+*v.mymin)/2;

      if(vwide>FPZERODIF){

                 vel=64+ vspread*(*v.v-midv)*30/vwide;
      }
      else   vel=64;
      vel=(int)(curstate.vfact*vel);
      if (vel>0x7F) vel=0x7F;
      return (vel);
}

void print_curstate(){
     printf("current state:\n"
        "angle=%f,\nx=%f, y=%f, z=%f\n"
        "fdirection.x=%f, fdirection.y=%f, fdirection.z=%f,\n"
        "udirection.x=%f, udirection.y=%f, udirection.z=%f,\n"
        "ldirection.x=%f, ldirection.y=%f, ldirection.z=%f,\n"
        "length=%f, thickness=%f\n",
        curstate.deltaangle,curstate.x,curstate.y,curstate.z,
        curstate.fdirection.x,curstate.fdirection.y,curstate.fdirection.z,
        curstate.udirection.x,curstate.udirection.y,curstate.udirection.z,
        curstate.ldirection.x,curstate.ldirection.y,curstate.ldirection.z,
        curstate.length, curstate.thickness);
}

void sprint_curstate(char *buffer){
          sprintf(buffer,"Last Symbol Interpreted: %c\n"
              "Last Turtle State:\n"
              "angle=%f,\nx=%f, y=%f, z=%f\n"
              "fdirection.x=%f, fdirection.y=%f, fdirection.z=%f,\n"
              "udirection.x=%f, udirection.y=%f, udirection.z=%f,\n"
              "ldirection.x=%f, ldirection.y=%f, ldirection.z=%f,\n"
              "length=%f, thickness=%f\n",
              (char)prevchar,
              curstate.deltaangle,curstate.x,curstate.y,curstate.z,
              curstate.fdirection.x,curstate.fdirection.y,curstate.fdirection.z,
              curstate.udirection.x,curstate.udirection.y,curstate.udirection.z,
              curstate.ldirection.x,curstate.ldirection.y,curstate.ldirection.z,
              curstate.length, curstate.thickness);
}
int nonumber_p=0;
char *inptr;
int interpret (int mode){
/*
call interpret(mode) twice:
mode==0 -> just go through and find limits, number of objects, etc.
mode==1 -> actually draw and make midi lists
*/
     int i;
     VECTOR u,v;
     VECTOR df,du,dl;
     float x,y,z;

     float dang;
     float length;
     int transpose;
     int mapnumber;
     float dfact,vfact;
     float lscale;
     int clr;
     float maxrandomturn;
     float xturn,yturn,zturn;
     char thischar;
     int track;
     long holdtime;
     int interpretret=INTERPRETOK;
     int firstdraw=1;
     setmapto(0);


     LOCK_FUNCTION(arithmeticerrorhandler);

     signal(SIGFPE, arithmeticerrorhandler);

     for(i=0;i<MAXTRACKS;i++){
        trackcumtime[i]=0L;
        trackprevcumtime[i]=0L;
     }
     if(mode==1){

       if(checkvariablewidths()<0){

                return INTERPRETARITHERRORINF;

        }
     }
     df.x = 0; df.y = 1; df.z = 0;
     du.x = 1; du.y = 0; du.z = 0;
     dl.x = 0; dl.y = 0; dl.z = 1;

     curstate.deltaangle=deltaanglerad;
     curstate.x = 0; curstate.y = 0; curstate.z = 0;
     curstate.fdirection = df;curstate.udirection = du; curstate.ldirection = dl;
     curstate.length = 10; curstate.clr = 0; curstate.thickness = thick;
     curstate.track=0;curstate.cumtime=0L;curstate.prevcumtime=0L;
     curstate.transpose=0;   curstate.dfact=1.0; curstate.vfact=1.0;
     curstate.inpoly=0;
     curstate.mymap=&maps[0];
     curdrawlength=10;
     maxcumtime=0L;
     stacktop = 0;

     inptr=production;
     curchar = *inptr++;

     while( curchar != '\0'){
        x = curstate.x; y = curstate.y; z = curstate.z;
        pitchvariable=*(curstate.mymap->pitch);
        durationvariable=*(curstate.mymap->duration);
        velocityvariable=*(curstate.mymap->volume);
        pspread=curstate.mymap->pspread;
        dspread=curstate.mymap->dspread;
        vspread=curstate.mymap->vspread;
        dmultiplier=curstate.mymap->dmultiplier;
        cur_scale=&(curstate.mymap->scale);
        scalefn=curstate.mymap->scalefn;
        if(isinf(x)||isinf(y)||isinf(z)||isinf(curstate.length)||isinf(curstate.thickness)){
               sprint_curstate(curstatestring);
               return INTERPRETARITHERRORINF;
        }

        prevchar=curchar;
        switch(curchar){

                 case 'F':
                 case 'f':
                 case 'g':

                        thischar = curchar;
                        length = getfloat();
                        if(length <= 0)
                            length = curstate.length;

                        curstate.x = curstate.x + length * (curstate.fdirection.x);
                        curstate.y = curstate.y + length * (curstate.fdirection.y);
                        curstate.z = curstate.z + length * (curstate.fdirection.z);
                        curdrawlength=length;
                        if(mode == 0){
                                if(thischar == 'F'|| (curstate.inpoly == 1 && thischar != 'g'))  numobjects++;
                                if(firstdraw){
                                    initvariablelimits();
                                    firstdraw=0;
                                }
                        }

                        else if( mode == 1){
                                if(thischar == 'F' || (curstate.inpoly == 1 && thischar != 'g')){
                                     insertpatchandnote(curstate.track);

                                     if(draw_p){
                                        drawline(x,y,z,length * curstate.fdirection.x,length * curstate.fdirection.y,length * curstate.fdirection.z,curstate.clr );
                                     }

                                }
                                else {
                                    inserttracknote(curstate.track,0);
                                }
                        }
                        break;
                 case 'Z':
                 case 'z':
                        thischar = curchar;
                        length = getfloat();
                        if( length <= 0)
                                length = curstate.length;
                        else length = 2 * length;
                        curdrawlength=length/2;
                        curstate.x = curstate.x + length / 2 * (curstate.fdirection.x);
                        curstate.y = curstate.y + length / 2 * (curstate.fdirection.y);
                        curstate.z = curstate.z + length / 2 * (curstate.fdirection.z);

                        if( mode == 0){
                                if(thischar == 'Z'|| (curstate.inpoly == 1 && thischar != 'g'))  numobjects++;
                                if(firstdraw){
                                    initvariablelimits();
                                    firstdraw=0;
                                }
                        }
                        else if( mode == 1){
                               if(thischar == 'Z' || curstate.inpoly == 1){
                                      insertpatchandnote(curstate.track);

                                      if(draw_p){
                                        drawline(x,y,z,length/2 * curstate.fdirection.x,length/2 * curstate.fdirection.y,length/2 * curstate.fdirection.z,curstate.clr );
                                      }

                                }
                                else{
                                   inserttracknote(curstate.track,0);
                                }
                        }
                        break;
                 case '$':
                        curchar = *inptr++;
                        if( curstate.fdirection.x != 0 && curstate.fdirection.z != 0){
                                cross(&(curstate.fdirection), &sky, &(curstate.ldirection));
                                cross(&(curstate.fdirection), &(curstate.ldirection),&(curstate.udirection));
                        }
                        break;
                 case '|':
                        curchar = *inptr++;
                        curstate.fdirection.x = -curstate.fdirection.x;
                        curstate.fdirection.y = -curstate.fdirection.y;
                        curstate.fdirection.z = -curstate.fdirection.z;
                        curstate.ldirection.x = -curstate.ldirection.x;
                        curstate.ldirection.y = -curstate.ldirection.y;
                        curstate.ldirection.z = -curstate.ldirection.z;
                        break;
                case '%':
                        curchar = *inptr++;
                        curstate.udirection.x = -curstate.udirection.x;
                        curstate.udirection.y = -curstate.udirection.y;
                        curstate.udirection.z = -curstate.udirection.z;
                        curstate.ldirection.x = -curstate.ldirection.x;
                        curstate.ldirection.y = -curstate.ldirection.y;
                        curstate.ldirection.z = -curstate.ldirection.z;
                        break;
                 case '+':
                        dang = getfloat();
                        if (dang != 0 ){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                        
                 case '-':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, -dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, -dang);
                                curstate.udirection = v;
                        }
                        else{
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, -curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, -curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;

                 case '&':
                        dang = getfloat();
                        if(dang != 0){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, dang);
                                curstate.ldirection = v;
                        }                                
                        else {
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, curstate.deltaangle);
                                curstate.ldirection = v;
                        }
                        break;
                 case '^':
                        dang = getfloat();
                        if( dang != 0){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, -dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, -dang);
                                curstate.ldirection = v;                                
                        }
                        else{
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, -curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, -curstate.deltaangle);
                                curstate.ldirection = v;
                        }
                        break;
                 case '<':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, dang);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, curstate.deltaangle);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                 case '>':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = DEG2RAD(dang);
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, -dang);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, -dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, -curstate.deltaangle);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, -curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                 case ';':
                        dang = getfloat();
                        if(dang == 0 ) dang = 1 / deflscale;
                        curstate.deltaangle = curstate.deltaangle * dang;
                        /*if(deltaanglerad>TWOPI)deltaanglerad -= TWOPI;*/
                        break;
                 case ':':
                        dang = getfloat();
                        if (dang == 0) dang = deflscale;
                        curstate.deltaangle = curstate.deltaangle * dang;
                        /*if(curstate.deltaangle>TWOPI)curstate.deltaangle -= TWOPI;*/
                        /*if(curstate.deltaangle<FPZERODIF) curstate.deltaangle=TWOPI;*/
                        break;
                 case '[':
                 case '{':

                        if( stacktop >= STACKDEPTH-1){

                                return (INTERPRETSTACKOVERFLOW);
                        }
                        pushstate(curstate);

                        if (curchar == '{'){

                                track=getfloat();
                                if(track>0)
                                    curstate.track=track-1;
                                else{

                                    curstate.track=(curstate.track+1)%MAXTRACKS;
                                }
                                curstate.inpoly = 1;
                        }
                        else {
                          curchar = *inptr++;
                        }


                        break;
                case ']':
                case '}':

#ifdef STACKUNDERFLOWABORT
                        if(stacktop<0) return(INTERPRETSTACKUNDERFLOW);
#endif
                        if(curchar==']'){
                            holdtime=curstate.cumtime;
                            curstate = popstate();
                            curstate.cumtime=holdtime;
                        }
                        else if(curchar == '}'){
                              curstate = popstate();
                        }
                        curchar = *inptr++;
                        break;
                case '\\':
                        if(timestacktop<STACKDEPTH-1)
                                  pushtime(curstate.cumtime);

                        track=(int)getfloat();

                        if(track>0)
                            curstate.track=track-1;


                        break;

                case '/':
                        curstate.cumtime=poptime();
                        curchar = *inptr++;
                        break;
                case 'c':
                        clr = (int)(getfloat());
                        if( clr > 0)
                                curstate.clr = clr;
                        else curstate.clr = (curstate.clr + 1) % (maxcolor) + 1;
                        break;

                case '*':
                        track=(int)getfloat();

                        if(track>0)
                            curstate.track=track-1;


                        break;
        
                case '\'':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.length = lscale * curstate.length;
                        else
                                curstate.length = deflscale * curstate.length;
                        break;
                case '!':
                        lscale = getfloat();
                        if(lscale > 0)
                                curstate.thickness = lscale * curstate.thickness;
                        else
                                curstate.thickness = .7 * curstate.thickness;
                        break;
                case '?':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.thickness = lscale * curstate.thickness;
                        else
                                curstate.thickness = 1.0 / .7 * curstate.thickness;
                        break;

                case '"':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.length = lscale * curstate.length;
                        else
                                curstate.length = 1.0 / deflscale * curstate.length;
                        break;

                case '~':
                        maxrandomturn = getfloat();
                        maxrandomturn = PI * maxrandomturn / 180.0;
                        if( maxrandomturn > 0){
                                xturn = maxrandomturn - 2 * RND * maxrandomturn;

                                xrot(&(curstate.fdirection), &u, xturn);
                                curstate.fdirection = u;
                                xrot(&(curstate.udirection), &u, xturn);
                                curstate.udirection = u;
                                xrot(&(curstate.ldirection), &u, xturn);
                                curstate.ldirection = u;
                               
                                yturn = maxrandomturn - 2 * RND * maxrandomturn;

                                yrot(&(curstate.fdirection), &u, yturn);
                                curstate.fdirection = u;
                                yrot(&(curstate.udirection), &u, yturn);
                                curstate.udirection = u;
                                yrot(&(curstate.ldirection), &u, yturn);
                                curstate.ldirection = u;

                                zturn = maxrandomturn - 2 * RND * maxrandomturn;

                                zrot(&(curstate.fdirection), &u, zturn);
                                curstate.fdirection = u;
                                zrot(&(curstate.udirection), &u, zturn);
                                curstate.udirection = u;
                                zrot(&(curstate.ldirection), &u, zturn);
                                curstate.ldirection = u;
                        }
                        else{                               

                                xturn = 2 * RND * PI;

                                xrot(&(curstate.fdirection), &u, xturn);
                                curstate.fdirection = u;
                                xrot(&(curstate.udirection), &u, xturn);
                                curstate.udirection = u;
                                xrot(&(curstate.ldirection), &u, xturn);
                                curstate.ldirection = u;
                                yturn = 2 * RND * PI;

                                yrot(&(curstate.fdirection), &u, yturn);
                                curstate.fdirection = u;
                                yrot(&(curstate.udirection), &u, yturn);
                                curstate.udirection = u;
                                yrot(&(curstate.ldirection), &u, yturn);
                                curstate.ldirection = u;
                                zturn = 2 * RND * PI;

                                zrot(&(curstate.fdirection), &u, zturn);
                                curstate.fdirection = u;
                                zrot(&(curstate.udirection), &u, zturn);
                                curstate.udirection = u;
                                zrot(&(curstate.ldirection), &u, zturn);
                                curstate.ldirection = u;
                        }
                        break;
                case 'm':
                        mapnumber=(int)getfloat();
                        mapnumber %= MAXMAPS;
                        curstate.mymap=&(maps[mapnumber]);
                        break;
                case 't':
                        transpose=getfloat();
                        curstate.transpose=transpose;
                        break;
                case 'd':
                        dfact=getfloat();
                        if(dfact<=0.0)
                            curstate.dfact=1.0;
                        else{
                            curstate.dfact=dfact;
                        }
                        break;
                case 'v':
                        vfact=getfloat();
                        if(vfact<=0.0)
                            curstate.vfact=1.0;
                        else{
                            curstate.vfact=vfact;
                        }
                        break;

                case 'T':
                        transpose=getfloat();
                        if(transposestack_p){

                            if(transpose==0) curstate.transpose=poptranspose();
                            else{
                              if(transposestacktop<STACKDEPTH-1)
                                  pushtranspose(curstate.transpose);
                              curstate.transpose+=transpose;
                            }
                        }
                        break;
                
                case 'D':
                        dfact=getfloat();
                        if(factstacks_p){

                            if(dfact<=0.0) curstate.dfact=popdfact();
                            else{
                              if(dfactstacktop<STACKDEPTH-1)
                                  pushdfact(curstate.dfact);
                              curstate.dfact*=dfact;
                            }
                        }
                        break;
                case 'V':
                        vfact=getfloat();
                        if(factstacks_p){

                            if(vfact<=0.0) curstate.vfact=popvfact();
                            else{
                               if(vfactstacktop<STACKDEPTH-1)
                                  pushvfact(curstate.vfact);
                               curstate.vfact*=vfact;
                            }
                        }
                        break;
                case '(':
                        getfloat();
                        break;
                default:
                        curchar = *inptr++;
        }/*end switch*/
        if(mode==0)
               getvariablelimits();
        if(curstate.cumtime>maxcumtime)
               maxcumtime=curstate.cumtime;

        if( esc_or_right_mouse_button_pressed()){

              interpretret=INTERPRETABORT;
              break;

        }

     }

     signal(SIGFPE, SIG_DFL);

     return (interpretret);
}

float  getfloat(){
        int inparen=0;
        char buf[80]="";
        char *bptr=buf;
        float ret;
        nonumber_p=0;
        curchar = *inptr++;

        if(curchar == '(' ){
                curchar = *inptr++;
                if( curchar == '-' ||  curchar == '+'){
                /* + and - only allowed if the number is in parentheses
                   since + and - are special lsystem characters*/

                        *bptr=curchar;
                        bptr++;
                        curchar = *inptr++;
                }
                inparen = 1;
        }
        while( (curchar>='0' && curchar<='9') || curchar=='.' || curchar== ')'){

                *bptr = curchar; bptr++;
                curchar = *inptr++;
        }
        if(*buf=='\0')
            nonumber_p=1;
        ret=atof(buf);
        return ret;

}

