(* Convert to Deskmate Sound, version 1.98      PUBLIC DOMAIN
   Kenneth Udut
   January 14 - 27, 1993

   PURPOSE:  This program converts any regular digitized sound into a
   DeskMate Sound file.  It will allow you to use Deskmate's SOUND program
   to edit these files.

   My thanks to Christopher Taveres for his program SOUNDOFF, written for
   the Tandy 1000 SL/TL machines to play digitized sounds.  I do hope he
   doesn't mind me borrowing his DeskMate .SND file structure information,
   but I am new at this file distribution thing.

----------------------------------------
DeskMate .SND file structure thanks to:
/* Sound Off!
/* Written by Christopher Taveres 
/* Copyright (c) January 1992
/* Falsoft, Inc.
/* PCM
----------------------------------------

   This program is 100% public domain.  Use it as you will, play with the
   source code, use the source code, and even ask money for your revised
   versions of it!

   Just give me a BIG THANKS and, if you don't wish to FREELY distribute
   YOUR source code, -please- make it available for others for a SMALL fee.

   Thanks!                            --Kenneth Udut, age 20, 14-JAN-1993

P.S. - This is Ken on 24-JAN-1993.  Creating a header in TP wasn't the answer,
       so I'm going to attempt to just write the bytes for the header directly.
       Wish me Luck!

P.P.S. - Ken again, on the day before his birthday.  It's 27-JAN-1993, and
         I *should* be going to work.  I've decided to release this program
         *NOW*, in its current form.

         Needed improvements:

            * Ability to change playback rate (in next version)

            * Accurate method of writing the filesize in the header.
              (currently, it's a close approximation, but you still
              have to manually cut off a couple of samples at the end)

              NOTE: Files 255 bytes or under change PERFECTLY!  :-)

            * DeskMate Interface (okay - wishful thinking, but if I can
              find someone with the SDK, I might ask them to do me a BIG
              favor!!!

            * Ability to cut off the old header, if one, before adding
              on the new header.

            * Ability to switch back and forth between DIFFERENT sound
              file types, including DeskMate's, WAV files, etc.

            * Ability to decode Instrument files into their separate parts.

  While this is just a wish list, and the only NEEDED one is the accurate
  method of encoding sound file size, and possibly the playback rate, it's
  still things to look forward to.

  If you like what you see, or don't like it, or think it needs BIG help,
  give me a call at (908) 241-6246, or write me a note at:

  Kenneth Udut 170 East Clay Avenue, Roselle Park, NJ USA 07204-2050
  Internet: kudut@hamp.hampshire.edu
  PC-Link/America Online: K Udut
  CompuServe: INTERNET> kudut@hamp.hampshire.edu
  Delphi: kudut@hamp.hampshire.edu

  If you're in New Jersey, and want to stop by my 'workshop', please do!
  I'll have a pot of tea or coffee waiting for you, and we can sit down
  and chat!  (Just give me a call first or leave me a note!  Thanks! :D )

                      --Ken, on January 27, 1993, day before 21st birthday!


THIS IS THE STRUCTURE AS I RECEIVED IT.  AS I KNOW -NOTHING- ABOUT C, THIS
IS GOING TO BE A *BIT* OF A CHALLENGE, BUT, SINCE I DON'T KNOW MUCH ABOUT
PASCAL EITHER, LIFE SHOULD BE A LITTLE SIMPLER!

struct dmheader {                  /* Structure of the header block      */
       INT marker;                 /* Marker bytes - should be 00 1a     */
       CHAR note_count;            /* Number of notes in instrument file */
       CHAR inst_num;              /* Instrument number                  */
       CHAR inst_name[10];         /* Instrument name                    */
       INT sample_rate;            /* Sampling rate                      */
       CHAR filler[16];            /* I don't know what this does        */
       unsigned long sample_size;  /* Number of samples in file          */
       CHAR filler2[8];            /* More unknown space                 */
*)


{pseudo-program - 'cause it seems to help program development!

    define deskmate sound header.
    start program.
    print_banner;   (* glory lines *)

    IF no command_line_parameters THEN message1 ELSE BEGIN
       search for file listed in command_line_parareter.
       IF file doesn't exist THEN message2
       check file length;
       sample_size := file length - # of bytes in header.
       sample_rate := fixed rate or another command line parameter.

       open new file called DM_SOUND.SND for writing
       add header to beginning of DM_SOUND.SND
       open FILENAME.SOU for reading
       add FILENAME.SOU to end of DM_SOUND.SND
       CLOSE FILENAME.SOU
       CLOSE new file.

       report success or failure in operation;
       say our goodbyes;
       print_end_banner;

    print_banner:
    WRITELN('xxx program by Kenneth Udut');

    message1:
    WRITELN('You must specify xxx arguements');
    print_end_banner;

    message2:
    WRITELN('file xxx doesn't exists');
    print_end_banner;

    print_end_banner:
    WRITELN('write the author xxxxxx');
    halt;
    END.

}




        (* THE REAL PROGRAM NOW FOLKS!!! HOLD ON TO YOUR HATS! *)




PROGRAM DM_Sound_Cnv;

USES Dos, Crt;

CONST
      dm_soundfile = 'DM_SOUND.SND';
      z = CHR(0);                     {saves typing, 24-JAN-1993}

VAR header : STRING;
    sample_size : LONGINT;
    sample_rate : BYTE;       {merely carries indication of which size it is}
    sound_name  : string[10]; {Name that appears in DeskMate SOUND.PDM}
    human_name  : string;     {for silliness.}

PROCEDURE Perm; assembler;
ASM
   JMP @@1
   DB 13,10,13,10,13,10,13,10,'03-FEB-1993 by Kenneth Udut.  Always 100% Public Domain.',13,10
   DB 13,10,'adonis_note: CONVERTS RAW DIGITIZED SOUNDS TO DESKMATE .SND FORMAT',13,10,13,10,13,10,13,10
@@1:
END;


PROCEDURE start_banner;
BEGIN
     WRITELN('CONV2SND - Version 1.98, by Kenneth Udut, February 3, 1993 - Public Domain');
     WRITELN('           Converts "other" digitized sound formats to DeskMate .SND format');
     WRITELN('           for use with the DeskMate SOUND.PDM program for editing purposes!');
     WRITELN;
     WRITELN('           Syntax: CONV2SND ROCKY.VOC, where ROCKY.VOC is *any* digitized sound');
     WRITELN('_______________________________________________________________________________');
END;


PROCEDURE end_banner;
BEGIN
   WRITELN('_______________________________________________________________________________');
   WRITELN('Catch ya later, my friend!  Drop me a note, ',human_name,', - I promise I''ll reply!');
   WRITELN;
   WRITELN('Kenneth Udut, 170 East Clay Avenue, Roselle Park, NJ 07204-2050');
   WRITE('kudut@hamp.hampshire.edu     908/241-6246     February 3, 1993');
   halt;
END;



PROCEDURE check_command_line;
BEGIN
  IF ParamCount <> 1 THEN BEGIN
    WRITELN('You have specified either NO filenames, TOO MANY filenames, or tried switches.');
    WRITELN('Since this program only asks for one (1) filename, then all you need to do is:');
    WRITELN;
    WRITELN('   If the sound file you wish to convert is called BULLWINK, simply type ... ');
    WRITELN('   CONV2SND BULLWINK ');
    WRITELN;
    WRITELN('First, CONV2SND creates a little 44 byte "header" which contains the info ');
    WRITELN('that DeskMate SOUND.PDM needs to consider this file a DeskMate .SND file.');
    WRITELN;
    WRITELN('A new, empty file is created called DM_SOUND.SND.  The header is copied to');
    WRITELN('the beginning of this file.  Then the contents of BULLWINK are read and');
    WRITELN('copied into DM_SOUND.SND, right after that all-important header.');
    WRITELN;
    WRITELN('Lastly, the files are safely closed, and you have two files: BULLWINK and');
    WRITELN('DM_SOUND.SND.  RENAME DM_SOUND.SND TO BULLWINK.SND FOR CLARITY!');
    WRITELN;
    WRITELN('NOTE: THE SIZE OF THE FREE SPACE ON YOUR DISK MUST BE THE SIZE OF THE FILE ');
    WRITELN('      TIMES 2.  IN OTHER WORDS, A 100k FILE NEEDS 200k FREE SPACE TO CONVERT.');
end_banner
END;

END;


PROCEDURE NOT_HERE;
BEGIN
     WRITELN;
     WRITELN('The file you specified, "',ParamStr(1),'", doesn''t seem to be present.');
     WRITELN('Please check your spelling, maybe do a DIR/W a couple of times, fiddle');
     WRITELN('around a wee bit and give it another shot };-> ');
     WRITELN;
     WRITELN('adonis_note: Time is a great teacher, but unfortunately kills all its pupils.');
end_banner;
END;



(****************** WISH ME LUCK *********************)
(*                                                   *)
(* This is the portion where I attempt to convert a  *)
(* regular sound file into an extra-special DESKMATE *)
(* SND FILE!  It's the last part of the program for  *)
(* me to write, as I was having too much fun procras *)
(* tinating, making up the text and such!            *)
(*                                                   *)
(*****************************************************)
PROCEDURE convert_file;

VAR
  old_snd_file : FILE;
  new_snd_file : FILE;
  header_part  : TEXT;
  samp_char_1  : CHAR;  { three characters that will make up sample rate in file}
  samp_char_2  : CHAR;  { Watch for funky math coming up! }
  samp_char_3  : CHAR;

  NumRead, NumWritten: Word;    {for BLOCKREAD and BLOCKWRITE}
  buf: array[1..2048] of Char;

BEGIN

ASSIGN(old_snd_file, ParamStr(1));
RESET(old_snd_file, 1);
sample_size := FileSize(old_snd_file);
WRITELN;
WRITELN('Hey, ',human_name,'?  ',paramstr(1), ' contains ',sample_size,' samples.');
WRITELN;
ASSIGN(header_part, dm_soundfile);
REWRITE(header_part);

(*Writing part - wish me luck here!  I will write the header, close the
  file, then reopen it as a -plain- file! *)

{ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . }

(* 24-JAN-1993 - Uh oh!  I'm going to try to write the header file bit by bit!
   Let's see if it really works!  Creating a "file of record" didn't work. *)

WRITE(header_part, CHR(26), z, CHR(1), z);

(* 03-FEB-1993 - Attempting to let you add a 10-character 'description' of
   the sound file - the one that appears in the right hand box in SOUND.PDM *)

WRITE(header_part, sound_name);

(* 24-JAN-1993 - Next two bits I *BELIEVE* are the sampling rate, and I
   can't quite be sure yet.  For future use, I'm keeping these lines
   separate so that it's easier to find where it goes  Ver 1.77*)
(* 03-FEB-1993 - Turns out that they ARE the sampling rate!  Now, it's changeable! *)

CASE sample_rate of
     1: WRITE(header_part, CHR(124), CHR(21));     {5500}
     2: WRITE(header_part, CHR(248), CHR(42));     {11000}
     3: WRITE(header_part, CHR(240), CHR(85));     {22000}
END;

WRITE(header_part, CHR(255), z, CHR(255), CHR(255), z, z, z, z, z, z, z, z, z, z, z, z);


(* SAMPLE SIZE COMING UP!  I HOPE IT WORKS!  IT'S OF ULTIMATE IMPORTANCE! *)
samp_char_1 := z;
samp_char_2 := z;    {remember:  Z is CHR(0) }
samp_char_3 := z;


IF sample_size < 256 THEN samp_char_1 := CHR(sample_size)
   ELSE BEGIN
        IF sample_size < 65536 THEN
           BEGIN
             samp_char_1 := CHR(sample_size div 256);
             samp_char_2 := CHR((sample_size div 256) + 1);
             samp_char_3 := z
           END
     ELSE
        BEGIN
        samp_char_1 := CHR(sample_size div 65536); {These three get multiplied together for the}
        samp_char_2 := CHR(sample_size div 65536); {final result! - neat!  27-JAN-1993}
        samp_char_3 := chr((sample_size div 65536) + 1);
        END;
     END;

WRITE(header_part, samp_char_1, samp_char_2, samp_char_3);

WRITE(header_part, z, z, z, z, z, z, z, z, z);

{ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . }
CLOSE(header_part);

ASSIGN(new_snd_file, dm_soundfile);
RESET(new_snd_file, 1);
SEEK(new_snd_file, filesize(new_snd_file)+1);

WRITELN('All Important 44 byte header portion successfully written to ',dm_soundfile,'!');
WRITELN;
WRITELN('Now adding old digitized sound file to new, DeskMate format sound file.');
WRITELN('Each ">" equals 2048 sound bytes.');

REPEAT
  BLOCKREAD(old_snd_file,buf,
            SizeOf(buf),NumRead);
  BLOCKWRITE(new_snd_file,buf,NumRead,NumWritten);
  WRITE('>');
UNTIL (NumRead = 0) OR
      (NumWritten <> NumRead);

WRITELN;
CLOSE(old_snd_file);
CLOSE(new_snd_file);
WRITELN;
WRITELN('safely closing ',ParamStr(1), ' and ',dm_soundfile,'.');
END;


procedure ask_questions;      {02-FEB-93 - for sample rate}
BEGIN
sample_rate := 0;
sound_name := '';
human_name := '';
WRITELN;
WRITELN('______Q_U_E_S_T_I_O_N_S______');
WRITELN('                                       _________________________________ ');
WRITELN('A) Select Sampling Rate.              / Sample Rate is an indication of \');
WRITELN('                                      \ the rate at which SOUND.PDM  or /');
WRITELN('   1) 5500  -  ''speech''               / or other  DeskMate .SND players \');
WRITELN('   2) 11000 -  ''usual recordings''     \ reads and plays back  the sound /');
WRITELN('   3) 22000 -  ''hi-quality / Mac''      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ');
WRITELN;
WRITE(CHR(7));
WHILE (sample_rate < 1) OR (sample_rate > 3) DO
      BEGIN
      WRITE('Please Select 1, 2, or 3. > ');  READLN(sample_rate);
      END;
WRITELN;
WRITELN;
WRITELN('                                       _________________________________ ');
WRITELN('B) Select Name of  Sound              / "Name of Sound" *isn''t* the name\');
WRITELN('   10 Characters or Less              \  of the file being created.  It /');
WRITELN('                                      /  It is the  name  that  appears \');
WRITELN('   Example: Disgusting  or            \  in SOUND.PDM next to "Name:"   /');
WRITELN('            Eastwood                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ');
WRITE(CHR(7));
WHILE sound_name = '' DO
       BEGIN
       WRITE('Name / Description of Sound (10 Characters or Less) > ');  READLN(sound_name);
       END;

{pads string to 10 characters -- 03-FEB-1993}
while length(sound_name) < 10 do  
insert(chr(0),sound_name, (length(sound_name)+1));

WRITELN;
WRITELN;
WRITELN('C) Oh, and by the way ...');
WRITELN('   My name is Ken.  What''s your name?');
WRITELN;
WRITE(CHR(7));
WHILE human_name = '' DO
      BEGIN
      WRITE('Your Name? > ');  READLN(human_name);
      END;
WRITELN;
WRITELN('Thanks for answering my questions!  Now ,',human_name,', here goes CONV2SND!!!');
WRITELN;
END;


function FileExists(FileName: STRING)
                                : Boolean;
{ Returns True IF file exists; otherwise,
  it returns False. }

VAR
  f : file;
BEGIN
  {$I-}
  ASSIGN(f, FileName);
  RESET(f);
  CLOSE(f);
  {$I+}
  FileExists := (IOResult = 0) and
   (FileName <> '');
END;  { FileExists }



BEGIN
Perm;
start_banner;
human_name := '!';
check_command_line;   {if a problem occurs, it's taken care of in this procedure}
     IF NOT (FileExists(paramstr(1))) THEN NOT_HERE;

ask_questions;
convert_file;

WRITELN(paramstr(1),' has been successfully converted into a DeskMate Sound file');
WRITELN('100% editable by DeskMate''s Sound Editor!!!  Congratulations, ',human_name,'!!!');
WRITELN;
WRITELN('adonis_note: Life is a funny game ... some people play ... some people main');
WRITELN('             (beginning of a famous poem, spoken to me by my Tandy 1000 TL');
WRITELN;
end_banner;
END.
