; DEMODEMO.CTL
; Showing some of the features of The DEMO System
; If you recompile, you might want to specify /Q since the noise can
; get pretty annoying.

- (ONCE)
LOADLOGO ^UBatSymbol^ 3
DATA 221,0,24,28,60,62,63,127,127,127,255,255,255,239,206,132,128
DATA 222,66,126,126,126,126,255,255,255,255,255,255,255,255,126,60,24
DATA 224,0,24,56,60,124,252,254,254,254,255,255,255,247,115,33,1
; NOTE:  In order to prevent deblanking, the first character after ^UWx^ is
; a space followed by Alt-254, which shows up as a blank.
assign ^UW1^                                                              
assign ^UW2^                                                               
assign ^UW3^                        
assign ^UW4^                  ߱ ۱۱  
assign ^UW5^                          ۱۱    
assign ^UW6^                           ߱     
assign ^UW7^                  
assign ^UW8^                           

- (SET1) Defaults for full-screen functions
KEY (HOME)         FIELD FIRST
KEY (UP),(LEFT)    FIELD -1
KEY (DOWN),(RIGHT) FIELD +1
KEY (END)          FIELD LAST

; Establishing a macro here that displays "Welcome!" once and then
; pauses.  Repeat this from different locations and it should look
; a bit like a flowing message.
MACRO Welcome
LOCATE &1 1
ECHO ^UW1^
ECHO ^UW2^
ECHO ^UW3^
ECHO ^UW4^
ECHO ^UW5^
ECHO ^UW6^
ECHO ^UW7^
ECHO ^UW8^@
PAUSE .1
MEND

- *MENUW    Welcome
SET BASE 1
DO Welcome 18
CLS
DO Welcome 15
CLS
DO Welcome 12
CLS
DO Welcome 9
CLS
DO Welcome 6
CLS
DO Welcome 3
CLS
DO Welcome 1
; Dummy page just to have something here
/.

./

- (GLOBAL)
SET MOUSE ON
SET LOGO ^P25,1^C4Press F10 for popup menu^P25,39^C2^UBatSymbol^^C4What ^C1is^C4 The DEMO System?
KEY (ESC) POP               /* Pop back to previous screen
KEY (A-C) CALL @MAINFH      /* Toggle from color to monochrome set
KEY (MOUSER),(MOUSEL) POP   /* Either mouse button counts as an escape
                            /* unless specified elsewhere
KEY (F10) POPUP ^Popup      /* Bring up a global popup menu when requested.

/* 
- *000 Central menu
SET TOP
SET CURSOR ^C2-->
SET KEYS (SET1)
SET MOUSE ON
KEY (MOUSER),(MOUSEL) SELECT
KEY A,@1        CALL *MAINA              /* What is it?
KEY B,@2        CALL *MAINB              /* What would you use it for?
KEY C,@3        CALL *MAINC              /* Concepts and descriptions of features
KEY D,@4        CALL *MAIND              /* How to create the screens?
KEY E,@5        CALL *MAINE              /* Show me a control file
KEY F,@6        CALL *MAINF              /* Demo of features
KEY G,@7        CALL *MAING              /* Registration
KEY X,@8,(ESC)  GOTO @QUIT               /* Quit demo
/.
This subsystem shows the various features of The DEMO System.  See which:

             ^K   A. What is The DEMO System?
             ^K   B. Why would you use it?
             ^K   C. Concepts and descriptions of features
             ^K   D. How are the input screens created?
             ^K   E. Show me a control file
             ^K   F. Demoes showing the features
             ^K   G. Registration

             ^K   X. Quit demo

./

/* 
- *MAINA What is The DEMO System?
KEY X,(ESC) POP KEY2
/.
^C1                            What is The DEMO System?                            ^C0

The DEMO System is a tool which defies easy classification.

At its simplest level, The DEMO System allows the user to navigate through a
series of screens.  These screens are all text screens, easily created using any
text editor.  Screens are typically full screen but they can also be partial,
overlapping what's already on the screen.  The DEMO System allows you to define
commands to be executed at any point during the navigation.

This doesn't intuitively sound useful, does it?  However, when you think about
it, much of what the average user does is wind his or her way through screens,
filling out forms, selecting programs, etc.  The DEMO System allows you to
create menus for them.  It also allows you to create demonstrator software,
installation software, data-entry forms, help systems, etc.








Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

/* 
- *MAINB What would you use it for?
KEY X,(ESC) POP KEY3
KEY (PGDN) GOTO *MAINB2
/.
^C1                     What would you use The DEMO System for?                    ^C0

Oh!  Lots of things!  Consider:
  * ^C1Demo software^C0.  A system to demonstrate some technical screen-oriented
application.  You can create a demo that the user can run without needing any of
the hardware that the application itself might require; no need for 210MB hard
disk, fast CPU, CD-ROM, modem, etc.  Want to set up something to show people how
to use your bulletin board?  Want to explain how to wind your way through your
Novell network menus?  Want to show people how to install your CD-ROM software?
The DEMO System can do it all!
  * ^C1Tutorials^C0.  Set up a menu-driven learning course that explains the
highlights of a program.  (This DEMODEMO program was, of course, written using
The DEMO System.)
  * ^C1Help systems^C0.  Want to keep a file handy that explains all of the basic
concepts in your system?  You can set up a series of text screens, with
hypertext capabilities if desired, to save yourself some time on the phones.
  * ^C1Menuing systems^C0.  Want to create your own AUTOMENU program?  The DEMO System
includes direct access to many DOS commands and lets you invoke any other ones
you need as well through a shell command.

Continued...

Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
Press ^C1PgDn^C0 to see the next screen of reasons.
./

- *MAINB2 What would you use it for?
KEY X,(ESC) POP KEY3
KEY (PGUP) GOTO *MAINB
/.
^C1              What would you use The DEMO System for? (continued)               ^C0

Where were we?  Oh yeah!  More reasons:

  * ^C1Data-entry forms^C0.  Want to have someone create a message of records by
filling out a data-entry form and you don't have time to write it all using a
DBMS?  Consider using The DEMO System!
  * ^C1Installation programs^C0.  Want to create a system that you can use to install
another system?  There's an example of doing this in The DEMO System docs!
  * ^C1Slide shows^C0.  Want to set up a list of GIF's that someone can view and have
them select the one they want to view?  The DEMO System makes this easy.

This demo includes samples of most of these capabilities.









Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
Press ^C1PgUp^C0 to see the previous screen.
./

/* 
- *MAINC Concepts and descriptions of features
SET KEYS (SET1)
SET CURSOR ^C2(^T2)
KEY A,@1 CALL *MAINCA  /* Types of pages
KEY B,@2 CALL *MAINCB  /* SET commands
KEY C,@3 CALL *MAINCC  /* Action commands
KEY D,@4 CALL *MAINCD  /* Types of variables
KEY E,@5 CALL *MAINCE  /* Functions
KEY F,@6 CALL *MAINCF  /* KEY commands
KEY G,@7 CALL *MAINCG  /* Compilation vs viewing
KEY H,@8 CALL *MAINCH  /* Color sets
KEY (ESC),X,@9 POP KEY4
/.
^C1                     Concepts and Descriptions of Features                      ^C0

The DEMO System works from a ASCII-text control file.  The creator is forced to
divide commands in logical units called "pages".  Within each page, there can be
SET commands, action commands, KEY commands, and the visible screen itself.

See more information on what:
  ^K A. Types of pages
  ^K B. SET commands
  ^K C. Action commands
  ^K D.   Types of variables
  ^K E.   Functions
  ^K F. KEY commands
  ^K G. Compilation vs viewing
  ^K H. Color sets

  ^K X. Return to previous menu
./

- *MAINCA Types of pages
KEY X,(ESC) POP KEY2
/.
^C1                                 Types of pages                                 ^C0

The basic unit within The DEMO System is the page.  There are several different
types of pages within the system.  These pages can include visible text,
commands, settings, or some combination of the two.  The various types:

Ones with text:
  - filename [ description ]        text is external to the page
  - *ref [ description ]            text is imbedded in the control file
  - ^label row,col title            text shows up as pop-up menu

Without text:
  - @label [ description ]          used for pages with primarily action

Special ones (to set defaults and such):
  - (GLOBAL) [ description ]        establishes defaults for all pages
  - (GLOBALNC) [ description ]      establishes defaults without clearing KEYs
  - (ONCE) [ description ]          commands to execute once
  - (SETn) [ description ]          establishes recallable defaults




Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCB SET commands
KEY X,(ESC) POP KEY3
/.
^C1                                  SET commands                                  ^C0

The DEMO System provides the ability to set certain conditions and defaults at
compilation time.  These can be set for single screens, a series of screens, or
all screens.  They include:

  SET BASE n              Sets the default color parameter for the screen
  SET CASE { ON | OFF }   Whether input case matters
  SET CLS { ON | OFF }    Whether to clear the screen before display
  SET COLOR settings      What colors to use if a color monitor is detected
  SET CURSOR string       What cursor to use for each prompt
  SET KEYS CLEAR          Clears previously defined key assignments
  SET KEYS SETn           Sets screen's keys to match some template
  SET LOGO string         Any text you want displayed on every screen?
  SET MONO settings       What colors to use if a monochrome monitor is
                            used (or simply to provide an alternative color set)
  SET MOUSE { ON | OFF }  Activates mouse support.  Useful for full-screen apps.
  SET SETTINGS CLEAR      Reinitializes screen's default settings
  SET SETTINGS SETn       Sets screen's other settings to match some template
  SET TOP screen          Determine the maximum screen that a use can pop
                            back to


Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCC Action commands
; The listing used for this section comes from the DEMOSYS.DOC manual.
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (MOUSER),(MOUSEL) SELECT
KEY (PGUP) GOTO *MAINCC5
KEY (PGDN) SCREEN +1
KEY X,(ESC) POP KEY4
/.
^C1                                Action commands                                 ^C0

The DEMO System provides several built-in commands that can be used within your
presentation.  These commands can be assigned to keystrokes (for example, maybe
Alt-C invokes the DISPLAY TOGGLE command) or used within pages.

A complete list of the commands follows.  Use PgUp and PgDn to get around the
listing or press X or (ESC) to back out of this menu selection.

        ASSIGN ^^_Uvar^ [ = string ]      /* Assign a value to a user-defined
                                        /* variable
        BEEP                            /* Beep
        BUFFER [ keys ]                 /* Put input characters into a buffer
                                        /* so self-running demoes can be done
        CALL screen [ KEYn | parms ]    /* Call a label or screen, with the
                                        /* intention of returning to the
                                        /* current location
        CD directory                    /* Change to a given subdirectory
        CDD drive:directory             /* Change to a given drive and subdir
        CLOSE                           /* Closes a file opened for input

   ^C1PgUp^C0     Previous page
   ^C1PgDn^C0     Next page
   ^C1Esc^C0 or ^C1X^C0 Pop back to previous menu
./

- *MAINCC2 Action commands (continued)
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (MOUSER),(MOUSEL) SELECT
KEY (PGUP) SCREEN -1
KEY (PGDN) SCREEN +1
KEY X,(ESC) POP KEY4
/.
^C1                          Action commands (continued)                           ^C0

        CLS                             /* Clear the primary screen
        CLSA                            /* Clear the alternate screen
        COPY file1 file2                /* Copy file1 as file2
        DATA data                       /* Provides input data for LOADLOGO
                                        /* Not really an action command in
                                        /* and of itself
        DELETE filename                 /* Delete a specified file
        DISPLAY COLOR                   /* Use SET COLOR color settings
        DISPLAY MONO                    /* Use SET MONO color settings
        DISPLAY TOGGLE                  /* Toggles between COLOR and MONO
        DRIVE letter                    /* Set the default drive
        DROP location                   /* Sets a location for a later HOP
        ECHO [ string[@] ]              /* Display a given string
        ECHOA [ string[@] ]             /* Display a given string to the
                                        /* alternate screen
        FIELD [ TOP | FIRST | -999 to 999 | BOTTOM | LAST | @1 to @99 ]
                                        /* Move to a particular input field


   ^C1PgUp^C0     Previous page
   ^C1PgDn^C0     Next page
   ^C1Esc^C0 or ^C1X^C0 Pop back to previous menu
./

- *MAINCC3 Action commands (continued)
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (MOUSER),(MOUSEL) SELECT
KEY (PGUP) SCREEN -1
KEY (PGDN) SCREEN +1
KEY X,(ESC) POP KEY4
/.
^C1                          Action commands (continued)                           ^C0

        GOTO screen [ KEYn | CLEAR | parms ]
                                        /* Branch to a label or screen,
                                        /* intending to not return to the
                                        /* current screen
        HOP location                    /* Unconditionally branches to a DROP
        IF cond1 rel cond2 THEN HOP location
                                        /* Conditionally branches to a DROP site
        KEYPRESS                        /* Wait for a keypress (automatically
                                        /* done in any screen text screen)
        LOADFONT filename               /* Loads a VGA character set
        LOADLOGO ^Uvar^ char_count      /* Loads bit-mapped characters to
                                        /* replace a VGA text character
        LOADLOGO CLEAR                  /* Clears bit-mapped text characters
        LOCATE row col                  /* Move to a given row and column on
                                        /* the screen, can also be done with
                                        /* ^Pr,c in display string itself
        MD directory                    /* Make a subdirectory


   ^C1PgUp^C0     Previous page
   ^C1PgDn^C0     Next page
   ^C1Esc^C0 or ^C1X^C0 Pop back to previous menu
./

- *MAINCC4 Action commands (continued)
SET LOGO   /* Too many lines on the screen
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (MOUSER),(MOUSEL) SELECT
KEY (PGUP) SCREEN -1
KEY (PGDN) SCREEN +1
KEY X,(ESC) POP KEY4
/.
^C1                          Action commands (continued)                           ^C0

        MSGBOX type message             /* Displays message at primary screen
        MSGBOXA type message            /* Displays message at alternate screen
        NONE                            /* Don't do anything; only used in
                                        /* KEY assignments
        OPEN filename                   /* Opens a file for input access
        PAUSE [ seconds ]               /* Wait for seconds to pass or until
                                        /* key is pressed
        PAUSEA [ seconds ]              /* Wait on the alternate screen
        PAUSE BREAK ON                  /* Allow people to escape out of
                                        /* buffered sequences
        PAUSE BREAK OFF                 /* Don't allow people to escape
        PAUSE DEMO seconds              /* Wait specified number of seconds
                                        /* before processing next key in the
                                        /* buffer
        PLAY string                     /* Play a given musical string
        PLAY ON                         /* Activate all PLAY commands
        PLAY OFF                        /* Turn off all PLAY commands
        POP [ TOP | 1 to 20 ] [ KEYn ]  /* Return to some CALL statement
        POPUP ^label                    /* Invokes a popup menu

   ^C1PgUp^C0     Previous page
   ^C1PgDn^C0     Next page
   ^C1Esc^C0 or ^C1X^C0 Pop back to previous menu
./

- *MAINCC5 Action commands (continued)
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (MOUSER),(MOUSEL) SELECT
KEY (PGUP) SCREEN -1
KEY (PGDN) GOTO *MAINCC
KEY X,(ESC) POP KEY4
/.
^C1                          Action commands (continued)                           ^C0

        PROMPT ^Uvar^ pattern [ other parms ]
                                        /* Prompt user for some input
        PROMPTA ^Uvar^ pattern [ other parms ]
                                        /* Prompt user, secondary screen
        QUIT [ return_code ]            /* Return to DOS
        RD directory                    /* Remove a subdirectory
        READ variable list              /* Reads from ASCII-delimited file
        REDRAW                          /* Redraw the current screen
        RUN [ string ]                  /* Run a DOS command
        RUNA [ string ]                 /* Run a DOS command to the
                                        /* alternative screen
        SAVE filename                   /* Save the current screen
        SCREEN [ TOP | FIRST | -999 to 999 | BOTTOM | LAST | @1 to @999 ]
                                        /* Switch to another screen
        SELECT                          /* Allow the mouse to select options;
                                        /* only used in KEY assignments
        WRITE filename string           /* Write a line to a text file
        @ ^Uvar^ "pattern" [ other parms ] /* User prompt

   ^C1PgUp^C0     Previous page
   ^C1PgDn^C0     Next page
   ^C1Esc^C0 or ^C1X^C0 Pop back to previous menu
./

- *MAINCD Variables
KEY X,(ESC) POP KEY5
/.
^C0                               Types of Variables                               ^C0

Within The DEMO System, there are four types of variables:

  ^^_Uvar^     User-defined variables (like ^^_UPhone^)
  ^^_Evar^     DOS-environmental variables (like ^^_ECOMSPEC^)--yours is:
               ^C2^ECOMSPEC^
  &n         Variables passed in a DO statement; these allow you to pass
             parameters into a set of code, doing different things based
             on the parameter passed in
  &Pn        Variables passed in when the screens are compiled; allows you
             to have one set of control cards which can be modified
             dynamically when you compile the program.  Unless you recompiled
             these control cards without passing in a parameter, the first
             parameter should be defined as &P1.








Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCE Functions
SET LOGO   /* Too many lines already
KEY X,(ESC) POP KEY6
/.
^C1                            System-defined Functions                            ^C0

The DEMO System provides a wealth of functions approaching the depth of many
computer language products.  See the reference manual for a description of them
all but, if names are sufficient, you can use all of the following in your
programs:

%^_Add%(n,n)      %^_DriveDirOrig%      %^_Instr%(s,s)        %^_PathExist%(s)
%^_Col%           %^_DriveDirSlash%(c)  %^_Instr2%(n,s,s)     %^_PrinterReady%(n)
%^_Date%          %^_DriveLabel%(c)     %^_Left%(s,n)         %^_ReplaceStr%(s,s,s)
%^_DateOrig%      %^_DriveOrig%         %^_Len%(s)            %^_Right%(s,n)
%^_DateR2S%(n)    %^_DriveSpace%(c)     %^_Lower%(s)          %^_Row%
%^_DateS2R%(s)    %^_FieldMax%          %^_Mid%(s,n,n)        %^_Sub%(n,n)
%^_DateValid%(s)  %^_FieldNum%          %^_Mouse%             %^_Time%
%^_Dir%           %^_FileMakeTest%(s)   %^_Mult%(n,n)         %^_TimeElapsed%
%^_Display%       %^_FileDate%(s)       %^_PageDesc%          %^_TimeOrig%
%^_DisplayEGA%    %^_FileExist%(s)      %^_PageLines%         %^_TimeR2S%(n)
%^_DisplayNum%    %^_FileOrig%          %^_PageMax%           %^_TimeS2R%(s)
%^_DisplayVGA%    %^_FileOrigDir%       %^_PageName%          %^_Trim%(s)
%^_Div%(n,n)      %^_FileSize%(s)       %^_PageNum%           %^_Upper%(s)
%^_Drive%(c)      %^_FileTime%(s)       %^_PathCanMake%(s)    %^_Weekday%(s)
%^_DriveCur%      %^_FileValid%(s)
%^_DriveDir%(c)   %^_FreeEMS%

Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCF KEY commands
KEY X,(ESC) POP KEY7
/.
^C1                                  KEY commands                                  ^C0

Your screens can be mouse driven, cursor-key driven, or hot-key driven or be
some combination of all three.  Most of the menus in this demonstration are all
three.  The keys don't have to be displayed on the screen in order to make them
available; this allows you to offer universal options or even hidden options.

Key presses, including special function keys, can be trapped with a KEY command
such as:

        KEY (UP) FIELD -1
        KEY (DOWN) FIELD +1

These two commands say that an up arrow key will move the cursor field up one
field whereas the down arrow key will move the cursor field down.

The KEY command can invoke any action command, including the ability to have
your user branch to a different page in the system.





Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCG Compilation
KEY X,(ESC) POP KEY8
/.
^C1                             Compilation vs Viewing                             ^C0

The main part of The DEMO System consists of two programs.

The ^C2compiler^C0 (DEMOMAKE) reviews your control card file for syntax errors.
It tokenizes what it can.  It then reads all of your text screens and searches
for control codes in that file.  At the end of this process, the program takes
all of your files including the control card file and creates a single data file
which is then concatenated to the end of the actual The DEMO System viewer.

The combined ^C2viewer^C0/data program is what you give your customers.  They
can't tamper with the screens at all.

The shareware fee is required for the use of the compiler, not the viewer.  As a
result, you can distribute the results of your compilations to anyone without
charge.

There are also a couple of other programs tossed in with The DEMO System
including a program to capture text screens.  But the compiler/viewer are the
heart of the system.



Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- *MAINCH Color sets
KEY X,(ESC) POP KEY9
/.
^C1                                   Color sets                                   ^C0

You're allowed to use up to 8 different sets (foreground and background pairs)
of colors on any one screen.  You can use different colors, for example, for
regular text versus headers, headers as compared to menus, etc.  The colors can
be changed on each page.

The following color sets are set by default in The DEMO System.  You can toggle
between the color and monochrome settings by using ^C1Alt-C^C0.

        ^C0 This is color set 0
        ^C1 This is color set 1
        ^C2 This is color set 2
        ^C3 This is color set 3
        ^C4 This is color set 4
        ^C5 This is color set 5
        ^C6 This is color set 6
        ^C7 This is color set 7





Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

/* 
- *MAIND Creating the screens
KEY X,(ESC) POP KEY5
/.
^C1                              Creating the screens                              ^C0

Most of the pages within The DEMO System are screens of text that you want to
display for your user.  These screens can be actual screen shots of your
product, menus, help information, etc.

Most are created using a simple ^C1text editor^C0.  Colors and keyboard input
fields can be imbedded later.

Alternatively, The DEMO System includes a free screen capture utility (^C1DEMOSCRS^C0)
which captures any text screen including color attributes.  You can run this
file through the secondary processor (^C1DEMOSCRX^C0) which will convert the screen
to, among other things, something that can be used verbatim in The DEMO System,
retaining all of your original colors.









Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

/* 
- *MAINE Show me a control file
SET LOGO
KEY X,(ESC) POP KEY6
KEY (PGDN) SCREEN +1
/.
^C1                            Show me a control file!                             ^C0

Let's see a simple control file.  This one gives the user a menu of three
choices.  If they select the first option, the program will beep.  The second
option prints an inane message.  The third returns them to the previous screen.
Full mouse support is provided.  Press ^C1PgDn^C0 to see how this screen turns out.

        - *ShowMe! Sample control file
        SET MOUSE ON
        SET CURSOR ^^_C2(^^_T3)
        KEY (MOUSER),(MOUSEL) SELECT
        KEY (UP) FIELD -1
        KEY (DOWN) FIELD +1
        KEY @1,A BEEP
        KEY @2,B ECHO ^^_P20,1You selected the second option
        KEY @3,C,(ESC) POP
        /.
                  Select something:

             ^^_K  1  Beep
             ^^_K  2  Display message
             ^^_K  3  (or Esc) Quit
        ./

Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

; Note that this is a direct copy of the above program
- *ShowMe! Sample control file
SET MOUSE ON
SET CURSOR ^C2(^T3)
KEY (MOUSER),(MOUSEL) SELECT
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY @1,A BEEP
KEY @2,B ECHO ^P20,1You selected the second option
KEY @3,C,(ESC) POP
/.
          Select something:

     ^K  1  Beep
     ^K  2  Display message
     ^K  3  (or Esc) Quit
./

/* 
- *MAINF Demo of features
SET CURSOR ^C2(^T2)^T40
SET MOUSE ON
KEY (MOUSER),(MOUSEL) SELECT
KEY (UP) FIELD -1
KEY (DOWN) FIELD +1
KEY (HOME) FIELD TOP
KEY (END) FIELD BOTTOM
KEY @1,A  CALL *MAINFA  /* Pop-up menus
KEY @2,B  CALL *MAINFB  /* Help systems
KEY @3,C  CALL *MAINFC  /* Full-screen stuff
KEY @4,D  CALL @MAINFD  /* Prompting
KEY @5,E  CALL *MAINFE  /* Data-entry forms
KEY @6,F  CALL @MAINFF  /* Loading VGA fonts
KEY @7,G  CALL @MAINFG  /* Playing music
KEY @8,H  CALL @MAINFH  /* Toggle color sets
KEY @9,I  CALL @MAINFI  /* Load a graphic
KEY @10,J CALL *MAINFJ  /* Self-running demos
KEY @11,X POP KEY7
/.
^C1                                Demo of features                                ^C0

Well, you've been patient.  Now you want to see it actually do something, right?
Of course, this entire demo was written using The DEMO System so you've already
seen it do something.  But let's demo some of the other features:

                ^K A. Pop-up menus
                ^K B. Help system (with hypertext stuff)
                ^K C. Full-screen stuff
                ^K D. Prompting
                ^K E. Data-entry forms
                ^K F. Loading VGA fonts
                ^K G. Playing music
                ^K H. Toggle color sets
                ^K I. Load a graphic
                ^K J. Self-running demos

                ^K X. Return to previous menu
./

- *MAINFA Pop-up menus
KEY X,(ESC) POP
/.
^C1                                  Pop-up menus                                  ^C0

You can establish pop-up menus which do whatever you want them to do.  For
example, within this demo, there's a menu that will show up if you press ^C1F10^C0 (go
ahead!).  It gives you direct access to those areas outlined in the main menu.

Pop-ups are a very easy way of specifying common options.  They can include
break lines, hot keys, and mouse support.

You can duplicate menus such as those found in QuickBASIC, having additional
pop-up menus which come up when you press the right or left cursor button.  This
is true of the F10 menu within this demo; the second menu has direct access to
all of the demos being shown here!

Press ^C1F10^C0 to see the pop-up menu.  Then press right or left to get to the
next pop-up.







Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- ^Popup 1,1 Main pop-up menu
SET MOUSE ON
"^What is The DEMO System?"              CALL *MAINA
"Wh^y would you use it?"                 CALL *MAINB
"^Concepts and descriptions of features" CALL *MAINC
"^How are the input screens created?"    CALL *MAIND
"^Show me a control file"                CALL *MAINE
"^Demoes showing the features"           CALL *MAINF
"Re^gistration"                          CALL *MAING
"^Next popup (or use right/left)"        POPUP ^PopupF
""                                       NONE
"^Toggle color"                          CALL @MAINFH
"^Return"                                POP
"E^xit out of DEMODEMO"                  GOTO @QUIT
KEY (RIGHT),(LEFT) POPUP ^PopupF

- ^PopupF 5,1 PopUp demo of functions
SET MOUSE ON
"Pop-^up menus"            CALL *MAINFA
"^Help systems"            CALL *MAINFB
"^Full-screen stuff"       CALL *MAINFC
"^Prompting"               CALL @MAINFD
"^Data-entry forms"        CALL *MAINFE
"Loading ^VGA fonts"       CALL @MAINFF
"Playing ^music"           CALL @MAINFG
"Toggle ^color sets"       CALL @MAINFH
"Load a ^graphic"          CALL @MAINFI
"^Self-running demoes"     CALL *MAINFJ
""                         NONE
"^Return"                  POP
"E^xit out of DEMODEMO"    GOTO @QUIT

- *MAINFB Help-system including hypertext
; The following cursor will adjust to the size of the keyboard input fields
SET CURSOR ^C1^T15
SET MOUSE ON
KEY (TAB),(RIGHT) FIELD +1
KEY (S-TAB),(LEFT) FIELD -1
KEY (HOME) FIELD TOP
KEY (END) FIELD BOTTOM
KEY (MOUSER),(MOUSEL) SELECT
KEY @1 CALL *MAINFB2  /* "Help system"
KEY @2 CALL *MAINFB3  /* "Hypertext"
KEY @3 CALL *MAINFB4  /* "Index"
KEY @4,@5,X,(ESC) POP
/.
^C1                        Help system with Hypertext stuff                        ^C0

This is an example of how a help system might be done using The DEMO System.
You could easily set up a demo which had the user going to a set of help screens
if they pressed F1.  You could also have the F1 key defined to go to a different
access point depending on which screen they were in when they pressed it.

Once they were in the ^C2^Khelp system^k^C0, you could define keyboard input fields within
your help screens.  If they moved the cursor to those fields, they could go to a
different set of screens, similar to how ^C2^KHypertext^k^C0 works.  To give you an idea,
there are a few highlighted words in this screen.  Feel free to select any by
tabbing over to them.  There's also an option provided that gives you an ^C2^Kindex^k^C0
of several panels within this demo.  Feel free to tab to that as well.










As with everywhere else, press ^C2^KEsc^k^C0 or ^C2^KX^k^C0 to get out.
./

- *MAINFB2 Help system ("Help System")
SET CURSOR ^C1^T15
SET MOUSE ON
KEY (TAB),(RIGHT) FIELD +1
KEY (S-TAB),(LEFT) FIELD -1
KEY (HOME) FIELD TOP
KEY (END) FIELD BOTTOM
KEY (MOUSER),(MOUSEL) SELECT
KEY @1 POP            /* "Initial"
KEY @2 CALL *MAINFB3  /* "Hypertext"
KEY @3 CALL *MAINFB4  /* "Index"
KEY @4,@5,X,(ESC) POP
/.
^C1                                  Help system                                   ^C0

Okay.  So you selected the word "help system" on that last page.  Presumably,
you could have some separate pages here that explain what help systems are in
general and why you want to have them.  You could also have links to other
places.  In this case, the only links provided take you back to your ^C2^Kinitial^k^C0
screen, that ^C2^KHypertext^k^C0 screen, and the ^C2^Kindex^k^C0.

Notice, by the way, that most calls to these screens are being done with a
series of CALL statements, not GOTO or SCREEN statements.  Each return is being
done with a POP.  The result is that you can continuously go back to the
previous screen.  Depending on how your system was designed, you could have an
option which popped you totally out of the help system.  That wasn't implemented
here so you may have to press Esc a couple of times to get out if you've wound
your way around these screens a bit.








Press ^C2^KEsc^k^C0 or ^C2^KX^k^C0 to pop out a level of help.
./

- *MAINFB3 Help system ("Hypertext")
SET CURSOR ^C1^T15
SET MOUSE ON
KEY (TAB),(RIGHT) FIELD +1
KEY (S-TAB),(LEFT) FIELD -1
KEY (HOME) FIELD TOP
KEY (END) FIELD BOTTOM
KEY (MOUSER),(MOUSEL) SELECT
KEY @1 POP            /* "Initial"
KEY @2 CALL *MAINFB2  /* "Help system"
KEY @3 CALL *MAINFB4  /* "Index"
KEY @4,@5,X,(ESC) POP
/.
^C1                                   Hypertext                                    ^C0

Okay.  So you selected the word "hypertext" on that last page.  Presumably, you
could have some separate pages here that explain what hypertext means and how it
works and whatever.  You could also have links to other places.  In this case,
the only links provided take you back to your ^C2^Kinitial^k^C0 screen, that ^C2^KHelp system^k^C0
screen, and the ^C2^Kindex^k^C0.

Notice, by the way, that most calls to these screens are being done with a
series of CALL statements, not GOTO or SCREEN statements.  Each return is being
done with a POP.  The result is that you can continuously go back to the
previous screen.  Depending on how your system was designed, you could have an
option which popped you totally out of the help system.  That wasn't implemented
here so you may have to press Esc a couple of times to get out if you've wound
your way around these screens a bit.








Press ^C2^KEsc^k^C0 or ^C2^KX^k^C0 to pop out a level of help.
./

- *MAINFB4 Help system ("Index")
SET CURSOR ^C1^T30
SET MOUSE ON
KEY (TAB),(RIGHT) FIELD +1
KEY (S-TAB),(LEFT) FIELD -1
KEY (UP) FIELD -2
KEY (DOWN) FIELD +2
KEY (HOME) FIELD TOP
KEY (END) FIELD BOTTOM
KEY (MOUSER),(MOUSEL) SELECT
KEY @1 CALL *MAINA
KEY @2 CALL *MAINCA
KEY @3 CALL *MAINB
KEY @4 CALL *MAINCB
KEY @5 CALL *MAINC
KEY @6 CALL *MAINCC
KEY @7 CALL *MAIND
KEY @8 CALL *MAINCD
KEY @9 CALL *MAINE
KEY @10 CALL *MAINCE
KEY @11 CALL *MAINF
KEY @12 CALL *MAINCF
KEY @13 CALL *MAING
KEY @14 CALL *MAINCG
KEY @15 REDRAW
KEY @16 CALL *MAINCH
KEY @17,@18,X,(ESC) POP
/.
^C1                                    Index                                       ^C0

The "index" page would typically provide a main help sections that they could
go to.  In the case of this demo, you'll get a list of some of the basic screens
within this demo.  (This is, by the way, similar to what you'd get in this
demo if you pressed the F10 key and got the pop-up menu.)

Select information on what:

   ^KWhat is it?^k                         ^KTypes of pages^k
   ^KWhat would you use it for?^k          ^KSET commands^k
   ^KConcepts and descs of features^k      ^KAction commands^k
   ^KHow to create the screens?^k            ^KTypes of variables^k
   ^KShow me a control file^k                ^KFunctions^k
   ^KDemo of features^k                    ^KKEY commands^k
   ^KRegistration^k                        ^KCompilation vs viewing^k
   ^K ^k                                   ^KColor sets^k






Press ^KEsc^k or ^KX^k to pop out a level of help.
./

- *MAINFC Full-screen stuff
SET CURSOR ^C2(^T10)
SET MOUSE ON
KEY (MOUSER),(MOUSEL) SELECT
KEY (HOME)  FIELD FIRST
KEY (UP)    FIELD -3
KEY (DOWN)  FIELD +3
KEY (LEFT)  FIELD -1
KEY (RIGHT) FIELD +1
KEY (END)   FIELD LAST
KEY A,@1    CALL @MAINFC2 A
KEY F,@2    CALL @MAINFC2 F
KEY K,@3    CALL @MAINFC2 K
KEY B,@4    CALL @MAINFC2 B
KEY G,@5    CALL @MAINFC2 G
KEY L,@6    CALL @MAINFC2 L
KEY C,@7    CALL @MAINFC2 C
KEY H,@8    CALL @MAINFC2 H
KEY M,@9    CALL @MAINFC2 M
KEY D,@10   CALL @MAINFC2 D
KEY I,@11   CALL @MAINFC2 I
KEY E,@13   CALL @MAINFC2 E
KEY J,@14   CALL @MAINFC2 J
KEY X,@15   POP KEY4
KEY (ESC)   NONE
/.
^C1                               Full-screen stuff                                ^C0

This is an example of what you can do with The DEMO System's full-screen
selections.  You can have the program branch according to the choices selected.
Select an option using either cursor keys or the letter of the option.

        ^K  Option A       ^K  Option F         ^K  Option K
        ^K  Option B       ^K  Option G         ^K  Option L
        ^K  Option C       ^K  Option H         ^K  Option M
        ^K  Option D       ^K  Option I         ^K
        ^K  Option E       ^K  Option J         ^K  E^C1X^C0it ^k



   ^C2                                                                 ^C2
   ^C2 Notice that the Esc key doesn't work in this screen.  You can   ^C2
   ^C2 enable or disable any keys as desired.                          ^C2
   ^C2                                                                 ^C2
./

- @MAINFC2 Common subroutine showing what option you picked
ECHO ^P22,1You selected the %1% option at %Time%.  Press a key now.
PAUSE
POP

- @MAINFD Prompt stuff
/* Prompting the user for input.
CLS
ECHO ^C1                                   Prompting                                    ^C0
ECHO
ECHO Okay.  Let's prompt for something.
ECHO The pattern here is "NNNUU" -- three digits, and two letters
ECHO ^C2Enter your user ID? @
PROMPT ^UUserID^ "NNNUU" LEN=5
ECHO ^C0
ECHO      The result is ^UUserID^
ECHO The next one uses the pattern "XXX-UUU-BBB" -- B must be Y/N/T/F
ECHO ^C2Enter another one? @
PROMPT ^UAnother^ "XXX-UUU-BBB"
ECHO ^C0
ECHO      The result was ^UAnother^
ECHO The next one uses the pattern "NN/NN/NN" and must be a date field
ECHO ^C2Enter a date? @
PROMPT ^UDate^ "NN/NN/NN" TEST=%DateValid%(^UDate^) = 1
ECHO ^C0
ECHO       The result was ^UDate^
ECHO The next one requires a valid filespec (existing or not)
ECHO ^C2Enter a filespec? @
PROMPT ^UFileAny^ "50!" TEST=%FileValid%(^UFileAny^) <> (NULL)
ECHO ^C0
ECHO       The result was ^UFileAny^
ECHO The next one requires an existing filespec
ECHO ^C2Enter an existing filename? @
PROMPT ^UFileExisting^ "50!" TEST=%FileExist%(^UFileExisting^) = 1
ECHO ^C0
ECHO       The result was ^UFileExisting^
ECHO The next one requires a valid drive and tells you the default path on it
ECHO ^C2Enter a drive? @
PROMPT ^UDrive^ "!" TEST=%Drive%(^UDrive^) = 1 DEF=C
ECHO ^C0
ECHO       The result was ^UDrive^ and default path there is %DriveDir%(^UDrive^)
ECHO Press a key please
PAUSE
POP

- *MAINFE Data-entry form
; Note that the first character of each field is automatically converted
; to uppercase for them.  As it is, the %Proper% function fixes up most
; fields before writing out the record.
SET LOGO
@ ^UName^ "!25X" LEN=5
@ ^UCompany^ "!25X"
@ ^UStreet1^ "!25X" LEN=5
@ ^UStreet2^ "!25X"
@ ^UCity^ "!19X"
@ ^UState^ "!!" LEN=2
@ ^UZip^ "NNNNN-NNNN" /* Because of pattern, ZIP will be minimum of 6 chars
                      /* Could have imposed a TEST clause if you wanted.
@ ^UPhone^ "(NNN) NNN-NNNN" LEN=14
@ ^USubmit^ "!" VQUIT=S QUIT=Q DEF=E TEST=%Instr%(SEQ,^USubmit^) <> 0
IF %Upper%(^USubmit^) = Q THEN HOP Skip
ASSIGN ^UName^ = %Proper%(^UName^)
ASSIGN ^UCompany^ = %Proper%(^UCompany^)
ASSIGN ^UStreet1^ = %Proper%(^UStreet1^)
ASSIGN ^UStreet2^ = %Proper%(^UStreet2^)
ASSIGN ^UCity^ = %Proper%(^UCity^)
; Note that the trailing blanks are always removed from responses in data-
; entry forms so you can do something like "^UCity^, ^UState^ ^UZip^" and it
; will show up correctly as "Silver Spring, MD 20910".
WRITE TEST.PRN "^UName^","^UCompany^","^UStreet1^","^UStreet2^","^UCity^, ^UState^ ^UZip^","^UPhone^"
ECHO
ECHO Entry saved.
DROP Skip
/.
^C1                                Data-entry form                                 ^C0

    ^C2                                                                       ^C0
    ^C2  This example prompts you to enter someone's name, address, and phone ^C0
    ^C2  information.  Use Tab and shift-Tab to shift between fields.  Use    ^C0
    ^C2  Alt-F1 to see the required patterns.  When you opt to Submit the     ^C0
    ^C2  entry, the form entries will be saved in an ASCII-delimited format   ^C0
    ^C2  under the file name TEST.PRN.                                        ^C0
    ^C2                                                                       ^C0
    ^C2  Note that the user name and the first line of the street address     ^C0
    ^C2  have to be at least 5 characters in length, and the State and phone  ^C0
    ^C2  number have to be completely filled out.  This is user defined.      ^C0
    ^C2                                                                       ^C0

                User name:    ^K
                Company:      ^K
                Street:       ^K
                              ^K
                City, State ZIP: ^K                    , ^K   ^K

                Phone:        ^K

                Submit?:      ^K   (S=submit, Q=quit, E=continue editing)
./
POP

- @MAINFF Loading alternative VGA character fonts
/* Yeah, I know, this doesn't really belong under DOS functions...
IF %DisplayVGA% = 0 THEN HOP NoVGA
LOADFONT SUPER.F16
LOCATE 25,1
ECHO Will shift back to regular font shortly...                           @
PAUSE 5
LOADLOGO CLEAR
ASSIGN ^UBatSymbol^ =
POP
DROP NoVGA
ECHO Sorry.  You apparently don't have a VGA screen.  Press a key to continue@
KEYPRESS

- @MAINFG Seeing how the PLAY commands work
CLS
ECHO ^C1                                 Playing music                                  ^C0
ECHO
ECHO Let's try some PLAY command stuff.  Testing...
PLAY mb t180 o2 p2 p8 l8 ggg l2 e- p24 p8 l8 fff l2 d
ECHO That should still be playing.  Press a key when ready.
PAUSE
POP

- @MAINFH Toggling color set from color to monochrome and vice versa
DISPLAY TOGGLE
POP

- @MAINFI Loading a graphic file
/* Note that none of The DEMO System options while you're
/* in another program.
RUN TSHOW WAYNESOF.GIF  /* TSHOW is one of those freebie GIF viewers
/* Have to reload the symbol because the program probably screwed it
/* up.
LOADLOGO CLEAR
LOADLOGO ^UBatSymbol^ 3
DATA 221,0,24,28,60,62,63,127,127,127,255,255,255,239,206,132,128
DATA 222,66,126,126,126,126,255,255,255,255,255,255,255,255,126,60,24
DATA 224,0,24,56,60,124,252,254,254,254,255,255,255,247,115,33,1
POP

- *MAINFJ  Self-running demo example
KEY (F2) CALL @MAINFJ2
KEY X,(ESC) POP
/.
^C1                               Self-running demos                               ^C0

Okay.  Everyone's dealt with one of these crippled demo programs that has all of
the keystrokes stored for you.  You can't do anything in the demo besides watch
it and wonder "What would happen if I pressed Esc instead of F1 at that last
prompt?  Oh well, guess I'll never find out."

Using The DEMO System, you can have parts or all of your demo be self-running.
You can also have the system allow the self-running parts to be interruptable.
For example, let's say you had a demo of a bulletin board system.  One of your
menu choices within the demo is "How do download a file".  Well, you might want
to have the demo hop to the main menu screen, ask for files, ask for downloads,
enter a file name, select a protocol, and then pretend something's being
downloaded.  Or you might want to allow them to escape out part way through and
test out other options within the same menu.  You can comment everything too.

As an example of this, if you press ^C1F2^C0 now, this demo will take you back to the
main menu, hop into the "Concepts and .. Features" section and then view all of
the Action commands.  Then you'll be returned here.  Music will play part way.
Press Esc to stop part way through or just let it return here.



Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- @MAINFJ2 Actual self-running execution
; Just to let them know what they're doing
ECHO ^P24,1^C1Showing a self-running demo.@
; Pausing or the next screen will clear off this message
PAUSE 1
; You have to slow it up a bit so they can see each keystroke work
PAUSE DEMO 0.4
; You could put a PAUSE BREAK OFF to keep them from breaking out
; but we're not going to do that.
; Going to the top menu.  Note that you can't do this with a simple
; CALL or GOTO or SCREEN command because all of those would take you
; out of this screen and never process the remaining commands.  So
; you have to trick the system by defining a key that does the GOTO and
; then buffers that key for you.  Note that the key definitions are set
; and reset when the page is entered so you could not define a key here
; and expect it to work in a screen you buffered your way to.  By the way,
; you want to do a GOTO here instead of a CALL or it will try to loop
; through all of the commands on this page when it does the return.
KEY (F1) GOTO *000
BUFFER (F1)
; The BUFFER command sticks keystrokes into the keyboard input buffer
; The concepts and features item is the third input.  Make sure you're
; at the top of the menu and then go down to it.  Using (DOWN) instead of
; the hot-key so they'll be able to see it work more clearly.
BUFFER (HOME)
; Documenting what we're going for them
ECHO ^P24,1^C1Selecting the "Concepts and descriptions of features" item@
BUFFER (DOWN)(DOWN)(ENTER)
; The "Action commands" option is again the third item on the list
ECHO ^P24,1^C1Selecting the "Action commands" item@
; Might as well kick in a tune
PLAY mb t180 o2 p2 p8 l8 ggg l2 e- p24 p8 l8 fff l2 d
BUFFER (DOWN)(DOWN)(ENTER)
; There are five screens of Action commands.  Do a PgDn to cover all of
; them.
BUFFER (PGDN)(PGDN)(PGDN)(PGDN)
ECHO ^P24,1^C1Last one!@
; Now pop out of Action commands
BUFFER (ESC)
; Pop out of concepts and descriptions of features, back to main menu
BUFFER (ESC)
; Now, for the heck of it, let's scroll through all of the options in the
; main menu.  Speed things up a bit first though.
PAUSE DEMO 0.1
BUFFER (HOME)
BUFFER (DOWN)(DOWN)(DOWN)(DOWN)(DOWN)(DOWN)(DOWN)(DOWN)
; Now go back to the self-running demo screen.  You have to do a GOTO
; here or you might end up in an infinite loop.
POP

/* 
- *MAING Registration
KEY (ESC),X POP KEY8
/.
^C1                                  Registration                                  ^C0

The DEMO System that's on your disk now is the full-blown product, it's not
crippled.  If you find the product useful, you are asked to register it under
the normal shareware rules.  If you distribute any product using The DEMO
System, you ^C1have^C0 to register your copy of it.  (You can make unlimited
copies of your product, however.)

Registered users get technical support via fax (sorry, my full-time job wouldn't
understand otherwise).  They also get a program (^C1DEMOSAVE^C0) which
reverse-engineers their distribution software, allowing them to recreate the
input files from it.  They also get a command-line switch which allows them to
turn off the Wayne Software copyright notice.  Such a deal!

Registration's $50, a cheap price to pay for something which you can use as a
product demonstrator and training tool.  Think about it!  The registration
address shows up when you leave this demo.






Press ^C1X^C0 or ^C1Esc^C0 to return to the previous menu.
./

- @QUIT Quitting
; Notice we're clearing out the bat logo now.  No sense making their
; DOS session look funky.
LOADLOGO CLEAR
ECHO ^C0
CLS
ECHO Thanks for your interest in The DEMO System
ECHO
ECHO The DEMO System was written by:  Bruce Guthrie
ECHO                                  Wayne Software
ECHO                                  113 Sheffield St.
ECHO                                  Silver Spring, MD 20910
ECHO                                  fax (301) 588-8986
QUIT 5         /* Setting the return code to 5

