/*  Turbo C program to test use of BBL device driver
	Written by H. D. Todd, Wesleyan University
	August, 1992
*/

#include	<stdio.h>
#include	<conio.h>
#include	<dos.h>
#include	<time.h>

FILE *out;
void pause(void);
void mode(int m);
void hpos(int col);
void vpos(int row);

int main(void)

{	int i,j,Elapsed;
	struct time TimeOn,TimeOff;

	printf("Program to test BBL device driver\n");
	printf("When paused, press any key to continue\n\n");
	if ( (out=fopen("BBL-DRVR","wt")) == NULL) {
		fprintf(stderr, "Cannot open output file.\n");
		return 1;
	}
	printf("First, just write in the three modes\n");
	pause();


// mode 0 test
	clrscr();
	printf("Three lines in mode 0 ...");
	pause();
	clrscr();
	mode(0);
	fputs("Hello,\nWorld\nfrom BBL",out);
	pause();
	
// mode 1 test
	clrscr();
	printf("One line, 5 chars in mode 1 ...");
	pause();
	clrscr();
	mode(1);
	fputs("Hello",out);
	pause();

// mode 2 test
	clrscr();
	printf("One line, 3 chars in mode 2 ...");
	pause();
	clrscr();
	mode(2);
	fputs("BBL",out);
	pause();

// mode 0 wrap
	clrscr();
	printf("One long string, wraps to three lines in mode 1");
	pause();
	clrscr();
	mode(0);
	fputs("This line should wrap",out);
	pause();
	
// wrap in mode 1  --- scrolls
	clrscr();
	printf("One string (pause in middle) scrolls in mode 1");
	pause();
	clrscr();
	mode(1);
	fputs("Wrap ",out);
	pause();
	fputs("Scrol",out);
	pause();

// wrap in mode 2 --- scrolls
	clrscr();
	printf("One string (pause in middle) scrolls in mode 2");
	pause();
	clrscr();
	mode(2);
	fputs("Wrp",out);
	pause();
	fputs("Scl",out);
	pause();

// backspace in mode 0
	clrscr();
	printf("Test backspace in mode 0");
	pause();
	clrscr();
	mode(0);
	fputs("01234", out); 	fflush(out);
	delay(200);
	fputs("\b5",out);	fflush(out);
	delay(200);
	fputs("\b\b6",out);	fflush(out);
	delay(200);
	fputs("\b\b7",out);	fflush(out);
	delay(200);
	fputs("\b\b8",out);	fflush(out);
	delay(200);
	fputs("\b\b9",out);	fflush(out);
	pause();	

// backspace in mode 1
	clrscr();
	printf("Test backspace in mode 1");
	pause();
	clrscr();
	mode(1);
	fputs("01234", out); 	fflush(out);
	delay(200);
	fputs("\b5",out);	fflush(out);
	delay(200);
	fputs("\b\b6",out);	fflush(out);
	delay(200);
	fputs("\b\b7",out);	fflush(out);
	delay(200);
	fputs("\b\b8",out);	fflush(out);
	delay(200);
	fputs("\b\b9",out);	fflush(out);
	pause();	

// backspace in mode 2
	clrscr();
	printf("Test backspace in mode 2");
	pause();
	clrscr();
	mode(2);
	fputs("012", out); 	fflush(out);
	delay(200);
	fputs("\b3",out);	fflush(out);
	delay(200);
	fputs("\b\b4",out);	fflush(out);
	delay(200);
	fputs("\b\b5",out);	fflush(out);
	pause();	

// positioning in mode 0
	clrscr();
	printf("Test positioning in mode 0");
	pause();
	clrscr();
	mode(0);
	for (j=2;j>=0;j--) {
	    fputc('\v',out); fputc('0'+j,out);
	    for (i=0;i<5;i++) {
		fputc('\t',out); fputc('0'+i,out); fputc('0'+i,out);
		fflush(out); delay(200);
		fputc('\t',out); fputc('9'-i,out); fputc('9'-i,out); 
		fflush(out); delay(200);
	    };
	};
	pause();	


// positioning in mode 1
	clrscr();
	printf("Test positioning in mode 1");
	pause();
	clrscr();
	mode(1);
	    for (i=0;i<2;i++) {
		fputc('\t',out); fputc('0'+i,out); fputc('0'+i,out);
		fflush(out); delay(200);
		fputc('\t',out); fputc('4'-i,out); fputc('4'-i,out); 
		fflush(out); delay(200);
	    };
	fputs("\t22",out); fflush(out);
	pause();	

// positioning in mode 2
	clrscr();
	printf("Test positioning in mode 2");
	pause();
	clrscr();
	mode(2);
	fputs("\t00",out); fflush(out); delay(200);
	fputs("\t22",out); fflush(out); delay(200);
	fputs("\t11",out); fflush(out); delay(200);
	pause();	


// timing test, mode 1
	clrscr();
	printf("\nTiming test in mode 1");
	pause();
	clrscr();
	mode(1);
	gettime(&TimeOn);
	for (i=0;i<100;i++) {
		hpos(1);
		fprintf(out,"%3d",i);
		fflush(out);
	};
	gettime(&TimeOff);
	Elapsed=((((TimeOff.ti_hour-TimeOn.ti_hour)*60
		   + (TimeOff.ti_min-TimeOn.ti_min))*60
		   + (TimeOff.ti_sec-TimeOn.ti_sec))*60
		   + (TimeOff.ti_hund-TimeOn.ti_hund))*10;

	printf("\nTime for 100 iterations = %d msec\n", Elapsed);

	return 0;
}

void mode(int m)
{
	fputc('\x0e',out); fputc('0'+m,out);
}

void vpos(int row)
{
	fputc('\v',out); fputc('0'+row,out);
}

void hpos(int col)
{
	fputc('\t',out); fputc('0'+col,out);
}

void pause(void)
{
	fflush(out);
	while (!kbhit()) ;
	getch();
}

