;RM82TS8,16,24,32,40,48
; 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC BLOADHELP

.DATA
	EXTRN   B$Seg:Word          	; name of DEF SEG storage register
	EXTRN	B$DVIDEOSEG:WORD    	; video routines
	EXTRN   B$DVIDEOPORT:WORD	; retrace port address
	EXTRN   B$DVIDEOINSTL:BYTE	; test if we have defined display

.CODE
	INCLUDE NOWAIT.INC
	EXTRN	Get_Adapter:FAR
	EXTRN   B$BLOD:FAR		; QBASIC BLOAD routine

EVEN
Org_DEFSEG	DW	0		; original DEFSEG value

msr_values      db 2ch,28h,2dh,29h	; reprogram CGA values
		db 2AH,2eh,1eh,29h      ; when turn CGA back on

;============================================================================
; DECLARE SUB BLOADHELP (FileName$)
; CALL BLOADHELP(FileName$)
;
; Purpose:
;         to BLOAD helpfiles without defining size of helpfile or type of
;         display, DEFSEG location, or anything else
;
; Assumes:
;         Both BSAVED file and CRT is setup for SCREEN 0, 80 * 25
;         Routine does not provide any critical error support.
;         Minor errors will cause abort unless ON ERROR GOTO support
;         is provided to handle common errors.
;
;         FileName$ must be a near string in DGROUP, cannot be FIXED Length
;         or TYPE'd.
;============================================================================

EVEN
BLOADHELP PROC	FAR
	Push	BP
	Mov	BP,SP
	Push	SI
	Push	DI
	CLD
	Mov     AX,B$Seg                ; get original DEFSEG value
	Mov     CS:[Org_DEFSEG],AX      ; store it
	Cmp     B$DVIDEOINSTL,1         ; See if we have done this before
	JE      Didit                   ; yep, so skip ahead
	Call    Get_Adapter             ; call routine to find display type

Didit:
	Mov     AX,B$DVIDEOSEG          ; store Video seg in DEFSEG
	Mov     B$Seg,AX
	Cmp     B$DVIDEOPORT,0          ; is it a snowy CGA?
	JE      Begin                   ; nope, so do the hard work

CGA_Off:
	Mov     DX,B$DVIDEOPORT         ; load address of CGA retrace port
	CLI                             ; prevent interrupts to speed routine
	Wait_CGA_Retrace                ; wait for CGA retrace MACRO
	Mov     DX,03D8h                ; turn CGA off Mode control register
	Mov     AL,00000001b            ; bit 3 = 0 to turn off display
	Out     DX,AL
	STI                             ; turn interrupts back on

Begin:
	Mov     BX,[BP+6]               ; get string descripter address
	Mov     DX,BX                   ; store temporarily in DX
	Mov     CX,[BX]                 ; see if length of string = 0
	JCXZ    Err_Out                 ; if zero, quit, don't BLOAD
					; (you will just get an error so why
					;   bother)
	Push    DX                      ; push address of string descripter
	Xor     AX,AX                   ; push 2 other parameters
	Push    AX                      ; push 0 offset
	Push    AX                      ; push 0 (ditto?) (not sure what this
					; is for)
	Call    B$BLOD                  ; call B$BLOD routine

Err_Out:
	Cmp     B$DVIDEOPORT,0          ; is it a snowy CGA?
	JE      Finis                   ; nope, no need to turn CGA on

CGA_On:                                 ; else is snowy CGA
	CLI                             ; prevent interrupts to speed routine
	Mov     DX,03D8h                ; load CRT Mode control register
	Mov     AH,0Fh                  ; get current video mode
	Int     10h                     ;
	LEA     BX,msr_values           ; Point BX to msr_values table
	Xlat    msr_values              ; load table value depending on
					; current CGA vid mode in AL
	Out     DX,AL                   ; do it
	STI                             ; turn interrupts back on

Finis:
	Mov     AX,CS:[Org_DEFSEG]      ; restore DEFSEG
	Mov     B$Seg,AX                ; quit
	Pop     DI                      ; restore registers used
	Pop	SI
	Pop	BP
	Ret     2                       ; remove 1 (* 2) parameter from stack
BLOADHELP ENDP
END
