TITLE  'Fill Window EGA'
NAME   FILLWIN
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      fill the window with pattern                           |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call FILLWIN(0,7)                                      |
;                call FILLWINP(0,p$)                                    |
;    stack:     +06 = pixel value/string descriptor address             |
;                08 = replacement type                                  |
;  returns:      none                                                   |
;     NOTE:      first byte of pattern is shift count offset per line   |
;------------------------------------------------------------------------

PARMS           = 2
ARGaddtype      EQU [bp+08]
ARGdesc         EQU [bp+06]
ARGvalue        EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far
EXTRN FILLWINlnp:far    ;in DrawLnP
EXTRN FILLWINln:far     ;in DrawLn

FillWin_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:FillWin_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  FillWinP
FillWinP        PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGdesc
                mov     ax,[bx]         ;get string len
                dec     ax              ;less shift count
                or      ax,ax
                jle     FWPxit          ;must have length
                mov     StrLen,ax
                mov     bx,[bx+2]       ;[bx]->pattern$
                mov     ax,[bx]         ;ax=shift count
                sub     ah,ah           ;since we're getting data from
                mov     FillShift,ax    ;bytes here we need to zero ah
                mov     FillShiftOrg,ax
                inc     bx              ;[bx]->first value pattern byte
                mov     addrOff,bx      ;addrOff->first value in pattern

                mov     cx,Y1clip2      ;bottom window Y
                sub     cx,Y0clip2      ;- top Y
                cmp     cx,1
                jle     FWPxit          ;must be a valid window
                inc     cx              ;lines to do
                mov     bx,Y0clip2      ;first Y line

FW0P:           mov     ax,X0clip2
                mov     x0,ax
                mov     ax,X1clip2
                mov     x1,ax
                mov     y0,bx
                mov     y1,bx
                push    bx
                push    cx
                push    bp              ;DRAWLNP uses bp
                call    FILLWINlnp
                pop     bp
                pop     cx
                pop     bx
                inc     bx              ;next Y line
                loop    FW0P

FWPxit:         pop     di
                pop     si
                pop     ds
                mov     sp,bp
                pop     bp
                RET     PARMS*2
FillWinP        ENDP

                PUBLIC  FillWin
FillWin         PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGvalue
                mov     ax,[bx]
                mov     PixelValue,ax

                mov     cx,Y1clip2      ;bottom window Y
                sub     cx,Y0clip2      ;- top Y
                cmp     cx,1
                jle     FWxit           ;must be a valid window
                inc     cx              ;lines to do
                mov     bx,Y0clip2      ;first Y line

FW0:            mov     ax,X0clip2
                mov     x0,ax
                mov     ax,X1clip2
                mov     x1,ax
                mov     y0,bx
                mov     y1,bx
                push    bx
                push    cx
                call    FILLWINln
                pop     cx
                pop     bx
                inc     bx              ;next Y line
                loop    FW0

FWxit:          pop     di
                pop     si
                pop     ds
                mov     sp,bp
                pop     bp
                RET     PARMS*2

FillWin         ENDP

FillWin_TEXT    ENDS
                END

