' DirFun.Bas - Directory entry manipulation package.
'
'$INCLUDE: 'QB.BI'
'$INCLUDE: 'DIRFUN.BI'

DEFINT A-Z

DIM SHARED InRegsX AS RegTypeX
DIM SHARED OutRegsX AS RegTypeX

FUNCTION FindFirst (Attr, FileName$, DEntry AS DirectoryRecord, _
                         theDTA AS DataTransferArea)
InRegsX.AX = &H4E00
InRegsX.CX = Attr

 Spec$ = FileName$ + CHR$(0) ' Create an ASCIIZ version of string
 InRegsX.DS = VARSEG(Spec$)  ' Load DS:DX with
 InRegsX.DX = SADD(Spec$)    ' address of Spec$
 InterruptX &H21, InRegsX, OutRegsX

' The next line sets an error as default condition

FindFirst = OutRegsX.AX      ' assume an error
IF (OutRegsX.Flags AND 1) = 0 THEN
  TransferDTA2DIR DEntry, theDTA
  FindFirst = 0              ' Clear the assumed error condition
END IF
END FUNCTION

FUNCTION FindNext (DEntry AS DirectoryRecord, theDTA AS DataTransferArea)
theDTA.FileName = SPACE$(13)
InRegsX.AX = &H4F00
InterruptX &H21, InRegsX, OutRegsX
FindNext = OutRegsX.AX
IF (OutRegsX.Flags AND 1) = 0 THEN
  TransferDTA2DIR DEntry, theDTA
  FindNext = 0
END IF
END FUNCTION

SUB SetDTA (theDTA AS DataTransferArea)
InRegsX.AX = &H1A00
InRegsX.DS = VARSEG(theDTA)
InRegsX.DX = VARPTR(theDTA)   'Use for records
InterruptX &H21, InRegsX, OutRegsX
END SUB

SUB TransferDTA2DIR (DEntry AS DirectoryRecord, _
                     theDTA AS DataTransferArea)
DEntry.FileName = theDTA.FileName
DEntry.FileSize = theDTA.FileSize
DEntry.FileDate = theDTA.FileDate
DEntry.FileTime = theDTA.FileTime
DEntry.FileAttb = ASC(theDTA.Attribute)
END SUB
